/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.helper.beans.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelibs.robot.dbflute.helper.StringKeyMap;
import org.codelibs.robot.dbflute.helper.beans.DfBeanDesc;
import org.codelibs.robot.dbflute.helper.beans.DfCoupleProperties;
import org.codelibs.robot.dbflute.helper.beans.DfPropertyDesc;
import org.codelibs.robot.dbflute.helper.beans.exception.DfBeanFieldNotFoundException;
import org.codelibs.robot.dbflute.helper.beans.exception.DfBeanMethodNotFoundException;
import org.codelibs.robot.dbflute.helper.beans.exception.DfBeanPropertyNotFoundException;
import org.codelibs.robot.dbflute.helper.beans.impl.DfPropertyDescImpl;
import org.codelibs.robot.dbflute.util.DfReflectionUtil;
import org.codelibs.robot.dbflute.util.DfTypeUtil;
import org.codelibs.robot.dbflute.util.Srl;

public class DfBeanDescImpl
implements DfBeanDesc {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Class<?>[] EMPTY_PARAM_TYPES = new Class[0];
    protected final Class<?> _beanClass;
    protected final StringKeyMap<DfPropertyDesc> _propertyDescMap = StringKeyMap.createAsCaseInsensitive();
    protected final Map<String, Method[]> _methodsMap = new HashMap<String, Method[]>();
    protected final Map<String, Field> _fieldMap = new HashMap<String, Field>();
    protected final transient Set<String> _invalidPropertyNames = new HashSet<String>();

    public DfBeanDescImpl(Class<?> beanClass) {
        if (beanClass == null) {
            String msg = "The argument 'beanClass' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._beanClass = beanClass;
        this.setupPropertyDesc();
        this.setupMethod();
        this.setupField();
    }

    @Override
    public Class<?> getBeanClass() {
        return this._beanClass;
    }

    @Override
    public boolean hasPropertyDesc(String propertyName) {
        return this.getPropertyDescInternally(propertyName) != null;
    }

    @Override
    public DfPropertyDesc getPropertyDesc(String propertyName) throws DfBeanPropertyNotFoundException {
        DfPropertyDesc pd = this.getPropertyDescInternally(propertyName);
        if (pd == null) {
            throw new DfBeanPropertyNotFoundException(this._beanClass, propertyName);
        }
        return pd;
    }

    private DfPropertyDesc getPropertyDescInternally(String propertyName) {
        return this._propertyDescMap.get(propertyName);
    }

    @Override
    public int getPropertyDescSize() {
        return this._propertyDescMap.size();
    }

    @Override
    public List<String> getProppertyNameList() {
        return new ArrayList<String>(this._propertyDescMap.keySet());
    }

    @Override
    public boolean hasField(String fieldName) {
        return this._fieldMap.get(fieldName) != null;
    }

    @Override
    public Field getField(String fieldName) {
        Field field = this._fieldMap.get(fieldName);
        if (field == null) {
            throw new DfBeanFieldNotFoundException(this._beanClass, fieldName);
        }
        return field;
    }

    @Override
    public int getFieldSize() {
        return this._fieldMap.size();
    }

    @Override
    public Method getMethod(String methodName) throws DfBeanMethodNotFoundException {
        return this.getMethod(methodName, EMPTY_PARAM_TYPES);
    }

    @Override
    public Method getMethod(String methodName, Class<?>[] paramTypes) throws DfBeanMethodNotFoundException {
        Method method = this.getMethodNoException(methodName, paramTypes);
        if (method == null) {
            throw new DfBeanMethodNotFoundException(this._beanClass, methodName, paramTypes);
        }
        return method;
    }

    @Override
    public Method getMethodNoException(String methodName) {
        return this.getMethodNoException(methodName, EMPTY_PARAM_TYPES);
    }

    @Override
    public Method getMethodNoException(String methodName, Class<?>[] paramTypes) {
        Method[] methods = this.findMethods(methodName);
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            if (!Arrays.equals(paramTypes, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    @Override
    public Method[] getMethods(String methodName) throws DfBeanMethodNotFoundException {
        Method[] methods = this.findMethods(methodName);
        if (methods == null) {
            throw new DfBeanMethodNotFoundException(this._beanClass, methodName, null);
        }
        return methods;
    }

    @Override
    public boolean hasMethod(String methodName) {
        return this._methodsMap.get(methodName) != null;
    }

    protected Method[] findMethods(String methodName) {
        return this._methodsMap.get(methodName);
    }

    protected void setupPropertyDesc() {
        Method[] methods = this._beanClass.getMethods();
        HashMap<String, Method> coupleMethodMap = this.hasCoupleProperties() ? new HashMap<String, Method>() : null;
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method method = methods[i];
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method)) continue;
            String methodName = method.getName();
            if (methodName.startsWith("get")) {
                if (method.getParameterTypes().length != 0 || methodName.equals("getClass") || method.getReturnType() == Void.TYPE) continue;
                propertyName = DfBeanDescImpl.initBeansProp(methodName.substring(3));
                this.setupReadMethod(method, propertyName);
                continue;
            }
            if (methodName.startsWith("is")) {
                if (method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class)) continue;
                propertyName = DfBeanDescImpl.initBeansProp(methodName.substring(2));
                this.setupReadMethod(method, propertyName);
                continue;
            }
            if (methodName.startsWith("set")) {
                if (method.getParameterTypes().length != 1 || methodName.equals("setClass") || method.getReturnType() != Void.TYPE) continue;
                propertyName = DfBeanDescImpl.initBeansProp(methodName.substring(3));
                this.setupWriteMethod(method, propertyName);
                continue;
            }
            if (coupleMethodMap == null) continue;
            this.doSetupCouplePropertyDesc(coupleMethodMap, method, methodName);
        }
        Iterator<String> i = this._invalidPropertyNames.iterator();
        while (i.hasNext()) {
            this._propertyDescMap.remove(i.next());
        }
        this._invalidPropertyNames.clear();
    }

    protected boolean hasCoupleProperties() {
        return DfCoupleProperties.class.isAssignableFrom(this._beanClass);
    }

    protected static String initBeansProp(String name) {
        return Srl.initBeansProp(name);
    }

    protected void doSetupCouplePropertyDesc(Map<String, Method> coupleMethodMap, Method method, String methodName) {
        Method coupleMethod = coupleMethodMap.get(methodName);
        if (coupleMethod != null) {
            Class<?>[] paramTypes;
            Class<?>[] coupleParamTypes = coupleMethod.getParameterTypes();
            int coupleParamLen = coupleParamTypes.length;
            if (coupleParamLen == 0) {
                Class<?>[] paramTypes2 = method.getParameterTypes();
                if (paramTypes2.length == 1 && paramTypes2[0] == coupleMethod.getReturnType()) {
                    this.setupReadMethod(coupleMethod, methodName);
                    this.setupWriteMethod(method, methodName);
                }
            } else if (coupleParamLen == 1 && (paramTypes = method.getParameterTypes()).length == 0 && method.getReturnType() == coupleParamTypes[0]) {
                this.setupReadMethod(method, methodName);
                this.setupWriteMethod(coupleMethod, methodName);
            }
        } else {
            int paramLen = method.getParameterTypes().length;
            Class<?> returnType = method.getReturnType();
            if (paramLen == 0 && returnType != Void.TYPE) {
                coupleMethodMap.put(methodName, method);
            } else if (paramLen == 1 || returnType == Void.TYPE) {
                coupleMethodMap.put(methodName, method);
            }
        }
    }

    protected void addPropertyDesc(DfPropertyDesc propertyDesc) {
        if (propertyDesc == null) {
            String msg = "The argument 'propertyDesc' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._propertyDescMap.put(propertyDesc.getPropertyName(), propertyDesc);
    }

    protected void setupReadMethod(Method readMethod, String propertyName) {
        Class<?> propertyType = readMethod.getReturnType();
        DfPropertyDesc propDesc = this.getPropertyDescInternally(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this._invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setReadMethod(readMethod);
            }
        } else {
            this.addPropertyDesc(this.createPropertyDesc(propertyName, propertyType, readMethod, null, null));
        }
    }

    protected void setupWriteMethod(Method writeMethod, String propertyName) {
        Class<?> propertyType = writeMethod.getParameterTypes()[0];
        DfPropertyDesc propDesc = this.getPropertyDescInternally(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this._invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setWriteMethod(writeMethod);
            }
        } else {
            this.addPropertyDesc(this.createPropertyDesc(propertyName, propertyType, null, writeMethod, null));
        }
    }

    protected void setupMethod() {
        Method[] methods;
        LinkedHashMap<String, ArrayList<Method>> methodListMap = new LinkedHashMap<String, ArrayList<Method>>();
        for (Method method : methods = this._beanClass.getMethods()) {
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method) || Object.class.equals(method.getDeclaringClass())) continue;
            String methodName = method.getName();
            ArrayList<Method> list = (ArrayList<Method>)methodListMap.get(methodName);
            if (list == null) {
                list = new ArrayList<Method>();
                methodListMap.put(methodName, list);
            }
            list.add(method);
        }
        for (Map.Entry entry : methodListMap.entrySet()) {
            String key = (String)entry.getKey();
            List methodList = (List)entry.getValue();
            this._methodsMap.put(key, methodList.toArray(new Method[methodList.size()]));
        }
    }

    protected void setupField() {
        this.setupFields(this._beanClass);
    }

    protected void setupFields(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            this.setupFieldsByInterface(targetClass);
        } else {
            this.setupFieldsByClass(targetClass);
        }
    }

    protected void setupFieldsByInterface(Class<?> interfaceClass) {
        this.addFields(interfaceClass);
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
    }

    protected void addFields(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            DfPropertyDesc pd;
            String fieldName = field.getName();
            if (this._fieldMap.containsKey(fieldName)) continue;
            field.setAccessible(true);
            this._fieldMap.put(fieldName, field);
            if (!DfReflectionUtil.isInstanceVariableField(field)) continue;
            if (this.hasPropertyDesc(fieldName)) {
                pd = this.getPropertyDesc(fieldName);
                pd.setField(field);
                continue;
            }
            if (!DfReflectionUtil.isPublicField(field)) continue;
            pd = this.createPropertyDesc(fieldName, field.getType(), null, null, field);
            this._propertyDescMap.put(fieldName, pd);
        }
    }

    protected void setupFieldsByClass(Class<?> targetClass) {
        this.addFields(targetClass);
        Class<?>[] interfaces = targetClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
        Class<?> superClass = targetClass.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            this.setupFieldsByClass(superClass);
        }
    }

    protected DfPropertyDesc createPropertyDesc(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Field field) {
        return new DfPropertyDescImpl(this, propertyName, propertyType, readMethod, writeMethod, field);
    }

    protected boolean adjustNumber(Class<?>[] paramTypes, Object[] args, int index) {
        if (paramTypes[index].isPrimitive()) {
            if (paramTypes[index] == Integer.TYPE) {
                args[index] = DfTypeUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.TYPE) {
                args[index] = DfTypeUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.TYPE) {
                args[index] = DfTypeUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.TYPE) {
                args[index] = DfTypeUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.TYPE) {
                args[index] = DfTypeUtil.toFloat(args[index]);
                return true;
            }
        } else {
            if (paramTypes[index] == Integer.class) {
                args[index] = DfTypeUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.class) {
                args[index] = DfTypeUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.class) {
                args[index] = DfTypeUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.class) {
                args[index] = DfTypeUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.class) {
                args[index] = DfTypeUtil.toFloat(args[index]);
                return true;
            }
        }
        return false;
    }
}

