/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.helper.stacktrace;

import org.codelibs.robot.dbflute.util.Srl;

public class InvokeNameResult {
    protected String _simpleClassName;
    protected String _methodName;
    protected int _lineNumber;
    protected int _foundIndex;
    protected int _foundFirstIndex;

    public String buildInvokeName(boolean useTestShortName) {
        String methodName = useTestShortName && this.hasTestSuffix() ? this.buildFilterMethodName() : this._methodName;
        String baseName = this._simpleClassName + "." + methodName + "()";
        String invokeName = this._lineNumber > 0 ? baseName + ":" + this._lineNumber + " -> " : baseName + " -> ";
        return invokeName;
    }

    public boolean hasTestSuffix() {
        return this._simpleClassName != null && this._simpleClassName.endsWith("Test");
    }

    protected String buildFilterMethodName() {
        int limitSize = 10;
        int reversePointSize = 20;
        int reverseIndex = 5;
        String methodName = this._methodName;
        if (this._methodName != null && this._methodName.length() > 10) {
            String suffix = "";
            if (this._methodName.length() > 20) {
                suffix = Srl.rearstring(this._methodName, 5);
            }
            methodName = this._methodName.substring(0, 10) + "..." + suffix;
        }
        return methodName;
    }

    public int getNextStartIndex() {
        return this._foundIndex + 1;
    }

    public boolean isEmptyResult() {
        return this._simpleClassName == null;
    }

    public String getSimpleClassName() {
        return this._simpleClassName;
    }

    public void setSimpleClassName(String simpleClassName) {
        this._simpleClassName = simpleClassName;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public void setMethodName(String methodName) {
        this._methodName = methodName;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    public int getFoundIndex() {
        return this._foundIndex;
    }

    public void setFoundIndex(int foundIndex) {
        this._foundIndex = foundIndex;
    }

    public int getFoundFirstIndex() {
        return this._foundFirstIndex;
    }

    public void setFoundFirstIndex(int foundFirstIndex) {
        this._foundFirstIndex = foundFirstIndex;
    }
}

