/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.codelibs.robot.dbflute.CallbackContext;
import org.codelibs.robot.dbflute.bhv.SqlStringFilter;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommand;
import org.codelibs.robot.dbflute.jdbc.StatementFactory;
import org.codelibs.robot.dbflute.resource.ResourceContext;
import org.codelibs.robot.dbflute.s2dao.sqlcommand.TnAbstractBasicSqlCommand;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.codelibs.robot.dbflute.twowaysql.SqlAnalyzer;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContext;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContextCreator;
import org.codelibs.robot.dbflute.twowaysql.node.Node;

public abstract class TnAbstractQueryDynamicCommand
extends TnAbstractBasicSqlCommand {
    public TnAbstractQueryDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    protected TnCommandContextHandler createCommandContextHandler(CommandContext context) {
        String executedSql = this.filterSqlStringByCallbackFilter(context.getSql());
        TnCommandContextHandler handler = this.newCommandContextHandler(executedSql, context);
        handler.setUpdateSQLFailureProcessTitle(this.getUpdateSQLFailureProcessTitle());
        return handler;
    }

    protected String filterSqlStringByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterQueryUpdate(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    protected TnCommandContextHandler newCommandContextHandler(String executedSql, CommandContext context) {
        return new TnCommandContextHandler(this._dataSource, this._statementFactory, executedSql, context);
    }

    protected abstract String getUpdateSQLFailureProcessTitle();

    protected CommandContext createCommandContext(String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args) {
        SqlAnalyzer analyzer = this.createSqlAnalyzer(twoWaySql);
        Node node = analyzer.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext ctx = creator.createCommandContext(args);
        node.accept(ctx);
        return ctx;
    }

    protected SqlAnalyzer createSqlAnalyzer(String twoWaySql) {
        return ResourceContext.createSqlAnalyzer(twoWaySql, true);
    }
}

