/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.twowaysql;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.twowaysql.DisplaySqlBuilder;
import org.codelibs.robot.dbflute.twowaysql.SqlTokenizer;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContext;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContextCreator;
import org.codelibs.robot.dbflute.twowaysql.exception.EndCommentNotFoundException;
import org.codelibs.robot.dbflute.twowaysql.exception.ForCommentExpressionEmptyException;
import org.codelibs.robot.dbflute.twowaysql.exception.IfCommentConditionEmptyException;
import org.codelibs.robot.dbflute.twowaysql.factory.SqlAnalyzerFactory;
import org.codelibs.robot.dbflute.twowaysql.node.BeginNode;
import org.codelibs.robot.dbflute.twowaysql.node.BindVariableNode;
import org.codelibs.robot.dbflute.twowaysql.node.ElseNode;
import org.codelibs.robot.dbflute.twowaysql.node.EmbeddedVariableNode;
import org.codelibs.robot.dbflute.twowaysql.node.ForNode;
import org.codelibs.robot.dbflute.twowaysql.node.IfNode;
import org.codelibs.robot.dbflute.twowaysql.node.LoopAbstractNode;
import org.codelibs.robot.dbflute.twowaysql.node.Node;
import org.codelibs.robot.dbflute.twowaysql.node.RootNode;
import org.codelibs.robot.dbflute.twowaysql.node.SqlConnectorAdjustable;
import org.codelibs.robot.dbflute.twowaysql.node.SqlConnectorNode;
import org.codelibs.robot.dbflute.twowaysql.node.SqlPartsNode;
import org.codelibs.robot.dbflute.util.Srl;

public class SqlAnalyzer {
    protected String _specifiedSql;
    protected boolean _blockNullParameter;
    protected SqlTokenizer _tokenizer;
    protected final Stack<Node> _nodeStack = new Stack();
    protected boolean _inBeginScope;
    protected List<String> _researchIfCommentList;
    protected List<String> _researchForCommentList;
    protected List<String> _researchBindVariableCommentList;
    protected List<String> _researchEmbeddedVariableCommentList;

    public SqlAnalyzer(String sql, boolean blockNullParameter) {
        sql = sql.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this._specifiedSql = sql;
        this._blockNullParameter = blockNullParameter;
        this._tokenizer = new SqlTokenizer(sql);
    }

    public Node analyze() {
        this.push(this.createRootNode());
        while (99 != this._tokenizer.next()) {
            this.parseToken();
        }
        return this.pop();
    }

    protected RootNode createRootNode() {
        return new RootNode();
    }

    protected void parseToken() {
        switch (this._tokenizer.getTokenType()) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
            }
        }
    }

    protected void parseSql() {
        String token = this._tokenizer.getToken();
        if (this.isElseMode()) {
            token = this.replaceString(token, "--", "");
        }
        String sql = token;
        Node node = this.peek();
        if (this.isSqlConnectorAdjustable(node)) {
            this.processSqlConnectorAdjustable(node, sql);
        } else {
            node.addChild(this.createSqlPartsNodeOutOfConnector(node, sql));
        }
    }

    protected void processSqlConnectorAdjustable(Node node, String sql) {
        SqlTokenizer st = new SqlTokenizer(sql);
        st.skipWhitespace();
        String skippedToken = st.skipToken();
        st.skipWhitespace();
        if (this.processSqlConnectorMark(node, sql)) {
            return;
        }
        if (this.processSqlConnectorCondition(node, st, skippedToken)) {
            return;
        }
        node.addChild(this.createSqlPartsNodeThroughConnector(node, sql));
    }

    protected boolean processSqlConnectorMark(Node node, String sql) {
        return this.doProcessSqlConnectorMark(node, sql, ",");
    }

    protected boolean doProcessSqlConnectorMark(Node node, String sql, String mark) {
        String ltrimmedSql = Srl.ltrim(sql);
        if (ltrimmedSql.startsWith(mark)) {
            String markSpace = mark + " ";
            String realMark = ltrimmedSql.startsWith(markSpace) ? markSpace : mark;
            node.addChild(this.createSqlConnectorNode(node, realMark, ltrimmedSql.substring(realMark.length())));
            return true;
        }
        return false;
    }

    protected boolean processSqlConnectorCondition(Node node, SqlTokenizer st, String skippedToken) {
        if ("and".equalsIgnoreCase(skippedToken) || "or".equalsIgnoreCase(skippedToken)) {
            node.addChild(this.createSqlConnectorNode(node, st.getBefore(), st.getAfter()));
            return true;
        }
        return false;
    }

    protected boolean isSqlConnectorAdjustable(Node node) {
        if (node.getChildSize() > 0) {
            return false;
        }
        return node instanceof SqlConnectorAdjustable && !this.isTopBegin(node);
    }

    protected void parseComment() {
        String comment = this._tokenizer.getToken();
        if (this.isTargetComment(comment)) {
            if (this.isBeginComment(comment)) {
                this.parseBegin();
            } else if (this.isIfComment(comment)) {
                this.parseIf();
            } else if (this.isForComment(comment)) {
                this.parseFor();
            } else if (this.isLoopVariableComment(comment)) {
                this.parseLoopVariable();
            } else {
                if (this.isEndComment(comment)) {
                    return;
                }
                this.parseCommentBindVariable();
            }
        } else if (Srl.is_NotNull_and_NotTrimmedEmpty(comment)) {
            String before = this._tokenizer.getBefore();
            String content = before.substring(before.lastIndexOf("/*"));
            this.peek().addChild(this.createSqlPartsNode(content));
        }
    }

    protected boolean isTargetComment(String comment) {
        if (Srl.is_Null_or_TrimmedEmpty(comment)) {
            return false;
        }
        return comment.startsWith("#current") || Character.isJavaIdentifierStart(comment.charAt(0));
    }

    protected boolean isBeginComment(String comment) {
        return "BEGIN".equals(comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseBegin() {
        BeginNode beginNode = this.createBeginNode();
        try {
            this._inBeginScope = true;
            this.peek().addChild(beginNode);
            this.push(beginNode);
            this.parseEnd();
        }
        finally {
            this._inBeginScope = false;
        }
    }

    protected BeginNode createBeginNode() {
        return new BeginNode(this._inBeginScope);
    }

    protected boolean isTopBegin(Node node) {
        if (!(node instanceof BeginNode)) {
            return false;
        }
        return !((BeginNode)node).isNested();
    }

    protected boolean isNestedBegin(Node node) {
        if (!(node instanceof BeginNode)) {
            return false;
        }
        return ((BeginNode)node).isNested();
    }

    protected boolean isIfComment(String comment) {
        return comment.startsWith("IF ");
    }

    protected void parseIf() {
        String comment = this._tokenizer.getToken();
        String condition = comment.substring("IF ".length()).trim();
        if (Srl.is_Null_or_TrimmedEmpty(condition)) {
            this.throwIfCommentConditionEmptyException();
        }
        IfNode ifNode = this.createIfNode(condition);
        this.peek().addChild(ifNode);
        this.push(ifNode);
        this.parseEnd();
    }

    protected IfNode createIfNode(String expr) {
        this.researchIfNeeds(this._researchIfCommentList, expr);
        return new IfNode(expr, this._specifiedSql);
    }

    protected void throwIfCommentConditionEmptyException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The condition of IF comment was empty!");
        br.addItem("Advice");
        br.addElement("Please confirm the IF comment expression.");
        br.addElement("Your IF comment might not have a condition.");
        br.addElement("For example:");
        br.addElement("  (x) - /*IF */XXX_ID = /*pmb.xxxId*/3/*END*/");
        br.addElement("  (o) - /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/");
        br.addItem("IF Comment");
        br.addElement(this._tokenizer.getToken());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new IfCommentConditionEmptyException(msg);
    }

    protected void parseElse() {
        Node parent = this.peek();
        if (!(parent instanceof IfNode)) {
            return;
        }
        IfNode ifNode = (IfNode)this.pop();
        ElseNode elseNode = new ElseNode();
        ifNode.setElseNode(elseNode);
        this.push(elseNode);
        this._tokenizer.skipWhitespace();
    }

    protected boolean isForComment(String comment) {
        return comment.startsWith("FOR ");
    }

    protected void parseFor() {
        String comment = this._tokenizer.getToken();
        String condition = comment.substring("FOR ".length()).trim();
        if (Srl.is_Null_or_TrimmedEmpty(condition)) {
            this.throwForCommentExpressionEmptyException();
        }
        ForNode forNode = this.createForNode(condition);
        this.peek().addChild(forNode);
        this.push(forNode);
        this.parseEnd();
    }

    protected ForNode createForNode(String expr) {
        this.researchIfNeeds(this._researchForCommentList, expr);
        return new ForNode(expr, this._specifiedSql);
    }

    protected boolean isLoopVariableComment(String comment) {
        return comment.startsWith("FIRST") || comment.startsWith("NEXT") || comment.startsWith("LAST");
    }

    protected void parseLoopVariable() {
        String comment = this._tokenizer.getToken();
        String code = Srl.substringFirstFront(comment, " ");
        if (Srl.is_Null_or_TrimmedEmpty(code)) {
            String msg = "Unknown loop variable comment: " + comment;
            throw new IllegalStateException(msg);
        }
        ForNode.LoopVariableType type = ForNode.LoopVariableType.codeOf(code);
        if (type == null) {
            String msg = "Unknown loop variable comment: " + comment;
            throw new IllegalStateException(msg);
        }
        String condition = comment.substring(type.name().length()).trim();
        LoopAbstractNode loopFirstNode = this.createLoopFirstNode(condition, type);
        this.peek().addChild(loopFirstNode);
        if (Srl.count(condition, "'") < 2) {
            this.push(loopFirstNode);
            this.parseEnd();
        }
    }

    protected LoopAbstractNode createLoopFirstNode(String expr, ForNode.LoopVariableType type) {
        return type.createNode(expr, this._specifiedSql);
    }

    protected void throwForCommentExpressionEmptyException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The expression of FOR comment was empty!");
        br.addItem("Advice");
        br.addElement("Please confirm the FOR comment expression.");
        br.addElement("Your FOR comment might not have an expression.");
        br.addElement("For example:");
        br.addElement("  (x) - /*FOR */XXX_ID = /*#element*/3/*END*/");
        br.addElement("  (o) - /*FOR pmb.xxxList*/XXX_ID = /*#element*/3/*END*/");
        br.addItem("FOR Comment");
        br.addElement(this._tokenizer.getToken());
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new ForCommentExpressionEmptyException(msg);
    }

    protected boolean isEndComment(String content) {
        return content != null && "END".equals(content);
    }

    protected void parseEnd() {
        int commentType = 2;
        while (99 != this._tokenizer.next()) {
            if (this._tokenizer.getTokenType() == 2 && this.isEndComment(this._tokenizer.getToken())) {
                this.pop();
                return;
            }
            this.parseToken();
        }
        this.throwEndCommentNotFoundException();
    }

    protected void throwEndCommentNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The end comment was not found!");
        br.addItem("Advice");
        br.addElement("Please confirm the parameter comment logic.");
        br.addElement("It may exist the parameter comment that DOESN'T have an end comment.");
        br.addElement("For example:");
        br.addElement("  (x): /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3");
        br.addElement("  (o): /*IF pmb.xxxId != null*/XXX_ID = /*pmb.xxxId*/3/*END*/");
        br.addItem("Specified SQL");
        br.addElement(this._specifiedSql);
        String msg = br.buildExceptionMessage();
        throw new EndCommentNotFoundException(msg);
    }

    protected void parseCommentBindVariable() {
        String expr = this._tokenizer.getToken();
        String testValue = this._tokenizer.skipToken(true);
        if (expr.startsWith("$")) {
            if (expr.startsWith("$$")) {
                String realExpr = expr.substring("$$".length());
                this.peek().addChild(this.createEmbeddedVariableNode(realExpr, testValue, true, false));
            } else if (expr.startsWith("$.")) {
                String realExpr = expr.substring("$.".length());
                this.peek().addChild(this.createEmbeddedVariableNode(realExpr, testValue, false, true));
            } else {
                String realExpr = expr.substring("$".length());
                this.peek().addChild(this.createEmbeddedVariableNode(realExpr, testValue, false, false));
            }
        } else {
            this.peek().addChild(this.createBindVariableNode(expr, testValue));
        }
    }

    protected void parseBindVariable() {
        String expr = this._tokenizer.getToken();
        this.peek().addChild(this.createBindVariableNode(expr, null));
    }

    protected BindVariableNode createBindVariableNode(String expr, String testValue) {
        this.researchIfNeeds(this._researchBindVariableCommentList, expr);
        return new BindVariableNode(expr, testValue, this._specifiedSql, this._blockNullParameter);
    }

    protected EmbeddedVariableNode createEmbeddedVariableNode(String expr, String testValue, boolean replaceOnly, boolean terminalDot) {
        this.researchIfNeeds(this._researchEmbeddedVariableCommentList, expr);
        return new EmbeddedVariableNode(expr, testValue, this._specifiedSql, this._blockNullParameter, replaceOnly, terminalDot);
    }

    protected SqlConnectorNode createSqlConnectorNode(Node node, String connector, String sqlParts) {
        if (this.isNestedBegin(node)) {
            return SqlConnectorNode.createSqlConnectorNodeAsIndependent(connector, sqlParts);
        }
        return SqlConnectorNode.createSqlConnectorNode(connector, sqlParts);
    }

    protected SqlPartsNode createSqlPartsNodeOutOfConnector(Node node, String sqlParts) {
        if (this.isTopBegin(node)) {
            return SqlPartsNode.createSqlPartsNodeAsIndependent(sqlParts);
        }
        return this.createSqlPartsNode(sqlParts);
    }

    protected SqlPartsNode createSqlPartsNodeThroughConnector(Node node, String sqlParts) {
        if (this.isNestedBegin(node)) {
            return SqlPartsNode.createSqlPartsNodeAsIndependent(sqlParts);
        }
        return this.createSqlPartsNode(sqlParts);
    }

    protected SqlPartsNode createSqlPartsNode(String sqlParts) {
        return SqlPartsNode.createSqlPartsNode(sqlParts);
    }

    protected Node pop() {
        return this._nodeStack.pop();
    }

    protected Node peek() {
        return this._nodeStack.peek();
    }

    protected void push(Node node) {
        this._nodeStack.push(node);
    }

    protected boolean isElseMode() {
        for (int i = 0; i < this._nodeStack.size(); ++i) {
            if (!(this._nodeStack.get(i) instanceof ElseNode)) continue;
            return true;
        }
        return false;
    }

    public List<String> researchIfComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchIfCommentList = resultList;
        return resultList;
    }

    public List<String> researchBindVariableComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchBindVariableCommentList = resultList;
        return resultList;
    }

    public List<String> researchEmbeddedVariableComment() {
        ArrayList<String> resultList = new ArrayList<String>();
        this._researchEmbeddedVariableCommentList = resultList;
        return resultList;
    }

    protected void researchIfNeeds(List<String> researchList, String expr) {
        if (researchList != null) {
            researchList.add(expr);
        }
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    public static String convertTwoWaySql2DisplaySql(SqlAnalyzerFactory factory, String twoWaySql, Object arg, String logDateFormat, String logTimestampFormat) {
        String[] argNames = new String[]{"pmb"};
        Class[] argTypes = new Class[]{arg.getClass()};
        Object[] args = new Object[]{arg};
        return SqlAnalyzer.convertTwoWaySql2DisplaySql(factory, twoWaySql, argNames, argTypes, args, logDateFormat, logTimestampFormat);
    }

    public static String convertTwoWaySql2DisplaySql(SqlAnalyzerFactory factory, String twoWaySql, String[] argNames, Class<?>[] argTypes, Object[] args, String logDateFormat, String logTimestampFormat) {
        SqlAnalyzer parser = SqlAnalyzer.createSqlAnalyzer4DisplaySql(factory, twoWaySql);
        Node node = parser.analyze();
        CommandContextCreator creator = new CommandContextCreator(argNames, argTypes);
        CommandContext context = creator.createCommandContext(args);
        node.accept(context);
        String preparedSql = context.getSql();
        DisplaySqlBuilder builder = new DisplaySqlBuilder(logDateFormat, logTimestampFormat);
        return builder.buildDisplaySql(preparedSql, context.getBindVariables());
    }

    protected static SqlAnalyzer createSqlAnalyzer4DisplaySql(SqlAnalyzerFactory factory, String twoWaySql) {
        if (factory == null) {
            String msg = "The factory of SQL analyzer should exist.";
            throw new IllegalStateException(msg);
        }
        boolean blockNullParameter = false;
        SqlAnalyzer created = factory.create(twoWaySql, false);
        if (created != null) {
            return created;
        }
        String msg = "The factory should not return null:";
        msg = msg + " sql=" + twoWaySql + " factory=" + factory;
        throw new IllegalStateException(msg);
    }
}

