/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.twowaysql.node;

import java.util.List;
import org.codelibs.robot.dbflute.cbean.coption.LikeSearchOption;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContext;
import org.codelibs.robot.dbflute.twowaysql.node.AbstractNode;
import org.codelibs.robot.dbflute.twowaysql.node.LoopAcceptable;
import org.codelibs.robot.dbflute.twowaysql.node.LoopInfo;
import org.codelibs.robot.dbflute.twowaysql.node.NodeUtil;
import org.codelibs.robot.dbflute.twowaysql.node.ValueAndType;
import org.codelibs.robot.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.codelibs.robot.dbflute.util.Srl;

public abstract class VariableNode
extends AbstractNode
implements LoopAcceptable {
    protected static final String INLOOP_OPTION_LIKE_PREFIX = "likePrefix";
    protected static final String INLOOP_OPTION_LIKE_SUFFIX = "likeSuffix";
    protected static final String INLOOP_OPTION_LIKE_CONTAIN = "likeContain";
    protected static final String INLOOP_OPTION_NOT_LIKE = "notLike";
    protected final String _expression;
    protected final String _testValue;
    protected final String _optionDef;
    protected final List<String> _nameList;
    protected final String _specifiedSql;
    protected final boolean _blockNullParameter;

    public VariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        if (expression.contains(":")) {
            this._expression = Srl.substringFirstFront(expression, ":").trim();
            this._optionDef = Srl.substringFirstRear(expression, ":").trim();
        } else {
            this._expression = expression;
            this._optionDef = null;
        }
        this._testValue = testValue;
        this._nameList = Srl.splitList(this._expression, ".");
        this._specifiedSql = specifiedSql;
        this._blockNullParameter = blockNullParameter;
    }

    @Override
    public void accept(CommandContext ctx) {
        this.doAccept(ctx, null);
    }

    @Override
    public void accept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        if (firstName.equals("#current")) {
            Object parameter = loopInfo.getCurrentParameter();
            Class<?> parameterType = loopInfo.getCurrentParameterType();
            this.doAccept(ctx, parameter, parameterType, loopInfo, true);
        } else {
            this.doAccept(ctx, loopInfo);
        }
    }

    protected void doAccept(CommandContext ctx, LoopInfo loopInfo) {
        String firstName = this._nameList.get(0);
        this.assertFirstNameAsNormal(ctx, firstName);
        Object firstValue = ctx.getArg(firstName);
        Class<?> firstType = ctx.getArgType(firstName);
        this.doAccept(ctx, firstValue, firstType, loopInfo, false);
    }

    protected void doAccept(CommandContext ctx, Object firstValue, Class<?> firstType, LoopInfo loopInfo, boolean inheritLoop) {
        this.assertInLoopOnlyOptionInLoop(loopInfo);
        ValueAndType valueAndType = new ValueAndType();
        valueAndType.setFirstValue(firstValue);
        valueAndType.setFirstType(firstType);
        this.setupValueAndType(valueAndType);
        this.processLikeSearch(valueAndType, loopInfo, inheritLoop);
        if (this._blockNullParameter && valueAndType.getTargetValue() == null) {
            this.throwBindOrEmbeddedCommentParameterNullValueException(valueAndType);
        }
        this.doProcess(ctx, valueAndType, loopInfo);
    }

    protected abstract void doProcess(CommandContext var1, ValueAndType var2, LoopInfo var3);

    protected void assertFirstNameAsNormal(CommandContext ctx, String firstName) {
        if (NodeUtil.isCurrentVariableOutOfScope(firstName, false)) {
            this.throwLoopCurrentVariableOutOfForCommentException();
        }
        if (NodeUtil.isWrongParameterBeanName(firstName, ctx)) {
            this.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException();
        }
    }

    protected void throwLoopCurrentVariableOutOfForCommentException() {
        NodeUtil.throwLoopCurrentVariableOutOfForCommentException(this._expression, this._specifiedSql);
    }

    protected void setupValueAndType(ValueAndType valueAndType) {
        ValueAndTypeSetupper.CommentType type = this.getCommentType();
        ValueAndTypeSetupper setuper = new ValueAndTypeSetupper(this._nameList, this._expression, this._specifiedSql, type);
        setuper.setupValueAndType(valueAndType);
    }

    protected abstract ValueAndTypeSetupper.CommentType getCommentType();

    protected void processLikeSearch(ValueAndType valueAndType, LoopInfo loopInfo, boolean inheritLoop) {
        if (!this.isAcceptableLikeSearch(loopInfo)) {
            return;
        }
        LikeSearchOption inLoopForcedLikeSearchOption = this.getInLoopForcedLikeSearchOption(loopInfo);
        if (inLoopForcedLikeSearchOption != null) {
            valueAndType.setLikeSearchOption(inLoopForcedLikeSearchOption);
        } else if (inheritLoop) {
            valueAndType.inheritLikeSearchOptionIfNeeds(loopInfo);
        }
        valueAndType.filterValueByOptionIfNeeds();
    }

    protected boolean isAcceptableLikeSearch(LoopInfo loopInfo) {
        List<String> optionList;
        return loopInfo == null || !Srl.is_NotNull_and_NotTrimmedEmpty(this._optionDef) || !(optionList = Srl.splitListTrimmed(this._optionDef, "|")).contains(INLOOP_OPTION_NOT_LIKE);
    }

    protected LikeSearchOption getInLoopForcedLikeSearchOption(LoopInfo loopInfo) {
        if (Srl.is_NotNull_and_NotTrimmedEmpty(this._optionDef)) {
            List<String> optionList = Srl.splitListTrimmed(this._optionDef, "|");
            for (String option : optionList) {
                if (option.equals(INLOOP_OPTION_LIKE_PREFIX)) {
                    return new LikeSearchOption().likePrefix();
                }
                if (option.equals(INLOOP_OPTION_LIKE_SUFFIX)) {
                    return new LikeSearchOption().likeSuffix();
                }
                if (!option.equals(INLOOP_OPTION_LIKE_CONTAIN)) continue;
                return new LikeSearchOption().likeContain();
            }
        }
        return null;
    }

    protected void assertInLoopOnlyOptionInLoop(LoopInfo loopInfo) {
        if (loopInfo == null && Srl.is_NotNull_and_NotTrimmedEmpty(this._optionDef)) {
            String onlyInLoop = INLOOP_OPTION_NOT_LIKE;
            List<String> optionList = Srl.splitListTrimmed(this._optionDef, "|");
            for (String option : optionList) {
                if (!INLOOP_OPTION_NOT_LIKE.equals(option)) continue;
                this.throwInLoopOptionOutOfLoopException();
            }
        }
    }

    protected void setupRearOption(CommandContext ctx, ValueAndType valueAndType) {
        String rearOption = valueAndType.buildRearOptionOnSql();
        if (Srl.is_NotNull_and_NotTrimmedEmpty(rearOption)) {
            ctx.addSql(rearOption);
        }
    }

    protected boolean isInScope() {
        if (this._testValue == null) {
            return false;
        }
        return this._testValue.startsWith("(") && this._testValue.endsWith(")");
    }

    protected void throwBindOrEmbeddedCommentParameterNullValueException(ValueAndType valueAndType) {
        Class<?> targetType = valueAndType.getTargetType();
        NodeUtil.throwBindOrEmbeddedCommentParameterNullValueException(this._expression, targetType, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentInScopeNotListException(ValueAndType valueAndType) {
        Class<?> targetType = valueAndType.getTargetType();
        NodeUtil.throwBindOrEmbeddedCommentInScopeNotListException(this._expression, targetType, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException() {
        NodeUtil.throwBindOrEmbeddedCommentIllegalParameterBeanSpecificationException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentParameterEmptyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterEmptyListException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwBindOrEmbeddedCommentParameterNullOnlyListException() {
        NodeUtil.throwBindOrEmbeddedCommentParameterNullOnlyListException(this._expression, this._specifiedSql, this.isBind());
    }

    protected void throwInLoopOptionOutOfLoopException() {
        NodeUtil.throwInLoopOptionOutOfLoopException(this._expression, this._specifiedSql, this._optionDef);
    }

    protected boolean isBind() {
        return this.getCommentType().equals((Object)ValueAndTypeSetupper.CommentType.BIND);
    }

    public String getExpression() {
        return this._expression;
    }

    public String getTestValue() {
        return this._testValue;
    }

    public String getOptionDef() {
        return this._optionDef;
    }

    public boolean isBlockNullParameter() {
        return this._blockNullParameter;
    }
}

