/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.base;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.stdlib.DropRecordBuilder;
import org.kitesdk.morphline.stdlib.PipeBuilder;

public final class Compiler {
    private static final Object LOCK = new Object();

    public Command compile(File morphlineFile, String morphlineId, MorphlineContext morphlineContext, Command finalChild, Config ... overrides) {
        Config config;
        try {
            config = this.parse(morphlineFile, overrides);
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot parse morphline file: " + morphlineFile, null, e);
        }
        Config morphlineConfig = this.find(morphlineId, config, morphlineFile.getPath());
        Command morphlineCommand = this.compile(morphlineConfig, morphlineContext, finalChild);
        return morphlineCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config parse(File file, Config ... overrides) throws IOException {
        if (file == null || file.getPath().trim().length() == 0) {
            throw new MorphlineCompilationException("Missing morphlineFile parameter", null);
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file);
        }
        if (!file.canRead()) {
            throw new IOException("Insufficient permissions to read file: " + file);
        }
        Config config = ConfigFactory.parseFile((File)file);
        for (Config override : overrides) {
            config = override.withFallback((ConfigMergeable)config);
        }
        Object object = LOCK;
        synchronized (object) {
            ConfigFactory.invalidateCaches();
            config = ConfigFactory.load((Config)config);
            config.checkValid(ConfigFactory.defaultReference(), new String[0]);
        }
        return config;
    }

    public Config find(String morphlineId, Config config, String nameForErrorMsg) {
        List morphlineConfigs = config.getConfigList("morphlines");
        if (morphlineConfigs.size() == 0) {
            throw new MorphlineCompilationException("Morphline file must contain at least one morphline: " + nameForErrorMsg, null);
        }
        if (morphlineId != null) {
            morphlineId = morphlineId.trim();
        }
        if (morphlineId != null && morphlineId.length() == 0) {
            morphlineId = null;
        }
        Config morphlineConfig = null;
        if (morphlineId == null) {
            morphlineConfig = (Config)morphlineConfigs.get(0);
            Preconditions.checkNotNull((Object)morphlineConfig);
        } else {
            for (Config candidate : morphlineConfigs) {
                if (!morphlineId.equals(new Configs().getString(candidate, "id", null))) continue;
                morphlineConfig = candidate;
                break;
            }
            if (morphlineConfig == null) {
                throw new MorphlineCompilationException("Morphline id '" + morphlineId + "' not found in morphline file: " + nameForErrorMsg, null);
            }
        }
        return morphlineConfig;
    }

    public Command compile(Config morphlineConfig, MorphlineContext morphlineContext, Command finalChild) {
        if (finalChild == null) {
            finalChild = new DropRecordBuilder().build(null, null, null, morphlineContext);
        }
        return new PipeBuilder().build(morphlineConfig, null, finalChild, morphlineContext);
    }
}

