/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;

public final class AddCurrentTimeBuilder
implements CommandBuilder {
    public static final String FIELD_NAME = "field";
    public static final String PRESERVE_EXISTING_NAME = "preserveExisting";

    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("addCurrentTime");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new AddCurrentTime(this, config, parent, child, context);
    }

    private static final class AddCurrentTime
    extends AbstractCommand {
        private String fieldName;
        private boolean preserveExisting;

        public AddCurrentTime(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, AddCurrentTimeBuilder.FIELD_NAME, "timestamp");
            this.preserveExisting = this.getConfigs().getBoolean(config, AddCurrentTimeBuilder.PRESERVE_EXISTING_NAME, true);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (!this.preserveExisting || !record.getFields().containsKey((Object)this.fieldName)) {
                record.replaceValues(this.fieldName, System.currentTimeMillis());
            }
            return super.doProcess(record);
        }
    }
}

