/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;

public final class HeadBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("head");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Head(this, config, parent, child, context);
    }

    private static final class Head
    extends AbstractCommand {
        private final long limit;
        private long count = 0L;

        public Head(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.limit = this.getConfigs().getLong(config, "limit", -1L);
            if (this.limit < -1L) {
                throw new MorphlineCompilationException("Illegal limit: " + this.limit, config);
            }
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (this.limit >= 0L && this.count >= this.limit) {
                return true;
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("headCount: {}", (Object)this.count);
            }
            ++this.count;
            return super.doProcess(record);
        }
    }
}

