/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CachedDNSToSwitchMapping
extends AbstractDNSToSwitchMapping {
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();
    protected final DNSToSwitchMapping rawMapping;

    public CachedDNSToSwitchMapping(DNSToSwitchMapping rawMapping) {
        this.rawMapping = rawMapping;
    }

    private List<String> getUncachedHosts(List<String> names) {
        ArrayList<String> unCachedHosts = new ArrayList<String>(names.size());
        for (String name : names) {
            if (this.cache.get(name) != null) continue;
            unCachedHosts.add(name);
        }
        return unCachedHosts;
    }

    private void cacheResolvedHosts(List<String> uncachedHosts, List<String> resolvedHosts) {
        if (resolvedHosts != null) {
            for (int i = 0; i < uncachedHosts.size(); ++i) {
                this.cache.put(uncachedHosts.get(i), resolvedHosts.get(i));
            }
        }
    }

    private List<String> getCachedHosts(List<String> names) {
        ArrayList<String> result = new ArrayList<String>(names.size());
        for (String name : names) {
            String networkLocation = this.cache.get(name);
            if (networkLocation != null) {
                result.add(networkLocation);
                continue;
            }
            return null;
        }
        return result;
    }

    @Override
    public List<String> resolve(List<String> names) {
        names = NetUtils.normalizeHostNames(names);
        ArrayList<String> result = new ArrayList<String>(names.size());
        if (names.isEmpty()) {
            return result;
        }
        List<String> uncachedHosts = this.getUncachedHosts(names);
        List<String> resolvedHosts = this.rawMapping.resolve(uncachedHosts);
        this.cacheResolvedHosts(uncachedHosts, resolvedHosts);
        return this.getCachedHosts(names);
    }

    @Override
    public Map<String, String> getSwitchMap() {
        HashMap<String, String> switchMap = new HashMap<String, String>(this.cache);
        return switchMap;
    }

    public String toString() {
        return "cached switch mapping relaying to " + this.rawMapping;
    }

    @Override
    public boolean isSingleSwitch() {
        return CachedDNSToSwitchMapping.isMappingSingleSwitch(this.rawMapping);
    }

    @Override
    public void reloadCachedMappings() {
        this.cache.clear();
    }
}

