/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.extractor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.extractor.Extractor;
import org.seasar.framework.util.StringUtil;

public class ExtractorFactory {
    protected Map<String, Extractor> extractorMap = new HashMap<String, Extractor>();

    public void addExtractor(String key, Extractor extractor) {
        if (StringUtil.isBlank((String)key)) {
            throw new RobotSystemException("The key is null.");
        }
        if (extractor == null) {
            throw new RobotSystemException("The extractor is null.");
        }
        this.extractorMap.put(key, extractor);
    }

    public void addExtractor(List<String> keyList, Extractor extractor) {
        if (keyList == null || keyList.isEmpty()) {
            throw new RobotSystemException("The key list is empty.");
        }
        for (String key : keyList) {
            this.addExtractor(key, extractor);
        }
    }

    public Extractor getExtractor(String key) {
        return this.extractorMap.get(key);
    }
}

