/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.processor.impl;

import java.io.InputStream;
import java.util.LinkedHashSet;
import org.codelibs.robot.builder.RequestDataBuilder;
import org.codelibs.robot.client.fs.ChildUrlsException;
import org.codelibs.robot.entity.RequestData;
import org.codelibs.robot.entity.ResponseData;
import org.codelibs.robot.entity.Sitemap;
import org.codelibs.robot.entity.SitemapSet;
import org.codelibs.robot.helper.SitemapsHelper;
import org.codelibs.robot.processor.ResponseProcessor;
import org.seasar.framework.container.SingletonS2Container;

public class SitemapsResponseProcessor
implements ResponseProcessor {
    @Override
    public void process(ResponseData responseData) {
        SitemapsHelper sitemapsHelper = (SitemapsHelper)SingletonS2Container.getComponent(SitemapsHelper.class);
        InputStream responseBody = responseData.getResponseBody();
        SitemapSet sitemapSet = sitemapsHelper.parse(responseBody);
        LinkedHashSet<RequestData> requestDataSet = new LinkedHashSet<RequestData>();
        for (Sitemap sitemap : sitemapSet.getSitemaps()) {
            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(sitemap.getLoc()).build());
        }
        throw new ChildUrlsException(requestDataSet);
    }
}

