/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.analysis.monitor;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jp.sf.fess.solr.plugin.analysis.monitor.MonitoringTask;
import jp.sf.fess.solr.plugin.util.MonitoringUtil;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.AttributeSource;

public class MonitoringTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private static final boolean VERBOSE = false;
    protected ResourceLoader loader;
    protected TokenFilterFactory baseTokenFilterFactory;
    protected final Map<String, String> baseArgs;
    protected String baseClass;
    protected MonitoringTask monitoringTask;
    protected volatile long factoryTimestamp;
    protected Field attributesField;
    protected Field attributeImplsField;
    protected Field currentStateField;

    public MonitoringTokenFilterFactory(Map<String, String> args) {
        super(args);
        try {
            this.attributesField = AttributeSource.class.getDeclaredField("attributes");
            this.attributesField.setAccessible(true);
            this.attributeImplsField = AttributeSource.class.getDeclaredField("attributeImpls");
            this.attributeImplsField.setAccessible(true);
            this.currentStateField = AttributeSource.class.getDeclaredField("currentState");
            this.currentStateField.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load fields.", e);
        }
        this.baseArgs = new HashMap<String, String>(args);
    }

    public void inform(final ResourceLoader loader) throws IOException {
        this.loader = loader;
        Map<String, String> monitorArgs = MonitoringUtil.createMonitorArgs(this.baseArgs);
        this.baseClass = MonitoringUtil.initBaseArgs(this.baseArgs, this.luceneMatchVersion.toString());
        this.baseTokenFilterFactory = (TokenFilterFactory)MonitoringUtil.createFactory(this.baseClass, this.baseArgs, loader);
        this.factoryTimestamp = System.currentTimeMillis();
        this.monitoringTask = MonitoringUtil.createMonitoringTask(monitorArgs, loader, new MonitoringTask.Callback(){

            @Override
            public void process() {
                MonitoringTokenFilterFactory.this.baseTokenFilterFactory = (TokenFilterFactory)MonitoringUtil.createFactory(MonitoringTokenFilterFactory.this.baseClass, MonitoringTokenFilterFactory.this.baseArgs, loader);
                MonitoringTokenFilterFactory.this.factoryTimestamp = System.currentTimeMillis();
            }
        });
        if (this.baseTokenFilterFactory instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)this.baseTokenFilterFactory).inform(loader);
        }
    }

    public TokenStream create(TokenStream input) {
        return new TokenStreamWrapper(input);
    }

    public class TokenStreamWrapper
    extends TokenStream {
        protected TokenStream tokenStream;
        protected TokenStream input;
        protected long tokenStreamTimestamp;

        TokenStreamWrapper(TokenStream input) {
            this.input = input;
            this.tokenStream = this.createTokenStream(input);
        }

        public void close() throws IOException {
            this.tokenStream.close();
        }

        public void reset() throws IOException {
            if (MonitoringTokenFilterFactory.this.factoryTimestamp > this.tokenStreamTimestamp) {
                this.tokenStream = this.createTokenStream(this.input);
            }
            this.tokenStream.reset();
            MonitoringTokenFilterFactory.this.monitoringTask.process();
        }

        public boolean incrementToken() throws IOException {
            return this.tokenStream.incrementToken();
        }

        public void end() throws IOException {
            this.tokenStream.end();
        }

        public int hashCode() {
            return this.tokenStream.hashCode();
        }

        public boolean equals(Object obj) {
            return this.tokenStream.equals(obj);
        }

        public String toString() {
            return this.tokenStream.toString();
        }

        protected TokenStream createTokenStream(TokenStream input) {
            this.tokenStreamTimestamp = MonitoringTokenFilterFactory.this.factoryTimestamp;
            TokenStream newTokenStream = MonitoringTokenFilterFactory.this.baseTokenFilterFactory.create(input);
            try {
                Object attributesObj = MonitoringTokenFilterFactory.this.attributesField.get(newTokenStream);
                MonitoringTokenFilterFactory.this.attributesField.set((Object)this, attributesObj);
                Object attributeImplsObj = MonitoringTokenFilterFactory.this.attributeImplsField.get(newTokenStream);
                MonitoringTokenFilterFactory.this.attributeImplsField.set((Object)this, attributeImplsObj);
                Object currentStateObj = MonitoringTokenFilterFactory.this.currentStateField.get(newTokenStream);
                MonitoringTokenFilterFactory.this.currentStateField.set((Object)this, currentStateObj);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to update the tokenStream.", e);
            }
            return newTokenStream;
        }
    }
}

