/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassLoaderUtil {
    private static final boolean SIMPLE_MODE = false;
    private static final boolean FALL_BACK = true;
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderUtil.class);

    private ClassLoaderUtil() {
    }

    public static Object newInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz;
        ClassLoader classLoader = new ClassLoaderFinder().getContextClassLoader();
        if (classLoader == null) {
            LOG.debug("No context class loader found");
            clazz = Class.forName(className);
        } else {
            LOG.debug("Context class loader found");
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                LOG.debug("Fall back to current classloader");
                classLoader = ClassLoaderUtil.class.getClassLoader();
                clazz = classLoader.loadClass(className);
            }
        }
        return clazz.newInstance();
    }

    private static final class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        public ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

