/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.codelibs.core.exception.BadPaddingRuntimeException;
import org.codelibs.core.exception.IllegalBlockSizeRuntimeException;
import org.codelibs.core.exception.InvalidKeyRuntimeException;
import org.codelibs.core.exception.NoSuchAlgorithmRuntimeException;
import org.codelibs.core.exception.NoSuchPaddingRuntimeException;
import org.codelibs.core.exception.UnsupportedEncodingRuntimeException;
import org.codelibs.core.util.Base64Util;

public class CachedCipher {
    private static final String BLOWFISH = "Blowfish";
    private static final String RSA = "RSA";
    public String algorithm = "Blowfish";
    public String transformation = "RSA";
    public String key;
    public String charsetName = "UTF-8";
    protected Queue<Cipher> encryptoQueue = new ConcurrentLinkedQueue<Cipher>();
    protected Queue<Cipher> decryptoQueue = new ConcurrentLinkedQueue<Cipher>();

    public byte[] encrypto(byte[] data) {
        byte[] encrypted;
        Cipher cipher = this.pollEncryptoCipher();
        try {
            encrypted = cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalBlockSizeRuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new BadPaddingRuntimeException(e);
        }
        finally {
            this.offerEncryptoCipher(cipher);
        }
        return encrypted;
    }

    public byte[] encrypto(byte[] data, Key key) {
        byte[] encrypted;
        Cipher cipher = this.pollEncryptoCipher(key);
        try {
            encrypted = cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalBlockSizeRuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new BadPaddingRuntimeException(e);
        }
        finally {
            this.offerEncryptoCipher(cipher);
        }
        return encrypted;
    }

    public String encryptoText(String text) {
        try {
            return Base64Util.encode(this.encrypto(text.getBytes(this.charsetName)));
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingRuntimeException(e);
        }
    }

    public byte[] decrypto(byte[] data) {
        byte[] decrypted;
        Cipher cipher = this.pollDecryptoCipher();
        try {
            decrypted = cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalBlockSizeRuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new BadPaddingRuntimeException(e);
        }
        finally {
            this.offerDecryptoCipher(cipher);
        }
        return decrypted;
    }

    public byte[] decrypto(byte[] data, Key key) {
        byte[] decrypted;
        Cipher cipher = this.pollDecryptoCipher(key);
        try {
            decrypted = cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalBlockSizeRuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new BadPaddingRuntimeException(e);
        }
        finally {
            this.offerDecryptoCipher(cipher);
        }
        return decrypted;
    }

    public String decryptoText(String text) {
        try {
            return new String(this.decrypto(Base64Util.decode(text)), this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingRuntimeException(e);
        }
    }

    protected Cipher pollEncryptoCipher() {
        Cipher cipher = this.encryptoQueue.poll();
        if (cipher == null) {
            SecretKeySpec sksSpec = new SecretKeySpec(this.key.getBytes(), this.algorithm);
            try {
                cipher = Cipher.getInstance(this.algorithm);
                cipher.init(1, sksSpec);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyRuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new NoSuchAlgorithmRuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchPaddingRuntimeException(e);
            }
        }
        return cipher;
    }

    protected Cipher pollEncryptoCipher(Key key) {
        Cipher cipher = this.encryptoQueue.poll();
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(this.transformation);
                cipher.init(1, key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyRuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new NoSuchAlgorithmRuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchPaddingRuntimeException(e);
            }
        }
        return cipher;
    }

    protected void offerEncryptoCipher(Cipher cipher) {
        this.encryptoQueue.offer(cipher);
    }

    protected Cipher pollDecryptoCipher() {
        Cipher cipher = this.decryptoQueue.poll();
        if (cipher == null) {
            SecretKeySpec sksSpec = new SecretKeySpec(this.key.getBytes(), this.algorithm);
            try {
                cipher = Cipher.getInstance(this.algorithm);
                cipher.init(2, sksSpec);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyRuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new NoSuchAlgorithmRuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchPaddingRuntimeException(e);
            }
        }
        return cipher;
    }

    protected Cipher pollDecryptoCipher(Key key) {
        Cipher cipher = this.decryptoQueue.poll();
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(this.transformation);
                cipher.init(2, key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyRuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new NoSuchAlgorithmRuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchPaddingRuntimeException(e);
            }
        }
        return cipher;
    }

    protected void offerDecryptoCipher(Cipher cipher) {
        this.decryptoQueue.offer(cipher);
    }
}

