/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ActionDispatcher {
    public static final int DEFAULT_FLAVOR = 0;
    public static final int MAPPING_FLAVOR = 1;
    public static final int DISPATCH_FLAVOR = 2;
    protected Action actionInstance;
    protected int flavor;
    protected Class clazz;
    protected static Log log = LogFactory.getLog((Class)ActionDispatcher.class);
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.actions.LocalStrings");
    protected HashMap methods = new HashMap();
    protected Class[] types = new Class[]{ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class};

    public ActionDispatcher(Action actionInstance) {
        this(actionInstance, 0);
    }

    public ActionDispatcher(Action actionInstance, int flavor) {
        this.actionInstance = actionInstance;
        this.flavor = flavor;
        this.clazz = actionInstance.getClass();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward af;
        if (this.isCancelled(request) && (af = this.cancelled(mapping, form, request, response)) != null) {
            return af;
        }
        String parameter = this.getParameter(mapping, form, request, response);
        String name = this.getMethodName(mapping, form, request, response, parameter);
        if ("execute".equals(name) || "perform".equals(name)) {
            String message = messages.getMessage("dispatch.recursive", (Object)mapping.getPath());
            log.error((Object)message);
            throw new ServletException(message);
        }
        return this.dispatchMethod(mapping, form, request, response, name);
    }

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = "unspecified";
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            String message = messages.getMessage("dispatch.parameter", (Object)mapping.getPath(), (Object)mapping.getParameter());
            log.error((Object)message);
            throw new ServletException(message);
        }
        return this.dispatchMethod(mapping, form, request, response, name, method);
    }

    protected ActionForward cancelled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = "cancelled";
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return this.dispatchMethod(mapping, form, request, response, name, method);
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String name) throws Exception {
        if (name == null) {
            return this.unspecified(mapping, form, request, response);
        }
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            String message = messages.getMessage("dispatch.method", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            String userMsg = messages.getMessage("dispatch.method.user", (Object)mapping.getPath());
            throw new NoSuchMethodException(userMsg);
        }
        return this.dispatchMethod(mapping, form, request, response, name, method);
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String name, Method method) throws Exception {
        ActionForward forward = null;
        try {
            Object[] args = new Object[]{mapping, form, request, response};
            forward = (ActionForward)method.invoke((Object)this.actionInstance, args);
        }
        catch (ClassCastException e) {
            String message = messages.getMessage("dispatch.return", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            String message = messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            String message = messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name);
            log.error((Object)message, (Throwable)e);
            throw new ServletException(t);
        }
        return forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getMethod(String name) throws NoSuchMethodException {
        HashMap hashMap = this.methods;
        synchronized (hashMap) {
            Method method = (Method)this.methods.get(name);
            if (method == null) {
                method = this.clazz.getMethod(name, this.types);
                this.methods.put(name, method);
            }
            return method;
        }
    }

    protected String getParameter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameter = mapping.getParameter();
        if ("".equals(parameter)) {
            parameter = null;
        }
        if (parameter == null && this.flavor == 0) {
            return "method";
        }
        if (parameter == null && (this.flavor == 1 || this.flavor == 2)) {
            String message = messages.getMessage("dispatch.handler", (Object)mapping.getPath());
            log.error((Object)message);
            throw new ServletException(message);
        }
        return parameter;
    }

    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        if (this.flavor == 1) {
            return parameter;
        }
        return request.getParameter(parameter);
    }

    protected boolean isCancelled(HttpServletRequest request) {
        return request.getAttribute("org.apache.struts.action.CANCEL") != null;
    }
}

