
# --------------------------------------------------------------------
# Makefile.PL
#
# - ʤ궯˺äƤޤޤƥߥޥ
# - 줫ľơ
#
#
# --------------------------------------------------------------------
use strict;
use Config;
use vars qw($PREFIX $BIN_DIR $LIBEXEC_DIR $LIB_DIR %Config);

	my $PREFIX;
	my $BIN_DIR;
	my $LIBEXEC_DIR;
	my $LIB_DIR;

	check_version(
		'CGI' => 2.46,
		'Email::Valid'    => 0.13,
		'Apache::Session' => 1.50,
	);


	if ($ARGV[0] eq "--make") {
		shift @ARGV;
		set_param(@ARGV);
		meke_pl();
		meke_session();
	}
	else {
		set_param(@ARGV);
		make_c();
		meke_makefile();
	}

# --------------------------------------------------------------------
# Сå
#
# --------------------------------------------------------------------
sub check_version {
	my (%module) = @_;

	my $err_flag;
	while (my ($module, $version) = each %module) {
		my $eval = "require $module";
		eval $eval;

		if ($@) {
		   warn "Warning: prerequisite $module failed to load: $@";
			$err_flag = 1;
		}
		elsif ($module->VERSION < $version) {
			warn "Warning: prerequisite $module $version not found";
			$err_flag = 1;
		}
	}

	if ($err_flag == 1) {
		die "Can't make Makefile";
	}
}


# --------------------------------------------------------------------
# ѥ᡼β
#
# --------------------------------------------------------------------
sub set_param {
	my $argv = join " ", @_;

	#
	# =Υڡ
	#
	$argv =~ s/\s*\=\s*/\=/g;
	
	my %opt = (
		PREFIX  => "",
		BIN     => "",
		LIBEXEC => "",
		LIB     => "",
	);
	for (split " ", $argv) {
		if (/(\w+)=['"]?(.*)['"]?/) {
			my $key = uc $1;
			my $val = $2;

			if (exists $opt{$key}) {
				$opt{$key} = `echo $val`;
				$opt{$key} =~ s/\n|\r//g;
			}
			else {
				print "'$key' is not a known parameter name.\n";
			}
		}
	}

	$PREFIX       = $opt{PREFIX}  || $Config{prefix};
	$BIN_DIR      = $opt{BIN}     || "$PREFIX/bin";
	$LIBEXEC_DIR  = $opt{LIBEXEC} || "$PREFIX/libexec";
	$LIB_DIR      = $opt{LIB}     || "$PREFIX/lib/4f";
}

# --------------------------------------------------------------------
# 4f.c ν
#
# --------------------------------------------------------------------
sub make_c {
	print "Writing 4f.c\n";

	open(C, ">4f.c");
	print C  <<END_OF_SOURCE;
#include <stdio.h>

main(int argc, char **argv) {
    execv("$LIBEXEC_DIR/4f.pl", argv);
}
END_OF_SOURCE

	close(C);
}


# --------------------------------------------------------------------
# Makefile ν
#
# --------------------------------------------------------------------
sub meke_makefile {

	print "Writing Makefile\n";
	open(MAKE, ">Makefile");

	print MAKE <<END_OF_SOURCE;
BIN_DIR      = $BIN_DIR
LIB_DIR      = $LIB_DIR
LIBEXEC_DIR  = $LIBEXEC_DIR
END_OF_SOURCE

	print MAKE <<'END_OF_SOURCE';

makedefault :
	mkdir -p blib/libexec
	mkdir -p blib/bin
	mkdir -p blib/lib/FFFF
	gcc -o blib/bin/4f 4f.c
END_OF_SOURCE
	print MAKE "\t\@perl Makefile.PL  --make @ARGV\n";

	print MAKE <<'END_OF_SOURCE';
install :
	mkdir -p $(BIN_DIR)
	mkdir -p $(LIBEXEC_DIR)
	mkdir -p $(LIB_DIR)

	cp -r lib/* $(LIB_DIR)
	cp -r blib/bin/* $(BIN_DIR)
	cp -r blib/libexec/* $(LIBEXEC_DIR)
	chmod 0755 $(LIBEXEC_DIR)/4f.pl
	cp -r blib/lib/* $(LIB_DIR)
END_OF_SOURCE

	close(MAKE);
}

# --------------------------------------------------------------------
# 4f.pl  perl  PATH  饤֥λ
#
# --------------------------------------------------------------------
sub meke_pl {

	print "Writing blib/libexec/4f.pl\n";

	open(PL, ">blib/libexec/4f.pl");
		print PL "#!$Config{bin}/perl -I$LIB_DIR\n";
		open(PL_ORIG, "4f.pl");
			<PL_ORIG>;
			while (<PL_ORIG>) { print PL; }
		close(PL_ORIG);
	close(PL);

}

# --------------------------------------------------------------------
# Session̩
#
# --------------------------------------------------------------------
sub meke_session {


	open(DIGEST_KEY, "$LIB_DIR/FFFF/SESSION_DIGEST_KEY");
	my $digest_key = <DIGEST_KEY>;
	close(DIGEST_KEY);

	if ($digest_key eq "") {
		my @salt = ('A'..'Z', '0'..'9');
		for (1..25) {
			$digest_key .= $salt[int(rand(scalar(@salt)))];
		}
		
		print "Writing blib/lib/FFFF/SESSION_DIGEST_KEY\n";
		open(DIGEST_KEY, ">blib/lib/FFFF/SESSION_DIGEST_KEY");
		print DIGEST_KEY $digest_key;
		close(DIGEST_KEY);
	}
	
	open(SESSION_LIB, ">blib/lib/FFFF/Session.pm");
	open(SESSION_LIB_ORIG, "lib/FFFF/Session.pm");
	while (<SESSION_LIB_ORIG>) {
		s/4F-SESSION-LIB-DIGEST-KEY/$digest_key/g;
		print SESSION_LIB;
	}
	close(SESSION_LIB_ORIG);
	close(SESSION_LIB);

}
