package Base::Session;
# -------------------------------------------------------------------------
# Base::Session
#
# - Base::Session:xxxx Υ١Ȥʤ⥸塼
#
#
# -------------------------------------------------------------------------
use strict;
use Carp;
use Digest::MD5 qw(md5_hex);

# -------------------------------------------------------------------------
# ֥Ⱥ
#
# -------------------------------------------------------------------------
sub new {
    my $class = shift;
	my (%option) = @_;

	my $self  = bless {%option}, $class;

	return $self;
}


# -------------------------------------------------------------------------
# åǡκʥ֥Ⱥ
#
# -------------------------------------------------------------------------
sub create {
    my $class = shift;

	my $self = (ref $class eq "")? $class->new() : $class;

	#
	# åǡο
	#
	$self->load(0);

	
	#
	# ॢȤ
	#
	$self->set_expire();

	return $self;
}


# -------------------------------------------------------------------------
# åǡɤ߹ߡʥ֥Ⱥ
#
# -------------------------------------------------------------------------
sub open {
    my $class = shift;
	my ($sid) = @_;
	
	my $self = (ref $class eq "")? $class->new() : $class;

	#	
    # ʳξ SID ¸ߤ뤫å
    #
    # Perl 5.005_03 ʲȥåǡ̵Τ tie 褦
    # Ȥ error_log ˷ٹ𤬽Ф뤿
	#
	$self->is_session($sid) or croak "This session is not effective: [$sid]";


	#
	# åǡɤ߹
	#
	$self->load(@_);


	#
	# ॢȤΥåͭ¤αĹ
	#
	$self->is_expire() or croak "This session is time out: [$sid]";
	$self->set_expire();


	return $self;
}


# -------------------------------------------------------------------------
# åǡμꡢ
#
# -------------------------------------------------------------------------
sub id {
	my $self = shift;

	return $self->get('_session_id');
}

sub get {
	my $self = shift;
	return $self->{session}->FETCH(@_);
}

sub get_hash {
	my $self = shift;
	return %{$self->{session}->{data}};
}

sub set {
	my $self = shift;
	my %value = @_;

	while (my($key, $value) = each %value) {
		$self->{session}->STORE($key => $value);
	}
}

sub delete {
	my $self = shift;
	$self->{session}->DELETE(@_);
}


# -------------------------------------------------------------------------
# Ⱥǧ
#
# -------------------------------------------------------------------------
sub digest {
	my $self = shift;

	return md5_hex($self->id . $self->{DIGEST_KEY});
}

sub is_digest {
	my $self = shift;
	my ($digest)  = @_;

	my $digest_check = $self->digest();
	if ($digest_check ne $digest) {
		return undef;
	}
	else {
		return 1;
	}
}


# -------------------------------------------------------------------------
# åͭ¤ꡢå
#
# -------------------------------------------------------------------------
sub set_expire {
	my $self = shift;

	if ($self->{EXPIRE} > 0) {
		$self->set('_expire' => time() + $self->{EXPIRE});
	}
}

sub is_expire {
	my $self = shift;

	if ($self->{EXPIRE} > 0 and $self->get('_expire') <= time()) {
		return undef;
	}
	else {
		return 1;
	}
}

1;
