package FFFF;
use strict;

use FFFF::Config;
use FFFF::Session;
use LocalCGI;
use InputCheck;

# -------------------------------------------------------------------------
# new
#
# -------------------------------------------------------------------------
sub new {
	my $class = shift;
	my %option = @_;

	my %form = QUERY_decode();

	my $action = ($form{_action} =~ /^([\-\w]+)$/)[0];
	my $back   = ($form{_back} =~ /^([\-\w]+)$/)[0];

	return bless {
		ACTION => uc $action,
		BACK   => uc $back,
		FORM   => \%form
	}, $class;
}

# -------------------------------------------------------------------------
# եɤ߹
#
# -------------------------------------------------------------------------
sub readconfig {
	my $self = shift;

	my $config = FFFF::Config->read();
	$self->{CONFIG} = $config->{DATA};

	my $action = $self->{BACK} || $self->{ACTION};
	$self->{CONFIG_NOW} = $self->{CONFIG}->{ACTION}->{$action};
}

# -------------------------------------------------------------------------
# åǡΥå
#
# -------------------------------------------------------------------------
sub session_check {
	my $self = shift;

	my %session = $self->session_data();
	for my $action  (map {@$_} $self->{CONFIG_NOW}->{SESSION_CHECK}) {
		my $config = $self->{CONFIG}->{ACTION}->{$action};

		my $check = InputCheck->new(
			%{$config->{INPUT_CHECK}->{PLAN}}
		);

		$check->execute(%session);

		if ($check->is_error() == 1) {
			$self->{ERROR} = {
				$check->get_error(
					%{$config->{INPUT_CHECK}->{ALIAS}}
				)
			};
			$self->{CONFIG_NOW}->{TEMPLATE}->{ERROR} = $config->{TEMPLATE}->{ERROR};
			last;
		}
	}
}


# -------------------------------------------------------------------------
# ϥå
#
# -------------------------------------------------------------------------
sub input_check {
	my $self = shift;

	my $check = InputCheck->new(
		%{$self->{CONFIG_NOW}->{INPUT_CHECK}->{PLAN}}
	);

	$check->execute(
		%{$self->{FORM}}
	);
	
	if ($check->is_error() == 1) {
		$self->{ERROR} = {
			$check->get_error(
				%{$self->{CONFIG_NOW}->{INPUT_CHECK}->{ALIAS}}
			)
		};
	}
}

sub is_error {
	my $self = shift;

	return (ref $self->{ERROR} eq "HASH")? 1 : 0;
}


# -------------------------------------------------------------------------
# å¸
#
# -------------------------------------------------------------------------
sub session_set {
	my $self = shift;

	my $session = FFFF::Session->new (
		SESSION_DIR => $self->{CONFIG}->{SESSION_DIR},
		COOKIE_KEY  => $self->{CONFIG}->{COOKIE_NAME}
	);

	
	#
	# å򳫤Ƥ鼺Ԥ
	#
	if ($self->{ACTION} eq "" or $self->{SESSION_CREATE} == 1) {
		eval {
			$session->open();
		};
		if($@){
			$session->create();
		}
	}

	#
	# å򳫤Ԥ饨顼
	#
	else {
		$session->open() or die "Can't Open Session";
	}

	$session->cleanup(%{$self->{FORM}});
	$session->set(%{$self->{FORM}});

	$self->{SESSION} = $session;
}

sub session_data {
	my $self = shift;

	return $self->{SESSION}->get_hash();
}

sub session_expire {
	my $self = shift;

	return $self->{SESSION}->expire();
}

# -------------------------------------------------------------------------
# ⥸塼μ¹
#
# -------------------------------------------------------------------------
sub exec_module {
	my $self = shift;

	for my $module (@{$self->{CONFIG_NOW}->{MODULE}}) {
		my $module_name = $module->{NAME};
		my $config      = $module->{CONFIG};

		#
		# ⥸塼ɤ߹
		#
		my @require = (@{$self->{CONFIG}->{SEARCH_PATH}}, qw(FFFF/Module ./Module));
		for my $require (@require) {
			eval { require "$require/mod_${module_name}.pl"; };
			last unless ($@);
		}
		if ($@) {
			die "Can't locate: mod_${module_name}.pl in search path.(@require)";
		}

		my $function = "FFFF::Module::${module_name}::execute";

		$self->$function($config);
	}
}


# -------------------------------------------------------------------------
# ̤ν
#
# -------------------------------------------------------------------------
sub outputhtml {
	my $self = shift;

	#
	# Ϥ HTMLƥץ졼Ȥμ
	#
	my $template;
	if ($self->is_error() == 0) {
		$template = $self->{CONFIG_NOW}->{TEMPLATE}->{NEXT};
	}
	else {
		$template = $self->{CONFIG_NOW}->{TEMPLATE}->{ERROR};
	}
	$template ||= $self->{CONFIG}->{DEFAULT_TEMPLATE};
	$template = $self->search_template($template);

	OutputHtml($template,
		$self->session_data(),
		%{$self->{CONFIG}->{DEFAULT_VALUE}},
		%{$self->{FORM}},
		%{$self->{ERROR}},
	);
}

# -------------------------------------------------------------------------
# Ϥƥץ졼Ȥθ
#
# -------------------------------------------------------------------------
sub search_template {
	my $self = shift;
	my ($template) = @_;

	#
	# ե뤬̵ä search_path 򸡺
	#
	my @search = @{$self->{CONFIG}->{SEARCH_PATH}};
	if (!(-e $template) and $template =~ /^\w/) {
		for my $path (@search) {
			if (-e "$path/$template") {
				$template = "$path/$template";
				last;
			}
		}
	}
	unless (-e $template) {
		my ($package, $filename) = caller();
		die "Can't locate $template in search_path (search_path: @search, package: $package)";
	}

	return $template;
}

1;
