package FFFF::Config;

# --------------------------------------------------------------------
# FFFF::Config
#
# - Apache::ConfigFile 1.18 ȤäƤޤȤ㤯㡣
#   Υ⥸塼Ϻľͤľɬץꡣ
#   øˤĤäƤޤޤߥޥġ
#
#   Apache::ConfigFile 1.14 ǤưʤȤǧƤޤ
#   ΤǺǿǤƱޤ
#
# --------------------------------------------------------------------
use strict;
use FFFF::Apache::ConfigFile;
use Data::Dumper;

# --------------------------------------------------------------------
# - Apache::ConfigFile Ȥäեɤ߹
# - ¤褦˥ǡù
#
# --------------------------------------------------------------------
sub read {
	my $class = shift;

	#
	# եɤ߹
	#
	my $conf = FFFF::Apache::ConfigFile->read(ignore_case => 1);
	my $config = {$conf->data()};
	my %config;


	#
	# ƥɤ߹
	#
	$config{DEBUG}       = $conf->cmd_config('Debug');
	$config{DEBUG}       = ($config{DEBUG} =~ /^On$/i)? 1 : 0;
	$config{SESSION_DIR} = $conf->cmd_config('SessionDir') || "/tmp/4f";
	$config{COOKIE_NAME} = $conf->cmd_config('CookieName');
	eval {
		$config{SEARCH_PATH} = [
			'.',
			map{@$_} $conf->cmd_config_array('SearchPath')
		];
	};
	if ($@) {
		$config{SEARCH_PATH} = ['.'];
	}

	#
	# ǥեͤɤ߹
	#
	eval {
		my %default = $conf->cmd_context(DefaultValue => "")->data();
		while (my ($key, $value) = each %default) {
			$default{$key} = join("", map {@$_} @$value);
		}
		$config{DEFAULT_VALUE} = \%default;
	};

	#
	# ɸɽƥץ졼
	#
	my @action = $conf->get_action();
	$config{DEFAULT_TEMPLATE} = $conf->cmd_config('DefaultTemplate') || "$action[0].tmpl";

	#
	# ֥Ⱥ
	#
	my $self = bless {
		DATA         => {%config},
		SEARCH_PATH  => $config{SEARCH_PATH},
		ACTION_ARRAY => [@action],
	}, $class;

	#
	# Action Υǡ
	#
	$self->config_action($conf);

	return $self;
}

# --------------------------------------------------------------------
# Actionǥ쥯ƥ֤β
#
# --------------------------------------------------------------------
sub config_action {
	my $self = shift;
	my ($conf) = @_;

	my @action = @{$self->{ACTION_ARRAY}};
	for (my $i=0; $i<scalar(@action); $i++) {
		my $action = $action[$i];
		my %config;
		my $action_conf = $conf->{config_data}->{action}->{$action}->[0];

		#
		# ꤵƤʤм {ActionName}.tmpl
		#
		$config{TEMPLATE}->{NEXT} = $action_conf->{next}->[0]->[0] || "$action[$i+1].tmpl";

		#
		# ꤵƤʤAction  {template}->{next}
		#
		$config{TEMPLATE}->{ERROR} = $action_conf->{error}->[0]->[0]
			|| $self->{DATA}->{ACTION}->{uc $action[$i-1]}->{TEMPLATE}->{NEXT}
			|| $self->{DATA}->{DEFAULT_TEMPLATE};

		#
		# ꤵ̵ ACTION Ǹä On
		#
		$config{SESSION_EXPIRE} = $action_conf->{sessionexpire}->[0];
		if ($config{SESSION_EXPIRE} eq "") {
			$config{SESSION_EXPIRE} = ($i == scalar(@action)-1)? 1:0;
		}
		else {
			$config{SESSION_EXPIRE} = ($config{SESSION_EXPIRE} =~ /^On$/i)? 1 : 0;
		}

		#
		# å뤫ɤ
		#
		$config{SESSION_CREATE} = $action_conf->{sessioncreate}->[0];
		$config{SESSION_CREATE} = ($config{SESSION_CREATE} =~ /^On$/i)? 1 : 0;

		#
		# ϥå
		#
		eval {
			#
			# Υե󥹤äƤΥե󥹡ʤ䤳ˤ
			# Υե󥹤Ѵ
			#
			# [
			#   ['INT'],
			#   ['NOT_NULL', 'HIRANGANA']
			# ]
			#
			# 
			#
			# ['INT', 'NOT_NULL', 'HIRANGANA']
			#
			my $input = $action_conf->{inputcheck}->{''}->[0];
			my %alias;
			while (my ($key, $value) = each %$input) {
				
				my @check;
				for my $check (map{@$_} @$value) {
					if ($check =~ /ALIAS\{([\w]+)\}/i) {
						$alias{$key} = $1;
					}
					else {
						push(@check, uc $check);
					}
				}
				$input->{$key} = [@check];
			}
			$config{INPUT_CHECK}->{PLAN}  = $input;
			$config{INPUT_CHECK}->{ALIAS} = \%alias;
		};

		#
		# åå
		# ꤵƤʤ Action  InputCheck Ȥ
		#
		my @session_check;
		eval {
			@session_check = map {@$_} $action_conf->{sessioncheck};
		};
		if ($i != 0 and scalar(@session_check) == 0) {
			$config{SESSION_CHECK} = [
				map {uc $_} @action[0..$i-1]
			];
		}
		else {
			$config{SESSION_CHECK} = [
				map {uc $_} @session_check
			];
		}

		#
		# ĥǽ
		#
		my @module;
		while (my ($key, $value) = each %{$action_conf->{module}}) {
			push (@module, $self->config_module($key, $value));
		}
		$config{MODULE} = [@module];

		$self->{DATA}->{ACTION}->{uc $action} = {%config};
	}
}

# --------------------------------------------------------------------
# Moduleǥ쥯ƥ֤ɤ߹
#
# --------------------------------------------------------------------
sub config_module {
	my $self = shift;
	my ($key, $value) = @_;

	$key = lc $key;

	#
	# ⥸塼ɤ߹
	#
	my @require = (@{$self->{SEARCH_PATH}}, qw(FFFF/Module ./Module));
	for my $require (@require) {
		eval { require "$require/mod_${key}.pl"; };
		last unless ($@);
	}
	if ($@) {
		die "Can't locate: mod_${key}.pl in search path.(@require)";
	}

	#
	# ⥸塼¦ config ƤӽФ
	#
	my $function = "FFFF::Module::${key}::config";
	return map{{NAME => $key, CONFIG => $self->$function($_)}} @{$value};
}

1;
