package FFFF::Module::csv;

# --------------------------------------------------------------------
# FFFF::Module::csv 
# - CSVǡ¸
#
#
# --------------------------------------------------------------------
use strict;
use POSIX qw(strftime);
use constant TIME => time();

require "jcode.pl";

# --------------------------------------------------------------------
# եβ
#
# CONFIG => {
#           FILE => '/home/ta/{TIME:%Y_%m}.cvs',
#           SAVE => [
#                       '{TIME:%Y-%m-%d %H:%M:%S}',
#                       'id',
#                       'name',
#                       'kana',
#                       'email',
#                       '{FROM:zip1}-{FORM:zip2}',
#                       '{ENV:HTTP_USER_AGENT}',
#                       '{ENV:REMOTE_HOST}'
#                     ],
#           DELETE_BREAK => 1
# }
#
# --------------------------------------------------------------------
sub config {
	my $self = shift;
	my ($config) = @_;
	my %config;

	#
	# ¸
	#
	$config{SAVE} = [map{@$_} map{@$_} $config->{save}];
	
	#
	# إå
	#
	$config{HEADER} = [map{@$_} map{@$_} $config->{header}];

	#
	# ¸ե
	#
	$config{FILE} = $config->{file}->[0]->[0];

	#
	# ԥ(LF, CF)̵뤹뤫ɤ
	# ǥե:On
	#
	$config{DELETE_BREAK} = $config->{deletebreak}->[0]->[0];
	$config{DELETE_BREAK} = ($config{DELETE_BREAK} =~ /^Off$/i)? 0 : 1;

	return \%config;
}

# --------------------------------------------------------------------
# execute
# - ͤƥեCSV¸
#
# --------------------------------------------------------------------
sub execute {
	my $self     = shift;
	my ($config) = @_;

	#
	# å󤫤ǡ
	#
	my %session = $self->session_data();

	#
	# ե̾
	#
	my $file = $config->{FILE};
	$file =~ s/{FORM:(.+?)}/$session{$1}/g;
	$file =~ s/{(\w+):(.+)}/$self->FFFF::Module::csv::filter($1, $2)/eg;

	#
	# ¸ܤμ
	#
	my @save = map {@$_} $config->{SAVE};
	for my $save (@save) {
		#
		# եफ
		#
		if ($save =~ /^(\w+)$/) {
			$save = $session{$1};
		}

		#
		# ե륿
		#
		else {
			$save =~ s/{FORM:(.+?)}/$session{$1}/g;
			$save =~ s/{(\w+):(.*?)}/$self->FFFF::Module::csv::filter($1, $2)/eg;
		}
	}

	#
	# ʸ
	#
	if ($config->{DELETE_BREAK} == 1) {
		for (@save) { s/\n|\r//g; }
	}

	#
	# ¸
	#
	open(CSV, ">>$file") or die "Can't Open file : $file";
	flock(CSV, 2) or die "Can't File Lock";
	seek(CSV, 0, 2);

	#
	# ե뤬 0 ХȤǥإåƤإå
	#
	if ((stat CSV)[7] == 0 and ref $config->{HEADER} eq "ARRAY") {
		my $header = join ',', map {@$_} $config->{HEADER};
		$header = jcode::to("sjis", $header, "euc");
		print CSV "$header\n";
	}

	#
	# CSVѴƥե¸
	# http://www.din.or.jp/~ohzaki/perl.htm#CSVfromValues
	#
	my $line = join ',', map {(s/"/""/g or /[\r\n,]/)? qq{"$_"} : $_} @save;
	$line = jcode::to("sjis", $line, "euc");

	print CSV "$line\n";

	flock(CSV, 8);
	close(CSV);
}

# --------------------------------------------------------------------
# ե륿
#
# --------------------------------------------------------------------
sub filter {
	my $self     = shift;
	my ($filter_name, $value) = @_;

	my $func = "FFFF::Module::csv::filter_${filter_name}";

	return $self->$func($value);
}

sub filter_ENV {
	my $self  = shift;
	my ($key) = @_;

	return $ENV{$key};
}

sub filter_TIME {
	my $self  = shift;
	my ($format) = @_;

	return strftime($format, localtime(TIME));
}

sub filter_STR {
	my $self  = shift;
	my ($value) = @_;

	return  $value;
}

1;
