package FFFF::Module::db;

# --------------------------------------------------------------------
# FFFF::Module::db 
#
#
# --------------------------------------------------------------------
use strict;
use DBI;
use POSIX qw(strftime);
use constant TIME => time();
use Data::Dumper;

# --------------------------------------------------------------------
# եβ
#
# CONFIG => {
#          DATA_SOURCE => 'dbi:Pg:dbname=4f'
#          USER_NAME   => 'user',
#          PASSWORD    => 'passwd',
#          INSERT => [
#                       {
#                          TABLE  => 'staff'
#                          COLUMN => {
#                                         id       => 'id',
#                                         kana     => 'kana',
#                                         email    => 'email',
#                                         name     => 'name'
#                                         mod_date => '{DB:now()}',
#                                    },
#                      },
#                   ],
#          DELETE_BREAK => 0,
# };
#
# --------------------------------------------------------------------
sub config {
	my $self = shift;
	my ($config) = @_;
	my %config;

	#
	# DB
	#
	$config{DATA_SOURCE} = $config->{datasource}->[0]->[0];
	$config{USER_NAME}   = $config->{username}->[0]->[0];
	$config{PASSWORD}    = $config->{password}->[0]->[0];


	#
	# ԥ(LF, CF)̵뤹뤫ɤ
	# ǥե: Off /  mod_csv Ȥϰ㤦Τ!
	#
	$config{DELETE_BREAK} = $config->{deletebreak}->[0]->[0];
	$config{DELETE_BREAK} = ($config{DELETE_BREAK} =~ /^Off$/i)? 1 : 0;


	#
	# INSERT TABLE
	#
	my @insert;
	while (my($table, $data) = each %{$config->{insert}}) {
		
		for my $col_ref (@$data) {

			#
			# VALUESBINDѿ
			#
			my (@col, @bind, @value);
			while (my ($col, $value) = each %$col_ref) {
				my $bind = $value->[0]->[0];

				if ($bind =~ /^{DB:(.+?)}$/) {
					push(@col, $col);
					push(@value, $1);
				}
				else {
					push(@col, $col);
					push(@value, '?');
					push(@bind, $bind );
				}
			}

			push(@insert, {
					SQL  => "INSERT INTO $table (" .  join(',', @col) . ") VALUES (" . join(',', @value) . ")",
					BIND => \@bind,
				}
			);
		}
	}
	$config{INSERT} = \@insert;

	return \%config;
}

# --------------------------------------------------------------------
# execute
# - ͤDB˥ǡǼ
#
# --------------------------------------------------------------------
sub execute {
	my $self     = shift;
	my ($config) = @_;

	#
	# å󤫤ǡ
	#
	my %session = $self->session_data();


	#
	# DB ³
	#
	my $dbh = DBI->connect(
		$config->{DATA_SOURCE},
		$config->{USER_NAME},
		$config->{PASSWORD},
		{ RaiseError => 1, AutoCommit => 0 }
	) or die $DBI::errstr;


	#
	# ǡ١˳Ǽ
	#
	for my $insert (map {@$_} $config->{INSERT}) {

		#
		# BINDѿΥå
		#
		my @bind = map {@$_} $insert->{BIND};
		for my $bind (@bind) {

			#
			# եफ
			#
			if ($bind =~ /^(\w+)$/) {
				$bind = $session{$1};
			}

			#
			# ե륿
			#
			else {
				$bind =~ s/{FORM:(.+?)}/$session{$1}/g;
				$bind =~ s/{(\w+):(.*?)}/$self->FFFF::Module::db::filter($1, $2)/eg;
			}
		}

		#
		# ʸ
		#
		if ($config->{DELETE_BREAK} == 1) {
			for (@bind) { s/\n|\r//g; }
		}

		#
		# DB˳Ǽ
		#
		my $sth = $dbh->prepare($insert->{SQL});
		$sth->execute(@bind);
	}

	#
	# DB
	#
	$dbh->commit();
	$dbh->disconnect();
}

# --------------------------------------------------------------------
# ե륿
#
# --------------------------------------------------------------------
sub filter {
	my $self     = shift;
	my ($filter_name, $value) = @_;

	my $func = "FFFF::Module::db::filter_${filter_name}";

	return $self->$func($value);
}

sub filter_ENV {
	my $self  = shift;
	my ($key) = @_;

	return $ENV{$key};
}

sub filter_TIME {
	my $self  = shift;
	my ($format) = @_;

	return strftime($format, localtime(TIME));
}

sub filter_STR {
	my $self  = shift;
	my ($value) = @_;

	return  $value;
}

1;
