
//        filemv

#define _main
#include "defextern.h"


#ifndef STRICT
    #define STRICT
#endif
#include <stdio.h>
#include <fstream.h>
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
//#include "dir.h"
#include "resource.h"
#include "myfilemv.h"
#include "initial.h"
#include "file.h"
#include "batch.h"
#include "mode.h"
#include "edit.h"
#include "status.h"
#include "listview.h"
#include "keyboard.h"
#include "mainmsg.h"


#include "main.h"

#define DIRECTORY_IMAGE 0
#define FILE_IMAGE 1
#define DRIVE_IMAGE 2
#define isdirectory  "."


BOOL MyFilter(HWND hWnd);
HWND MakeMyList(HWND hWnd,int id);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FileEditProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DirLEditProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DirREditProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK DrvListProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK GetLenProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK GetNameProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyGetFNameProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyDriveProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyCreateDirProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MyTextProc(HWND, UINT, WPARAM, LPARAM);
void setsel(HWND, char *);
void CompareList(HWND hList1, HWND hList2);
void SelectReverse(HWND hList);
void getlnkstr(char *f, char *buf);
WNDPROC OldDirLEdit;
WNDPROC OldDirREdit;
WNDPROC OldDrvList;
WNDPROC OldEdit;

char FilterAll[]= "*.*";
char FilterAuto[]= "*.tfa";
char Filter[MAX_FILTER]= "*";
char setname[MAX_PATH];
char *filefilter;

DWORD dw;
ofstream log;

char dragfile[MAX_PATH];
char commandline[MAX_PATH*3];
BOOL commandflag;
int localitemnum;
DWORD start,len;


char markon[]="<>";
char markoff[]="[]";

dirw *NDir;
dirw *NXDir;
dirw LDir(tab_l),RDir(tab_r);
int ind;
HWND NList,NXList;


dirw *GetNDir()
{
	return NDir;
}

dirw *GetNXDir()
{
	return NXDir;
}

dirw *GetLDir()
{
	return &LDir;
}

dirw *GetRDir()
{
	return &RDir;
}

char *GetLPath()
{
	return LDir.cd();
}

char *GetRPath()
{
	return RDir.cd();
}

char *GetNXPath()
{
	return NDir->cd();
}

struct iset{
	int from;
	int to;
} ;

int WINAPI WinMain(HINSTANCE hCurInst, HINSTANCE hPrevInst,
                   LPSTR lpsCmdLine, int nCmdShow)
{
    MSG msg;
	HACCEL hAccel;

    if (!InitApp(hCurInst))
        return FALSE;
	wsprintf(commandline,"%s",lpsCmdLine);

    if (!InitInstance(hCurInst, nCmdShow)) 
        return FALSE;
	

	hAccel = LoadAccelerators (hCurInst, "ACCEL") ;
    while (GetMessage(&msg, NULL, 0, 0)) {
		if (!TranslateAccelerator (hmainwnd, hAccel, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
    }
/*
    if (!InitApp(hCurInst))
        return FALSE;
    if (!InitInstance(hCurInst, nCmdShow)) 
        return FALSE;
    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }*/
    return msg.wParam;
}

//EBhEENX̓o^

ATOM InitApp(HINSTANCE hInst)
{
    WNDCLASSEX wc;
    wc.cbSize = sizeof(WNDCLASSEX);
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WndProc;    //vV[W
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;//CX^X
    wc.hIcon = LoadIcon(hInst, "APICON");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = "MYMENU";    //j[
    wc.lpszClassName = (LPCSTR)szClassName;
    wc.hIconSm = LoadIcon(hInst, "APICON");
    return (RegisterClassEx(&wc));
}


//EBhE̐

BOOL InitInstance(HINSTANCE hInst, int nCmdShow)
{

    hmainwnd = CreateWindow(szClassName,
            appname, //^Cgo[ɂ̖O\܂
            WS_OVERLAPPEDWINDOW, //EBhE̎
            CW_USEDEFAULT,    //wW
            CW_USEDEFAULT,    //xW
            CW_USEDEFAULT,    //
            CW_USEDEFAULT,    //
            NULL, //eEBhẼnhAeƂNULL
            NULL, //j[nhANXj[gƂNULL
            hInst, //CX^Xnh
            NULL);
    if (!hmainwnd)
        return FALSE;
    ShowWindow(hmainwnd, nCmdShow);
    UpdateWindow(hmainwnd);
	::hInst=hInst;
    return TRUE;
}




void settitle(HWND &hWnd)
{
	wsprintf(title,"%s " ,&appname  );
	SetWindowText(hWnd, title);
}

void resettitle(HWND &hWnd)
{
	settitle(hWnd);
}
void resettitle()
{
	settitle(hmainwnd);
}


void setstatusbyte(char *mes)
{
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)0 | 0, (LPARAM)mes);
}

void setstatusnum(DWORD num)
{
	char mes[MAX_PATH];
	wsprintf(mes,"%d",num);
	setstatus(mes);
}

void setstatusnum(int num,int all)
{
	char mes[MAX_PATH];
	wsprintf(mes,"%d/%d",num,all);
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)0 | 0, (LPARAM)mes);
}
void setstatusspace(int num,int all, double space, double total)
{
	char mes[MAX_PATH];
	if(space<1000) sprintf(mes,"%d %.fMfree/%.fM", all, space,total);
	else sprintf(mes,"%d %10.2fGfree/%.2fG", all, space/1024,total/1024);
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)0 | 0, (LPARAM)mes);
}



void setstatusonly(char *mes)
{
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)2 | 0, (LPARAM)mes);
}


void setstatusonly(int pos,char *mes)
{
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)pos | 0, (LPARAM)mes);
}

void setstatusfullpath(char *file)
{
	char mes[MAX_PATH];
	_fullpath(mes,file,MAX_PATH);
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)2 | 0, (LPARAM)mes);
}


void setstatus(char *mes)
{
	if(mes==NULL) return;
	if(strlen(mes)==0) return;
	SYSTEMTIME st;
	char jikan[10];
	char form[]="%02d:%02d:%02d";

	GetLocalTime(&st);
	wsprintf(
		jikan,
		form,
	
		st.wHour,
		st.wMinute,
		st.wSecond
	);
	SendMessage(hStatus, SB_SETTEXT,
                        (WPARAM)2 | 0, (LPARAM)mes);
	log<<jikan<<" "<<mes<<endl;//if(*log!=NULL) *
}


void menusetting(HWND hwnd)
{
	hMenu =GetMenu(hwnd);
	hLeftMenu =GetSubMenu(hMenu, 1);
	hRMenu =GetSubMenu(hMenu, 3);
	hRemoteMenu =GetSubMenu(hMenu, 4);
	hBothMenu =GetSubMenu(hMenu, 6);
	hSendtoMenu =GetSubMenu(hLeftMenu, 0);
	hSessionMenu =GetSubMenu(hMenu, 1);
	hFindMenu =GetSubMenu(hMenu, 2);
	hPopDefMenu =hLeftMenu;
}

void FncCommandline(char* commandline,char* pathname)
{	
	int i=0;

	/*
	if(commandline[i]=='/')
	{
		i++;
		if(commandline[i]=='p'||commandline[i]=='P')
		{
			i++;
		}
	}
	*/
	while(commandline[i]==' '||commandline[i]=='\t')i++;

	for(int j=0;i<strlen(commandline);i++)
	  if(commandline[i]!='\"')//Ƃ@肻
				 {
					  pathname[j]=commandline[i];
					  j++;
				 }
}

BOOL GetStrDlg(char *title, char *buf)
{
	strcpy(buf, title);
	if( DialogBoxParam(hInst, "MYCREATEDIR", hmainwnd,
		(DLGPROC)MyCreateDirProc, (LPARAM) buf)
		== IDCANCEL)
		return FALSE;
	else
		return TRUE;
}


void Mes(char *m)
{
	MessageBox(NULL, m, "E", MB_OK);
}
void Mes(int i)
{
	char *buffer=commandline;
	wsprintf(buffer,"%d",i);
	MessageBox(NULL, buffer, "E", MB_OK);
}

LRESULT CALLBACK FileEditProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	DWORD key;
	if(msg == WM_KEYDOWN )
	{
		key =keyfnc(wp);
		if( key == 'W' +kCONTROL ) msgWinmode();
	}
	return CallWindowProc(OldEdit, hWnd, msg, wp, lp);
}


LRESULT CALLBACK EditProc(WNDPROC oldproc, int id, HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	if(msg == WM_KEYDOWN)
	{
		if( wp == VK_RETURN )
			SendMessage(hMainWnd, WM_COMMAND, MAKELONG( id, BN_CLICKED ), 0);
		if( wp == VK_TAB )
		{
			GetWindowText(hWnd, buffer, BUFFER_LEN);
			getnextpath(buffer);
			SetWindowText(hWnd, buffer);
		}
	}
	return CallWindowProc( oldproc, hWnd, msg, wp, lp);
}

LRESULT CALLBACK DirLEditProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return EditProc( OldDirLEdit, ID_DIRL, hWnd, msg, wp, lp);
}

LRESULT CALLBACK DirREditProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return EditProc( OldDirREdit, ID_DIR, hWnd, msg, wp, lp);
}

LRESULT CALLBACK DrvListProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	static HWND hParent;
	switch(msg)
	{
	case WM_KEYDOWN :
		if ( wp == VK_RETURN ) SendMessage(hParent, WM_COMMAND, MAKELONG( IDOK ,0 ), 0);
		break;
	case WM_LBUTTONDBLCLK :
		hParent = GetParent(hWnd);
		SendMessage(hParent, WM_COMMAND, MAKELONG( IDOK ,0 ), 0);
		break;
	default :
		break;
	}
	return CallWindowProc(OldDrvList, hWnd, msg, wp, lp);
}


LRESULT CALLBACK ListNotify(int tab, dirw *NDir, char *szDir, char *szBuf, int iIndex, HWND hWnd, WPARAM wp, LPARAM lp)
{
	static LPNMHDR lpnmhdr;
    static int sortsubno[NO_OF_SUBITEM] = {UP};
    static int isortsubno=2;//ǂ̃TuACeŃ\[gĂ邩
    SORTDATA SortData;
    NMLISTVIEW *pNMLV;
	lpnmhdr = (LPNMHDR)lp;
	switch (lpnmhdr->code) {
		case NM_DBLCLK:
			hLastList = lpnmhdr->hwndFrom;
			if (strcmp(szBuf, isdirectory) != 0) {
				if(checkbatch(szDir)) 
				{
					commandflag=TRUE;
					SendMessage(hWnd,WM_DROPFILES,0,0);
				}
				else if(checkExt(szDir,"lnk"))
				{
					getlnkstr(szDir,commandline);
					NDir->cd(commandline);
					reloadtab();
				}
				else ShellExecute(NULL, NULL,szDir, NULL, NULL, SW_SHOW);
				break;
			}
			NDir->cd(szDir);
			reloadtab();
			break;
		case NM_CLICK:
			hLastList = lpnmhdr->hwndFrom;
			break;
		case LVN_KEYDOWN:
			ListKeyFunc(hWnd,WM_NOTIFY,wp,lp,tab);
			break;
		case LVN_ITEMCHANGED://NM_CLICK:
			hLastList = lpnmhdr->hwndFrom;
			//editmode();
			if ( mode != W_MODE_LIST && strcmp(szBuf, isdirectory) != 0)
			{
				if(autoedit)autooverwrite(hEdit);
				seteditflag(TRUE);
				setfile(hEdit,szDir,NDir->cd());
			}
			else
			{
				seteditflag(FALSE);
				SetWindowText(hEdit,"");
			}
			setstatusspace(iIndex+1,NDir->GetItemNum(),NDir->GetSpace(),NDir->GetTotal());
			setstatusonly(szDir);
			break;
		case LVN_COLUMNCLICK:
			pNMLV = (NMLISTVIEW *)lp;
			isortsubno = pNMLV->iSubItem;
			if (sortsubno[isortsubno] == UP)
				sortsubno[isortsubno] = DOWN;
			else
				sortsubno[isortsubno] = UP;
			SortData.hwndList = NDir->getList();
			SortData.isortSubItem = isortsubno;
			SortData.iUPDOWN = sortsubno[isortsubno];
			if(ListView_SortItems(NDir->getList(), MyCompProc, &SortData) != TRUE)
				setstatusonly("\[gs");
			break;
		default:
			return (DefWindowProc(hWnd, WM_NOTIFY, wp, lp));
	}
	return 0;
}

void setCTab(int tab)
{
	if(tab==tab_l){
		NDir =&LDir;
		NXDir =&RDir;
		NList =hListL;
		NXList =hList;
	}
	if(tab==tab_r){
		NDir =&RDir;
		NXDir =&LDir;
		NList =hList;
		NXList =hListL;
	}
}


void setfilter(char *str =Filter)
{
	sprintf(Filter,"%s", str);
	savefilter(str);
	filefilter =Filter;
}

void getlnkstr(char *f, char *buf)
{
	char buff[2000];
	char *p;
	ifstream in(f,ios::binary);

	int i=0;
	while(i<2000)
	{
		if(!in) in.clear();
		in.seekg(i,ios::beg);
		in.read(buff,2000);
		//p=strrchr(buff,':');
		if(buff[0]=='D') {strcpy(buf,buff);}
		i++;
	}
}

//EBhEvV[W

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
    static int id, iIndex, tab;
	MENUITEMINFO minfo;
	static LPARAM sizelp;
    static HINSTANCE hInst;
    RECT rc;
    HDWP hDwp;
    static char szDir[MAX_PATH], szBuf[MAX_PATH], file[MAX_PATH];
    INITCOMMONCONTROLSEX icc;
    static LPNMHDR lpnmhdr;
    static LV_KEYDOWN *lvkeydown;
    static int sortsubno[NO_OF_SUBITEM] = {UP};
    NMLISTVIEW *pNMLV;
    SORTDATA SortData;
    static int isortsubno=2;//ǂ̃TuACeŃ\[gĂ邩
    int sb_size[] = {150, 200, -1};
    static int nStatus_h;//Xe[^Xo[̍
    POINT pt;
    WINPOS winpos = {20, 20, 600, 450};//eEBhËʒuA傫
    static HIMAGELIST hImage;
	int insideX,listtop,listy,edittop,edity,buttonx,buttony;
	static int xLpercent,xRpercent,xL,xR,yL,yR,cx,cy,ListLWidth;
    
    switch (msg) {
        case WM_CREATE:
			ListLWidth=50;
			PopFileInitialize (hWnd);
			editmode();
			filefilter=FilterAll;
			ascii=TRUE;
			st.init();
			hMainWnd=hWnd;
			initsessionnum();
			menusetting(hWnd);
            MyGetInitialData(&winpos);//
			initlog(log);
			settitle(hWnd);
            if(winpos.wx>0) MoveWindow(hWnd, winpos.x, winpos.y, winpos.wx, winpos.wy, TRUE);
            icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
            icc.dwICC = ICC_LISTVIEW_CLASSES | ICC_BAR_CLASSES;
            InitCommonControlsEx(&icc);
            hInst = ((LPCREATESTRUCT)lp)->hInstance;
            GetClientRect(hWnd, &rc);
            hList = MakeMyList(hWnd, ID_LIST);
            InsertMyColumn(hList);
            hListL = MakeMyList(hWnd, ID_LISTL);
            InsertMyColumn(hListL);
			hDir = CreateWindowEx ( 0, 
				TEXT("button"), "",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_DIR, hInst, NULL) ;
			hDirL = CreateWindowEx ( 0, 
				TEXT("button"), "",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_DIRL, hInst, NULL) ;
			hUp = CreateWindowEx ( 0, 
				TEXT("button"), ">",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_UP, hInst, NULL) ;
			hDown = CreateWindowEx ( 0, 
				TEXT("button"), "<",
                WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0,0,0,0, hWnd, (HMENU) ID_DOWN, hInst, NULL) ;
            hDirEdit = CreateWindowEx(0,
                "edit", "",
                WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER,
                0, 0, 0, 0,    hWnd, (HMENU)ID_STATIC, hInst, NULL);
            hDirEditL = CreateWindowEx(0,
                "edit", "",
                WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER,
                0, 0, 0, 0,    hWnd, (HMENU)ID_STATICL, hInst, NULL);
            hEdit = CreateWindowEx(0,
                "edit", "",
				WS_CHILD | WS_VISIBLE | ES_MULTILINE | ES_WANTRETURN |
                WS_VSCROLL | WS_HSCROLL | ES_AUTOVSCROLL | ES_AUTOHSCROLL,
                //WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER | ES_MULTILINE ,
                0, 0, 0, 0,    hWnd, (HMENU)ID_EDIT, hInst, NULL);
			OldDirLEdit =(WNDPROC) SetWindowLong (hDirEditL, GWL_WNDPROC, (LPARAM) DirLEditProc);
			OldDirREdit =(WNDPROC) SetWindowLong (hDirEdit, GWL_WNDPROC, (LPARAM) DirREditProc);
			OldEdit =(WNDPROC) SetWindowLong (hEdit, GWL_WNDPROC, (LPARAM) FileEditProc);
			LDir.cd( loadlastdir(1) );
			LDir.SetHandle(hListL,hDirEditL,hImage);
            LDir.SetItemNum( SetMyLocalDir(hWnd, hListL, hDirEditL, hImage) );
			RDir.cd( loadlastdir(2) );
			RDir.SetHandle(hList,hDirEdit,hImage);
            RDir.SetItemNum( SetMyLocalDir(hWnd, hList, hDirEdit, hImage) );
			/*
            SortData.hwndList = hListL;
            SortData.isortSubItem = isortsubno;
            SortData.iUPDOWN = sortsubno[isortsubno];
            ListView_SortItems(hListL, MyCompProc, &SortData);*/
            hStatus = CreateStatusWindow(WS_CHILD | WS_VISIBLE, "", hWnd, ID_STATUSBAR);
            SendMessage(hStatus, SB_SETPARTS, (WPARAM)3, (LPARAM)sb_size);
            GetWindowRect(hStatus, &rc);
            nStatus_h = rc.bottom - rc.top;
            hImage = ImageList_Create(16, 16, ILC_COLOR4, 2, 0);
            ListView_SetImageList(hListL, hImage, LVSIL_SMALL);
            ListView_SetImageList(hList, hImage, LVSIL_SMALL);
            ImageList_AddIcon(hImage, LoadIcon(hInst, "MYICON"));
            ImageList_AddIcon(hImage, LoadIcon(hInst, "MYFILE"));
            ImageList_AddIcon(hImage, LoadIcon(hInst, "MYDRIVE"));
			
			DragAcceptFiles(hWnd,TRUE);
			commandflag=FALSE;
		  if(strlen(commandline)>0)
		  {
				commandflag=TRUE;
				memset(file,0,MAX_PATH);
				FncCommandline(commandline,file);
				SendMessage(hWnd,WM_DROPFILES,0,0);
		  }
		  SetFocus(hListL);
            break;
        case WM_SIZE:
			sizelp=lp;
			insideX=HIWORD(lp) - nStatus_h;//
			listtop=40;
			listy=insideX - 50;
			if(mode==W_MODE_EDIT) 
			{
				listy /=2;
				listy =max(listy, 100);
			}
			if(mode==W_MODE_EDITONLY) 
			{
				listy =0;
				buttonx=0;
				buttony=0;
			}
			else
			{
				buttonx=26;
				buttony=24;
			}
			if(mode==W_MODE_LIST) ;
			edittop =listtop+listy;
			edity =insideX-listy-listtop;
			xLpercent =ListLWidth;
			xRpercent =100-xLpercent;
			xL =LOWORD(lp) /100*xLpercent;
			xR =LOWORD(lp) -xL;

            hDwp = BeginDeferWindowPos(4);
            hDwp = DeferWindowPos(hDwp, hDirL, HWND_TOP, xL -30, 5,
                30-4, 30, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hDir, HWND_TOP, xL , 5,
                30-4, 30, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hDirEditL, HWND_TOP, 10, 5,
                xL - 15-30, 30, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hDirEdit, HWND_TOP, xL + 5+30, 5,
                xR - 15-30, 30, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hListL, HWND_TOP, 10, listtop,
                xL - 25, listy, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hList, HWND_TOP, xL + 15, listtop,
                xR - 25, listy , SWP_SHOWWINDOW);
             hDwp = DeferWindowPos(hDwp, hUp, HWND_TOP, xL - 13, listtop +listy/2 -25,
                buttonx,buttony, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hDown, HWND_TOP, xL - 13, listtop +listy/2 +15,
                buttonx,buttony, SWP_SHOWWINDOW);
            hDwp = DeferWindowPos(hDwp, hEdit, HWND_TOP, 10, edittop,
                LOWORD(lp) -20, edity, SWP_SHOWWINDOW);
            EndDeferWindowPos(hDwp);
            SendMessage(hStatus, WM_SIZE, wp, lp);
            break;
		case WM_DROPFILES:
			if(!commandflag) DragQueryFile((HDROP)wp,0,file,MAX_PATH);
			setfile(hEdit,file,LDir.cd());
			setstatus(file);
			if(checkbatch(file)) batch(file);
			GetWindowText(hDirEditL,szDir,MAX_PATH);
			LDir.cd(szDir);
			reloadlocal();
			break;
        case WM_CONTEXTMENU:
			hPopMenu =hPopDefMenu;
			if( GetKeyState( VK_SHIFT ) <0 ) hPopMenu = hFindMenu;
            pt.x = LOWORD(lp);
            pt.y = HIWORD(lp);
			pt.y=100;
            if (wp == (WPARAM)hListL) {
				tab =tab_l;
				setCTab(tab);
				NDir->setfile(szDir);
				TrackPopupMenu(hPopMenu, TPM_LEFTALIGN | TPM_TOPALIGN,
                    pt.x, pt.y, 0, hWnd, NULL);
            }
            if (wp == (WPARAM)hList) {
				tab =tab_r;
				setCTab(tab);
				TrackPopupMenu(hPopMenu, TPM_LEFTALIGN | TPM_TOPALIGN,
                    pt.x, pt.y, 0, hWnd, NULL);
            }
            
            break;
        case WM_NOTIFY:
            lpnmhdr = (LPNMHDR)lp;
			lvkeydown =(LV_KEYDOWN*)lp;//EN_UPDATE
			//Ђ
            if (lpnmhdr->hwndFrom == hListL) {
				tab =tab_l;
				setCTab(tab);
                iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
                ListView_GetItemText(NList, iIndex, 0, szDir, sizeof(szDir));
                ListView_GetItemText(NList, iIndex, 1, szBuf, sizeof(szBuf));
				strcpy(file,szDir);
				return ListNotify(tab, NDir, szDir, szBuf, iIndex, hWnd, wp, lp);
            }
			//݂
            if (lpnmhdr->hwndFrom == hList) {
				tab =tab_r;
				setCTab(tab);
                iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
                ListView_GetItemText(NList, iIndex, 0, szDir, sizeof(szDir));
                ListView_GetItemText(NList, iIndex, 1, szBuf, sizeof(szBuf));
				strcpy(file,szDir);
				return ListNotify(tab, NDir, szDir, szBuf, iIndex, hWnd, wp, lp);
        }
            break;
        case WM_COMMAND:
			if(LOWORD(wp)>=bothdirIDBASE && LOWORD(wp)<bothdirIDBASE+1000 )
			{
				loadbothdir( LOWORD(wp) - bothdirIDBASE+1, LDir.cd(), RDir.cd() );
				SetWindowText(hDirEdit, RDir.cd());
				SetWindowText(hDirEditL, LDir.cd());
				reloadbothdir();
				break;
			}
			if(LOWORD(wp)>=localdirIDBASE && LOWORD(wp)<localdirIDBASE+1000 )
			{
				GetMenuString(hLeftMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                NDir->cd(szBuf);
				reloadtab();
				break;
			}
			if(LOWORD(wp)>=remotedirIDBASE && LOWORD(wp)<remotedirIDBASE+1000 )
			{
				GetMenuString(hRemoteMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                RDir.cd(szBuf);
				reloadremote();
				break;
			}
			if(LOWORD(wp)>=sendIDBASE && LOWORD(wp)<sendIDBASE+1000 )
			{
				GetMenuString(hSendtoMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                ShellExecute(NULL, NULL, 
					szBuf, 
					quote(GetFullName(commandline, file, NDir->cd(), MAX_PATH)),
					sendtoPath, SW_SHOW);
				break;
			}
			if(LOWORD(wp)>=findIDBASE && LOWORD(wp)<findIDBASE+1000 )
			{
				GetMenuString(hFindMenu, LOWORD(wp), szBuf, MAX_PATH,MF_BYCOMMAND);
                setfilter(szBuf);
				reloadtab();
				break;
			}
            switch (LOWORD(wp)) {
				case ID_DIR:
					switch (HIWORD (wp))
					 {
					 case BN_CLICKED:
						 GetWindowText(hDirEdit,szDir,MAX_PATH);
						RDir.cd(szDir);
						reloadremote();
						 break;
					 default:
						 break;
					}
					break;
				case ID_DIRL:
					switch (HIWORD (wp))
					 {
					 case BN_CLICKED:
						 GetWindowText(hDirEditL,szDir,MAX_PATH);
						LDir.cd(szDir);
						reloadlocal();
						 break;
					 default:
						 break;
					}
					break;
				case ID_BUTTON:
					switch (HIWORD (wp))
					 {
					 case BN_CLICKED:
						 if( st.connect == FALSE )
						 {
							 SendMessage(hWnd, WM_COMMAND, IDM_CONNECT, 0);
						 }
						 /*
						 else
						 {
							 if (hLastList == hListL) 
							 {
								 SendMessage(hWnd, WM_COMMAND, IDM_UPLOAD, 0);
							 }
							 if (hLastList == hList) 
							 {
								 SendMessage(hWnd, WM_COMMAND, IDM_DOWNLOAD, 0);
							 }
						 }
						 */
						return 0 ;
					 default:
						 break;
					 }
					break;
				case ID_UP:
					SendMessage(hWnd, WM_COMMAND, IDM_UPLOAD, 0);
					break;
				case ID_DOWN:
					SendMessage(hWnd, WM_COMMAND, IDM_DOWNLOAD, 0);
					break;
				case ID_STATICL:
					if( HIWORD(wp) == EN_UPDATE) GetWindowText(hDirEditL,szDir,100) ;setstatusnum(strlen(szDir));
					break;
				case IDM_LISTR_ONLY:
					ListLWidth =0;
					SetFocus(hList);
					resize();
					break;
				case IDM_LISTL_ONLY:
					ListLWidth =100;
					SetFocus(hListL);
					resize();
					break;
				case IDM_LISTL_WIDTH_1:
					ListLWidth =85;
					resize();
					break;
				case IDM_LISTL_WIDTH_2:
					ListLWidth =50;
					resize();
					break;
				case IDM_LISTL_WIDTH_3:
					ListLWidth =15;
					resize();
					break;
				case IDM_WINMODE:
					nextwinmode();
					resize();
					break;
				case IDM_HIS_BACKWARD:
					NDir->hisback();
					reloadtab();
					break;
				case IDM_HIS_FORWARD:
					NDir->hispos(1);
					reloadtab();
					break;
				case IDM_SameDir:
					if(tab==tab_l) *NDir=RDir;
					if(tab==tab_r) *NDir=LDir;
					reloadtab();
					break;
				case IDM_SSameDir:
					if(tab==tab_l) RDir =*NDir;
					if(tab==tab_r) LDir =*NDir;
					reloadother();
					break;
				case IDM_change_mode_sw:
					if(ascii==TRUE) SendMessage(hWnd,WM_COMMAND,IDM_changeb_mode,0);
					else SendMessage(hWnd,WM_COMMAND,IDM_change_mode,0);
					break;
				case IDM_LOCAL_CREATE_FILE:
					MyCreatFile(hWnd, hListL, hDirEditL);
					reloadlocal();
					break;
				case IDM_NEW_FILE:
					MyCreatBlankFile();
					reloadlocal();
					break;
				case IDM_COMPARE:
					CompareList(NList, NXList);
					break;
				case IDM_REV_SELECT:
					SelectReverse(NList);
					break;
				case IDM_RENAME_2:
					if(MyRename(*NDir)) reloadtab();
					break;
				case IDM_RENAME:
                        iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
                        ListView_GetItemText(NList, iIndex, 0, szDir, sizeof(szDir));
                        ListView_GetItemText(NList, iIndex, 1, szBuf, sizeof(szBuf));
                        if (strcmp(szBuf, isdirectory) != 0) {
							localrename(hWnd, NList, NDir, &myfname);
							reloadtab();
                            break;
                        }
						else
						{
						}
					break;
				case IDM_SAVE_WINS:
					if( DialogBoxParam(hInst, "mycreatedir", hWnd, (DLGPROC)GetNameProc,(LPARAM)(setname)) == IDCANCEL) break;
					savebothdir(setname, LDir.cd(), RDir.cd());
					break;
				case IDM_SAVE_DIRLOCAL:
					savelocaldir(tab, NDir->cd());
					break;
				case IDM_LOAD_DIRLOCAL:
					loaddirlocal(szDir);
					LDir.cd(szDir);
					setstatus(szDir);
					reloadlocal();
					break;
				case IDM_OPEN_CUR:
                    ShellExecute(NULL, "open","explorer",".", NULL, SW_SHOW);
					break;
				case IDM_OPEN_INI:
                    openinitdir();
					break;
				case IDM_EDIT:
					NDir->cd(".");
                        iIndex = ListView_GetNextItem(NList, -1, LVNI_SELECTED);
                        ListView_GetItemText(NList, iIndex, 0, szDir, sizeof(szDir));
                        ListView_GetItemText(NList, iIndex, 1, szBuf, sizeof(szBuf));
                        if (strcmp(szBuf, isdirectory) != 0) {
                            ShellExecute(NULL, "open",editor,szDir, NULL, SW_SHOW);
                            break;
                        }
						else
						{
							ShellExecute(NULL, "open","explorer",szDir, NULL, SW_SHOW);
						}
					break;

                case IDM_LOCALDRIVE:
                    ChangeLocalDrive(hWnd, *NDir, hImage);
					GetCurrentDirectory(MAX_PATH,NDir->cd());
                    reloadtab();
                    break;
                case IDM_EDIT_INIT:
					openinit();
                    break;
                case IDM_FIND:
					if( MyFilter(hWnd) )
					{
						reloadtab();
					}
                    break;
                case IDM_FIND_MORE:
					if( GetStrDlg( "?", Filter ) )
					{
						//ListFilter(hWnd);
						reloadtab();
					}
                    break;
                case IDM_FIND2:
					if( GetStrDlg( "**", Filter ) )
						setsel(NList,Filter);
                    break;
                case IDM_END:
                    SendMessage(hWnd, WM_CLOSE, 0, 0);
                    break;
                case IDM_AUTO:
					if( PopFileOpenDlg(hWnd, file, NULL) ) batch(file);
					else setstatus("LZ");
                    break;
                case IDM_AUTOFILE_EDIT:
					if( PopFileOpenDlg(hWnd, file, NULL) ) editbatch(file);
					else setstatus("LZ");
                    break;
                case IDM_AUTOFILE_FILTER:
					filefilter=FilterAuto;
					reloadlocal();
                    break;
                case IDM_DOWNLOAD:
					MyDown(hWnd, hList, hListL);
                    reloadlocal();
                    break;
                case IDM_UPLOAD:
					MyUp(hWnd, hList,hListL);
					reloadremote();
                    break;
                case IDM_COPY:
					if(tab == tab_l) msgUp();
					if(tab == tab_r) msgDown();
                    break;
                case IDM_UPLOAD_CUT:
					start=0;
					len=0;
					DialogBoxParam(hInst, "mycreatedir", hWnd, (DLGPROC)GetLenProc,(LPARAM)(NDir));
					MyCutUp(start,len);
					reloadother();
                    break;
                case IDM_HERE_CUT:
					start=0;
					len=0;
					DialogBoxParam(hInst, "mycreatedir", hWnd, (DLGPROC)GetLenProc,(LPARAM)(NDir));
					MyCutHere(start,len);
					reloadtab();
                    break;
                case IDM_DELFILELOCAL:
                    if( MessageBox(hWnd,"폜܂H",appname, MB_OKCANCEL)==IDOK ) 
					{
						MyDelFile(NList,*NDir);
						if(NList==hListL) reloadlocal();
						else reloadremote();
					}
                    break;
                case IDM_DELFILE://DeleteFile
                    MyDelFile(NList,*NDir);
                    reloadremote();
                    break;
                case IDM_CHECK_CDIR:
                    GetCurrentDirectory(100,commandline);
					SetWindowText(hEdit,commandline);
                    break;
                case IDM_CHECK_VOL:
                    GetVol(100,commandline);//
					SetWindowText(hEdit,commandline);
					break;
                case IDM_EXCHANGE:
                    Exchange(LDir, RDir);
					reloadbothdir();
                    break;
                case IDM_LOCAL_CREATEDIR:
                    MyCreatDir(hWnd, NDir);
					reloadtab();
                    break;
                case IDM_REMOVEDIR_LOCAL:
                    MyRemoveDir(NList);
                    reloadlocal();
                    break;
                case IDM_UPDIRFTP:
                    RDir.cd( "..");
                    reloadremote();
                    break;
                case IDM_R_DIRREMOTE:
                    RDir.cd(".");
                    RDir.SetItemNum( SetMyLocalDir(hWnd, hList, hDirEdit, hImage) );
                    SortData.hwndList = hList;
                    SortData.isortSubItem = isortsubno;
                    SortData.iUPDOWN = sortsubno[isortsubno];
                    ListView_SortItems(hList, MyCompProc, &SortData);
                    break;
                case IDM_R_DIRLOCAL:
                    LDir.cd(".");
                    LDir.SetItemNum( SetMyLocalDir(hWnd, hListL, hDirEditL, hImage) );
                    SortData.hwndList = hListL;
                    SortData.isortSubItem = isortsubno;
                    SortData.iUPDOWN = sortsubno[isortsubno];
                    ListView_SortItems(hListL, MyCompProc, &SortData);
					filefilter=FilterAll;//reset 
                    break;
                case IDM_ROOTDIR:
                    NDir->cdroot();
                    reloadtab();
                    break;
                case IDM_UPDIRLOCAL:
                    NDir->cd("..");
                    reloadtab();
                    break;
                case IDM_RELOAD_BOTH:
                    reloadlocal();
					reloadremote();
                    break;
                case IDM_OVERWRITE:
					overwrite(hEdit);
                    break;
                case IDM_WINDOW_ALL:
					editmode();
					resize();
                    break;
                case IDM_WINDOW_LIST:
					listmode();
					resize();
                    break;
                case IDM_WINDOW_EDIT:
					editonlymode();
					resize();
                    break;
                case IDM_COM:
					if( GetStrDlg( "R}hs", commandline ) )
						myexec( cmd( file, NDir->cd(), commandline) );
                    break;
                case IDM_CMD1:
					myexec( cmd( file, NDir->cd(), 1) );
                    break;
                case IDM_CMD2:
					myexec( cmd( file, NDir->cd(), 2) );
                    break;
                case IDM_CMD3:
					myexec( cmd( file, NDir->cd(), 3) );
                    break;
            }
            break;
        case WM_SETFOCUS:
			SetFocus( NList );
			break;
        case WM_CLOSE:
            GetWindowRect(hWnd, &rc);
            winpos.x = rc.left;
            winpos.y = rc.top;
            winpos.wx = rc.right - rc.left;
            winpos.wy = rc.bottom -rc.top;
			savelastdir( 1, LDir.cd());
			savelastdir( 2, RDir.cd());
            MySaveInitialData( &winpos);
            ImageList_Destroy(hImage);
            DestroyWindow(hList);
            DestroyWindow(hDirEdit);
            DestroyWindow(hListL);
            DestroyWindow(hDirL);
            DestroyWindow(hDir);
            DestroyWindow(hDirEditL);
            DestroyWindow(hUp);
            DestroyWindow(hDown);
            DestroyWindow(hWnd);
            break;
        case WM_DESTROY:
            PostQuitMessage(0);
            break;
        default:
            return (DefWindowProc(hWnd, msg, wp, lp));
    }
    return 0;
}


void setfilenameonRename(HWND hListFrom, dirw *dir, FNAME *lpfname)
{
    int iIndex;

	strcpy(lpfname->szFName,"");
    iIndex = ListView_GetNextItem(hListFrom, -1, LVNI_SELECTED);
    ListView_GetItemText(hListFrom, iIndex, 0, lpfname->szFName, MAX_PATH);
    dir->GetCurrentDirectory( 0,lpfname->szLocalFileName);
	strcpy(lpfname->path, lpfname->szLocalFileName);
    strcat(lpfname->szLocalFileName, "\\");
    strcat(lpfname->szLocalFileName, lpfname->szFName);
}


void MyDelFile(HWND hList,dirw &dir)
{
    int iIndex;
	char buffer[MAX_INFO],szMsg[MAX_INFO];

	dir.cd(".");
	strcpy(buffer,"");
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, 0, buffer, sizeof(buffer));
		wsprintf(szMsg,
			"%s %s폜܂B%d",
			dir.cd(), buffer,iIndex);
	    setstatus(szMsg);
		//Mes( szFile );
		DeleteFile(buffer);
	}
}

void MyRemoveDir(HWND hList)
{
    int iIndex;
	char buffer[MAX_INFO];

	strcpy(buffer,"");
    iIndex = ListView_GetNextItem(hList, -1, LVNI_SELECTED);
    ListView_GetItemText(hList, iIndex, 0, buffer, MAX_PATH);
	if(RemoveDirectory(buffer)) setstatus("fBNg폜܂");
	else setstatus("fBNg폜o܂ł");
}


BOOL localrename(HWND hWnd,HWND hList, dirw *Dir , FNAME *lpfname)
{
	setfilenameonRename(hList, Dir, lpfname);
    strcpy(lpfname->szLocalFileName, lpfname->szFName);
	if (DialogBoxParam(hInst, "MYRENAME",
		hWnd, (DLGPROC)MyGetFNameProc, (LPARAM)&myfname) == IDCANCEL)
		return FALSE;
	rename(myfname.szFName,myfname.szLocalFileName);
	return TRUE;
}


LRESULT CALLBACK GetFromToProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static FNAME fname;
    static HWND hFName, hLocalFName, txt1, txt2;
	static iset *mset;

    switch (msg) {
        case WM_INITDIALOG:
			SetWindowText(hDlg,"OA؂");
            mset = (iset*)(lp);
            hFName = GetDlgItem(hDlg, IDC_FNAME);
            hLocalFName = GetDlgItem(hDlg, IDC_LOCALFILE);
            txt1 = GetDlgItem(hDlg, IDC_STATIC1);
            txt2 = GetDlgItem(hDlg, IDC_STATIC2);
            Edit_SetText(txt1, "from");
			Edit_SetText(txt2, "to");
            SetFocus(hFName);
            break;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    Edit_GetText(hFName, fname.szFName, sizeof(fname.szFName));
                    Edit_GetText(hLocalFName, fname.szLocalFileName,
                        sizeof(fname.szLocalFileName));
					sscanf(fname.szLocalFileName,"%d",&(mset->to));
					sscanf(fname.szFName,"%d",&mset->from);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}



LRESULT CALLBACK MyGetFNameProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static FNAME *lpfname;
    static HWND hFName, hLocalFName, txt1, txt2;

    switch (msg) {
        case WM_INITDIALOG:
            lpfname = (FNAME *)lp;
			SetWindowText(hDlg, lpfname->path );
            hFName = GetDlgItem(hDlg, IDC_FNAME);
            hLocalFName = GetDlgItem(hDlg, IDC_LOCALFILE);
            txt1 = GetDlgItem(hDlg, IDC_STATIC1);
            Edit_SetText(hFName, lpfname->szFName);
            Edit_SetText(hLocalFName, lpfname->szLocalFileName);
            //Edit_SetText(txt1, "Ă");
            SetFocus(hFName);
            break;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    Edit_GetText(hFName, lpfname->szFName, sizeof(lpfname->szFName));
                    Edit_GetText(hLocalFName, lpfname->szLocalFileName,
                        sizeof(lpfname->szLocalFileName));
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}

void AddListItem(HWND hList, HANDLE hFind, char *szfname, WIN32_FIND_DATA &wfd, LVITEM &li, int &iItemNo)
{
    SYSTEMTIME localtm;
    FILETIME localft;
    char szBuf[MAX_PATH];
	strcpy(szfname, wfd.cFileName);
    li.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
    li.pszText = szfname;
    li.iItem = iItemNo;
    li.iSubItem = 0;
    li.lParam = iItemNo;
    if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
        li.iImage = DIRECTORY_IMAGE;
    } else {
        li.iImage = FILE_IMAGE;
    }
    ListView_InsertItem(hList, &li);

    li.mask = LVIF_TEXT;
    li.iSubItem = 1;
    if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
        itoa(wfd.nFileSizeLow, li.pszText, 10);
        if (wfd.nFileSizeHigh != 0)
            setstatus("t@CTCY傫܂");
    } else {
        strcpy(li.pszText, isdirectory);
    }
    ListView_SetItem(hList, &li);

    FileTimeToLocalFileTime(&wfd.ftLastWriteTime, &localft);
    FileTimeToSystemTime(&localft, &localtm);
    wsprintf(li.pszText, "%02d/%02d/%02d %02d:%02d",
        localtm.wYear, localtm.wMonth, localtm.wDay, localtm.wHour, localtm.wMinute);
    li.iSubItem = 2;
    ListView_SetItem(hList, &li);

    wsprintf(li.pszText, "%d", wfd.dwFileAttributes);
    li.iSubItem = 3;
    ListView_SetItem(hList, &li);

    GetShortPathName(wfd.cFileName, szBuf, sizeof(szBuf));
    strcpy(li.pszText, szBuf);
    li.iSubItem = 4;
    ListView_SetItem(hList, &li);

    iItemNo++;
}

void AddListDrive(HWND hList, char *szfname, char *fnameback, LVITEM &li, int &iItemNo)
{
	char c='a';
	while(1)
	{
		wsprintf(szfname, "%c:\\",c);
		SetCurrentDirectory(szfname);
		GetCurrentDirectory(MAX_PATH, szfname);
		if((toupper(szfname[0])==toupper(c)) && (toupper(fnameback[0])!=toupper(c)))
		{
			li.iSubItem = 0;
			strcpy(li.pszText, szfname);
			li.iImage = DRIVE_IMAGE;
			li.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
			li.iItem = iItemNo;
			li.lParam = iItemNo;
			ListView_InsertItem(hList, &li);

			li.iSubItem = 1;
			li.mask = LVIF_TEXT;
			strcpy(li.pszText, isdirectory);
			ListView_SetItem(hList, &li);

			li.iSubItem = 2;
			strcpy(li.pszText, "");
			ListView_SetItem(hList, &li);
		}
		if(c>'z') break;
		c++;
	}
}

// t@CXg ǂݍݖ{, tB^[filefilterŐݒ

int SetMyLocalDir(HWND hWnd, HWND hList, HWND hDirEditL, HIMAGELIST hImage)
{
    char szfname[MAX_PATH + 5],szfnameback[MAX_PATH + 5];
    WIN32_FIND_DATA wfd;
    HANDLE hFind;
    int iItemNo = 0;
    LVITEM li;
	BOOL rootflag=FALSE;

    ListView_DeleteAllItems(hList);
    GetCurrentDirectory(MAX_PATH, szfname);
    SetWindowText(hDirEditL, szfname);
	strcpy(szfnameback,szfname);
	if(strlen(szfname)<4) rootflag=TRUE;//[g`FbN@蔲
    
    hFind = FindFirstFile(filefilter, &wfd);
    if (hFind == INVALID_HANDLE_VALUE) {
        setstatus("܂");
        FindClose(hFind);
        return 0;
    } else {
        AddListItem( hList, hFind, szfname, wfd, li, iItemNo);
    }

    while (FindNextFile(hFind, &wfd)) {
		AddListItem( hList, hFind, szfname, wfd, li, iItemNo);
    }
    FindClose(hFind);

	//hCu\A蔲ia-zj
	if(rootflag)
	{
		AddListDrive( hList, szfname, szfnameback, li, iItemNo);
		SetCurrentDirectory(szfnameback);//̈ʒuɖ߂
	}

	localitemnum=iItemNo;
    return iItemNo;
}

void ChangeLocalDrive(HWND hWnd, dirw &dir, HIMAGELIST hImage)
{
    HINSTANCE hInst;
    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    DialogBoxParam(hInst, "MYDRIVE", hWnd, (DLGPROC)MyDriveProc, (LPARAM)&dir);
    return;
}


LRESULT CALLBACK MyDriveProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static HWND hDrvList;
    static HWND hListL, hDirEditL, hParent;
    char szDrv[4];
	dirw *dir;
    HWNDSET *lphset;
    static HIMAGELIST hImage;

    switch (msg) {
        case WM_INITDIALOG:
            dir = (dirw *)lp;
            hListL = dir->getList();
            hDirEditL = dir->getEdit();
            hImage = dir->getImage();
            hParent = GetParent(hDlg);
            hDrvList = GetDlgItem(hDlg, IDC_LIST1);
            DlgDirList(hDlg, "*.*", IDC_LIST1, 0, DDL_DRIVES);
			OldDrvList =(WNDPROC) SetWindowLong (hDrvList, GWL_WNDPROC, (LPARAM) DrvListProc);

            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    DlgDirSelectEx(hDlg, szDrv, sizeof(szDrv), IDC_LIST1);
                    strcat(szDrv, "\\");
                    SetCurrentDirectory(szDrv);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}

void calcpercent( char *buff, char *file, DWORD &len)
{
	DWORD size =getfilesize(file);
	int percent;
	int n=strlen(buff);
	buff[n-1] =0;
	sscanf(buff,"%ld",&percent);
	if(percent>=100) len =size;
	else len = size  * ((float)percent/100);
}

LRESULT CALLBACK GetLenProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static HWND hList;
    static HWND hListL, hDirEditL, hParent;
    char buff[100];
    HWNDSET *lphset;
    static HIMAGELIST hImage;
	static dirw *dir;

    switch (msg) {
        case WM_INITDIALOG:
			dir =(dirw*) lp;
			SetWindowText(hDlg, "");
			//SetDlgItemText(hDlg,IDC_EDIT1, dir->cd());
			dir->cd(".");
            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
					GetDlgItemText(hDlg,IDC_EDIT1,buff,MAX_PATH);
					if( strchr(buff,'%') == NULL ) sscanf(buff,"%ld",&len);
					else calcpercent( buff, dir->getfile() ,len );
					setstatusnum(len);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}

LRESULT CALLBACK GetNameProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static HWND hList;
    static HWND hListL, hDirEditL, hParent;
    HWNDSET *lphset;
    static HIMAGELIST hImage;
	static char *name;

    switch (msg) {
        case WM_INITDIALOG:
			name =(char*) lp;
			SetWindowText(hDlg, "O");
            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
					GetDlgItemText(hDlg,IDC_EDIT1,name,MAX_PATH);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}


void MyCutCopy(dirw &Fdir,dirw &Tdir,DWORD fr, DWORD len)
{
	HWND hList =NList;
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, 0, szFile, sizeof(szFile));
		GetFullName(ToFile, szFile, ToPath, MAX_PATH);
		GetFullName(FromFile, szFile, FromPath, MAX_PATH);
		wsprintf(szMsg,
			"%s >> %s , %d",
			FromFile, ToFile,len);
		cutcopy( FromFile, ToFile, fr, len );
	}
	savelocaldir(1, FromPath);
    return;
}
int search(HWND hList, char *buf)
{
	char buffer[1000];
	int i =0;
	int max =ListView_GetItemCount(hList);
	while(i<max) 
	{
		ListView_GetItemText(hList, i, 0, buffer, 1000);
		if( strlen(buffer) == 0) continue;
		if( strcmp(buffer, buf) == 0 ) return i; 
		i++;
	}
	return -1;
}

void CompareList(HWND hList1, HWND hList2)
{
	ListNonSelected( hList1 );
	ListNonSelected( hList2 );
	int i =0, ans;
	int max1=ListView_GetItemCount(hList1);
	while(i<max1) 
	{
		ListView_GetItemText(hList1, i, 0, buffer, 1000);
		if( strlen(buffer) == 0) continue;
		ans =search(hList2, buffer);
		if( ans >=0 )
		{
			ListSelected(hList1,i);
			ListSelected(hList2,ans);
		}
		i++;
	}
}

void SelectReverse(HWND hList)
{
	int i =0;
	UINT ans;
	int max =ListView_GetItemCount(hList);
	while( i < max )
	{
		ans = ListView_GetItemState(hList,i,LVIS_SELECTED);
		if ( ans > 0 )
		{
			ListSelected( hList, i, FALSE);
		}
		else
		{
			ListSelected( hList, i, TRUE);
		}
		i++;
	}
}


void setsel(HWND hList, char *key)
{
	char buffer[1000];
	int i =0;
	int max=ListView_GetItemCount(hList);
	while(i<max) 
	{
		ListView_GetItemText(hList, i, 0, buffer, 1000);
		if( strstr(buffer, key) != NULL ) ListSelected(hList,i);
		if( strlen(buffer) == 0) break;
		i++;
	}
}

void MyCopy(dirw &Fdir,dirw &Tdir,HWND hList)
{
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	Tdir.GetCurrentDirectory(dwSize, ToPath);
	Fdir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, 0, szFile, sizeof(szFile));
		GetFullName(ToFile, szFile, ToPath, MAX_PATH);
		GetFullName(FromFile, szFile, FromPath, MAX_PATH);
		wsprintf(szMsg,
			"%s >> %s , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		//Mes( szFile );CopyFileEx()
		CopyFile( FromFile, ToFile, FALSE );
	}
	savelocaldir(1, FromPath);
    return;
}

void makenewnameCut(char *from, char *to, int iFr, int iTo)
{
	if( strlen(from)<iTo ) return;
	int j=0;
	for( int i=0; i<strlen(from)+1 ; i++)
	{
		if(i<iFr || i>iTo ) {
			to[j] = from[i];
			j++;
		}
	}
}

BOOL MyRename(dirw &dir)
{
	iset mset;
	if (DialogBoxParam(hInst, "MYRENAME",
		hMainWnd, (DLGPROC)GetFromToProc, (LPARAM)&mset) == IDCANCEL)
		return FALSE;
	
					Mes(mset.from);Mes(mset.to);
    int iIndex;
	HWND hList =dir.getList();
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH], FromFile[MAX_PATH], File[MAX_PATH], FileN[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	dir.GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, 0, File, sizeof(File));
		makenewnameCut(File, FileN, mset.from-1, mset.to-1);
		GetFullName(ToFile, FileN, FromPath, MAX_PATH);
		GetFullName(FromFile, File, FromPath, MAX_PATH);
		wsprintf(szMsg,
			"rename %s > %s , %d",
			FromFile, ToFile,iIndex);
	    setstatus(szMsg);
		//Mes( szFile );
		rename( FromFile, ToFile );
	}
	savelocaldir(1, FromPath);
    return TRUE;
}

void MyDown(HWND hWnd, 
          HWND hList, HWND hListL)
{
	MyCopy(RDir,LDir,hList);
}

void MyUp(HWND hWnd, 
          HWND hList, HWND hListL)
{
	MyCopy(LDir,RDir,hListL);
}

void MyCutUp(DWORD st, DWORD len)
{
	MyCutCopy(*NDir,*NXDir,st,len);
}
void MyCutHere(DWORD st, DWORD len)
{
	HWND hList =NList;
    int iIndex;
    DWORD dwSize;
    char szMsg[512], ToFile[MAX_PATH],Dummy[MAX_PATH], FromFile[MAX_PATH], szFile[MAX_PATH], ToPath[MAX_PATH], FromPath[MAX_PATH];
    
    dwSize = MAX_PATH; 
	NDir->GetCurrentDirectory(dwSize, ToPath);
	NDir->GetCurrentDirectory(dwSize, FromPath);
	iIndex =-1;
	while(1) 
	{
		iIndex = ListView_GetNextItem( hList, iIndex, LVNI_ALL | LVNI_SELECTED);
		if (iIndex == -1) break;
		ListView_GetItemText(hList, iIndex, 0, szFile, sizeof(szFile));
		GetFullName(ToFile, szFile, ToPath, MAX_PATH);
		GetFullName(FromFile, szFile, FromPath, MAX_PATH);
		wsprintf(Dummy, "%s.$$$", FromFile);
		rename( FromFile, Dummy );
		wsprintf(szMsg,
			"cut , %d",
			len);
		cutcopy( Dummy, ToFile, st, len );
	}
	savelocaldir(1, FromPath);
    return;
}



void MyCreatDir(HWND hWnd, dirw *dir)
{
    char szDir[MAX_PATH];
	char command[MAX_PATH*2];
    HINSTANCE hInst;
    int iIndex;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)szDir);
    if (iIndex == IDCANCEL)
        return;
	wsprintf(command,"mkdir %s",szDir);
	system(command);
    return;
}

BOOL MyFilter(HWND hWnd)
{
    char str[MAX_FILTER]="filter";
	char command[MAX_PATH*2];
    int iIndex;

    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)str);
    if (iIndex == IDCANCEL)
        return FALSE;
	setfilter(str);
    return TRUE;
}


void MyCreatFile(HWND hWnd, HWND hList, HWND hDirEdit)
{
    char szDir[MAX_PATH];
//	char command[MAX_PATH*2];
    HINSTANCE hInst;
    int iIndex;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)szDir);
    if (iIndex == IDCANCEL)
        return;
	ofstream ou;
	if(strlen(szDir)>0) ou.open(szDir);
    return;
}

//JgfBNgɎԖeLXgt@C쐬A㏑`FbNȂ

void MyCreatBlankFile()
{
    char szDir[MAX_PATH];/*
	char command[MAX_PATH*2];
    HINSTANCE hInst;
    int iIndex;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    iIndex = DialogBoxParam(hInst, "MYCREATEDIR", hWnd,
        (DLGPROC)MyCreateDirProc, (LPARAM)szDir);
    if (iIndex == IDCANCEL)
        return;*/

	SYSTEMTIME st;
	char jikan[16];
	char form[]="%04d%02d%02d-%02d%02d%02d.txt";

	GetLocalTime(&st);
	wsprintf(
		szDir,
		form,
	
		st.wYear,
		st.wMonth,
		st.wDay,

		st.wHour,
		st.wMinute,
		st.wSecond
	);
	ofstream ou;
	if(strlen(szDir)>0) ou.open(szDir);
    return;
}



LRESULT CALLBACK MyCreateDirProc(HWND hDlg, UINT msg, WPARAM wp, LPARAM lp)
{
    static char *lpDirName;
    static HWND hEdit;

    switch (msg) {
        case WM_INITDIALOG:
            lpDirName = (char *)lp;
            hEdit = GetDlgItem(hDlg, IDC_EDIT1);
			if(lpDirName[0]!=0) SetWindowText(hDlg, lpDirName);
			if(strcmp(lpDirName, "filter") == 0 ) SetWindowText(hEdit, Filter);
            return TRUE;
        case WM_COMMAND:
            switch (LOWORD(wp)) {
                case IDOK:
                    Edit_GetText(hEdit, lpDirName, MAX_PATH);
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
            return FALSE;
    }
    return FALSE;
}


HWND MakeMyList(HWND hWnd,int id)
{
    HWND hList;
    DWORD dwStyle;
    HINSTANCE hInst;

    hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    hList = CreateWindowEx(0, WC_LISTVIEW, "",
        WS_CHILD | WS_VISIBLE | LVS_REPORT | WS_BORDER | LVS_SHOWSELALWAYS,//| LVS_SINGLESEL ,//,//
        0, 0, 0, 0, hWnd, (HMENU) id, hInst, NULL);
    dwStyle = ListView_GetExtendedListViewStyle(hList);
    dwStyle |= LVS_EX_FULLROWSELECT |
         LVS_EX_HEADERDRAGDROP;//LVS_EX_GRIDLINES |
    ListView_SetExtendedListViewStyle(hList, dwStyle);
    return hList;
}

void InsertMyColumn(HWND hList)
{
    LVCOLUMN lc;

    lc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    lc.fmt = LVCFMT_LEFT;
    lc.cx = 100;
    lc.pszText = "t@C";
    lc.iSubItem = 0;
    ListView_InsertColumn(hList, 0, &lc);

    lc.fmt = LVCFMT_RIGHT;
    lc.cx = 55;
    lc.pszText = "TCY";
    lc.iSubItem = 1;
    ListView_InsertColumn(hList, 1, &lc);

    lc.fmt = LVCFMT_LEFT;
    lc.cx = 110;
    lc.pszText = "XV";
    lc.iSubItem = 2;
    ListView_InsertColumn(hList, 2, &lc);

    lc.fmt = LVCFMT_RIGHT;
    lc.cx = 30;
    lc.pszText = "";
    lc.iSubItem = 3;
    ListView_InsertColumn(hList, 3, &lc);

    lc.fmt = LVCFMT_LEFT;
    lc.cx = 90;
    lc.pszText = "MS-DOS";
    lc.iSubItem = 4;
    ListView_InsertColumn(hList, 4, &lc);
    return;
}


