// myftp.h

#include "stdio.h"
#include <windows.h>
#include <commctrl.h>
#include "dir.h"

#define ID_LIST 100
#define ID_STATIC 101
#define ID_LISTL 102
#define ID_STATICL 103
#define ID_STATUSBAR 104
#define ID_BUTTON 105
#define ID_DIR 106
#define ID_DIRL 107
#define ID_EDIT 108
#define ID_UP 109
#define ID_DOWN 110

#define CONTEXT_GETFILE 100
#define CONTEXT_CONNECT 200
#define CONTEXT_PUTFILE 300
#define MAX_INFO MAX_PATH*5

#define ASCII 1
#define BINARY 0

#define MAX_FILTER 2000

typedef struct _tagAccount{
    char szUserName[MAX_INFO];
    char szPassWord[MAX_INFO];
    char memo[MAX_INFO];
} ACCOUNT;

typedef struct _tagFTPAddress{
	char name[MAX_INFO];
    char szHost[MAX_INFO];
    char szBaseDir[MAX_PATH];
    char szLocalDir[MAX_PATH];
	void setname(char *n){strcpy(name,n);};
	void setnamefrommenu(char *n){char buf[6];sscanf(n,"%s %s",buf,name);};
} FTPADDRESS;


typedef struct _tagFNAME{
    char szFName[MAX_PATH];
    char szLocalFileName[MAX_PATH];
    char path[MAX_PATH];
} FNAME;

typedef struct _tagHWNDSET{
    HWND hwnd1;
    HWND hwnd2;
    HIMAGELIST hImage;

} HWNDSET;


typedef struct _tagSTATUSCALLBACK
{
    HWND hwndStatus;
    DWORD dwFrom;
} STATUSCALLBACK;
    
_extern HINSTANCE hInst;
_extern HWND hmainwnd;
_extern char *filefilter;
_extern int localitemnum;


int CALLBACK MyCompProc(LPARAM, LPARAM, LPARAM);
ATOM InitApp(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);
void MyDown(HWND, HWND, HWND);
void SetHost(HWND, FTPADDRESS *);
int SetMyLocalDir(HWND, HWND, HWND, HIMAGELIST);
void ChangeLocalDrive(HWND, dirw &, HIMAGELIST);
void MyUp(HWND, HWND, HWND);
void MyCutUp(DWORD,DWORD);
void MyCutHere(DWORD,DWORD);
HWND MakeMyList(HWND);
void InsertMyColumn(HWND);

//ǉ
void settitle(HWND &);
void resettitle();
void resettitle(HWND &hWnd);
void settransfermode();
void MyCreatDir(HWND, dirw*);
void MyCreatFile(HWND, dirw *);
void MyCreatBlankFile();
BOOL localrename(HWND, HWND ,dirw * ,FNAME *);
void MyDelFile(HWND,dirw &);
BOOL MyRename(dirw &dir);
void MyRemoveDir(HWND);
void settransfermode(int);


char *GetLPath();
char *GetRPath();
char *GetNXPath();
dirw *GetNDir();
dirw *GetNXDir();
dirw *GetLDir();
dirw *GetRDir();

#include "mes.h"

