
#include "defextern.h"

#ifndef STRICT
    #define STRICT
#endif
#include <stdio.h>
#include <fstream.h>
#include <windows.h>
#include "win.h"
#include "mes.h"
#include "status.h"

#define CommandLen 1000

typedef (WINAPI *zzz)(const HWND,LPCSTR ,LPSTR ,const DWORD);
zzz fn;
HINSTANCE hLib = LoadLibrary( "zip32j.DLL");

BOOL zipflag;


void FreeDll()
{
	FreeLibrary(hLib);
}

BOOL dllLoad()
{
	zipflag =FALSE;
	if (hLib) {
		fn =(zzz)GetProcAddress(hLib, "Zip");
		if(fn == NULL) ;
		else {
			zipflag =TRUE;
			return TRUE;
		}
	}
	
	FreeDll();
	return FALSE;
}


void DoZip(HWND hWnd, char *zip, char *from)
{
	if(!zipflag) 
	{
		setstatus("no-dll");
		return;
	}
	char buf[CommandLen];
	char ans[CommandLen];
	sprintf(buf, "-r %s.zip %s", zip, from);
	setstatus(buf);
	(*fn)(hWnd, buf, ans, CommandLen );
	LogWin(ans);
}