
#include "defextern.h"


#ifndef STRICT
    #define STRICT
#endif

#include <windows.h>
#include "mes.h"
#include "initial.h"

#pragma pack(push)
#pragma pack(1)

typedef struct PictureInfo
{
    long   left, top;  // WJʒu
    long   width;      // 摜̕
    long   height;     //       
    WORD   x_density;  // f̐x
    WORD   y_density;  // f̐x
    short  color;      // Pfbit
    HLOCAL info;       // 摜̃eLXgwb_
} PictureInfo;

#pragma pack(pop)

//---------------------------------------------------------------------------
typedef int (CALLBACK *SPI_PROGRESS)(int, int, long);
typedef int (__stdcall *SPI_GetPluginInfo)(int infono, LPSTR buf,int buflen);
typedef int (__stdcall *SPI_IsSupported)(LPSTR filename, DWORD dw);
typedef int (__stdcall *SPI_GetPictureInfo)(LPSTR buf, long len, 
                            unsigned int flag, struct PictureInfo *lpInfo);
typedef int (__stdcall *SPI_GetPicture)(LPSTR buf, long len, unsigned int flag,
                                     HANDLE *pHBInfo, HANDLE *pHBm,
                        SPI_PROGRESS lpPrgressCallback, long lData);

SPI_GetPluginInfo  GetPluginInfo;
SPI_IsSupported    IsSupported;
SPI_GetPictureInfo GetPictureInfo;
SPI_GetPicture     GetPicture;


HMODULE handle=NULL;


void FreeSpi()
{
	FreeLibrary(handle);
}


#define jpgSpi_0 "ifjpeg.spi"
char *jpgSpi=jpgSpi_0;

char *searchSpi(char *ext)
{
	static char ans[]="";
	if( strstr(ext, "jpg")!=NULL ) return jpgSpi;
	return ans;
}

bool spiLoad(char *ext)
{
    bool ret = FALSE;
	SetCurrentDirectory( getCdir());
    handle = LoadLibrary( searchSpi( ext) );

    if (handle != NULL) {
        GetPluginInfo  = (SPI_GetPluginInfo) GetProcAddress(handle, "GetPluginInfo");
        IsSupported    = (SPI_IsSupported) GetProcAddress(handle, "IsSupported");
        GetPictureInfo = (SPI_GetPictureInfo) GetProcAddress(handle, "GetPictureInfo");
        GetPicture     = (SPI_GetPicture) GetProcAddress(handle, "GetPicture");
        ret = (IsSupported != NULL) & (GetPictureInfo != NULL) & (GetPicture != NULL);
    }

    return ret;
}

HBITMAP loadbmp(char *file, HLOCAL &inf, HLOCAL &bm)
{
	(*GetPicture)(file, 0, 0, &inf, &bm, NULL, 1);
	return (HBITMAP) bm;
}
