#include "defextern.h"

#include "myfilemv.h"
#include "initial.h"
#include "tab.h"
#include "file.h"

BOOL ismouse(char *d)
{
	return (strncmp(_MOUSE, d, strlen(_MOUSE))==0);
}

BOOL isclip(char *d)
{
	return (strncmp(_CLIP, d, strlen(_CLIP))==0);
}

BOOL ishis(char *d)
{
	return (strncmp(_HIS, d, strlen(_HIS))==0);
}

BOOL ismain(char *d)
{
	BOOL i=(strncmp(_MAIN_FOLDER, d, strlen(_MAIN_FOLDER))==0);
	BOOL j=(strncmp(_ROOT_FOLDER, d, strlen(_ROOT_FOLDER))==0);
	return (i||j);
}

BOOL dirw::ismouse()
{
	mousef =::ismouse(dir);
	return mousef;
}

BOOL dirw::isclip()
{
	clipf =::isclip(dir);
	return clipf;
}

BOOL dirw::ismain()
{
	mainf =::ismain(dir);
	return mainf;
}

BOOL dirw::ishis()
{
	hisf =::ishis(dir);
	if(strlen(dir)<5 || dir[4]=='R' || dir[4]=='r') hisRf =TRUE;
	else hisLf =TRUE;
	return hisf;
}


char clipdirfile[MAX_PATH];
#define keydir "dir"
#define keydirnum "num"

// clip:abc  >> abc.ini ɐݒ

void initclip(char *dir)
{
	wsprintf(clipdirfile,"%s\\%s.ini",getCdir(), dir+5);
}

// clipǉ
//
// clip
//   [num]
//   num=1
//   [dir]
//   1=c:\... etc.

BOOL addclip(char *from, char *to)
{
	if(strlen(to)<=_ClipLen) return FALSE;
	initclip(to);
	int num =GetPrivateProfileInt(keydirnum, keydirnum, 0, clipdirfile);

	num++;
	char buf[10];
	wsprintf(buf, "%d", num);
	WritePrivateProfileString(keydir, buf, from, clipdirfile);
	WritePrivateProfileString(keydirnum, keydirnum, buf, clipdirfile);
	return TRUE;
}


void openClip(char *dir)
{
	initclip(dir);
	//GetPrivateProfileString(keydir, "", "", buffer, MAX_PATH, clipdirfile);

	return;
}

void Exchange(dirw &ldir, dirw &rdir)
{
	/*
	char buf[1000];
	ldir.GetCurrentDirectory(1000,buf);
	ldir.SetCurrentDirectory(rdir.cd());
	rdir.SetCurrentDirectory(buf);
	*/
	HWND ledit=ldir.getEdit();
	HWND llist=ldir.getList();
	HWND redit=rdir.getEdit();
	HWND rlist=rdir.getList();
	dirw dir=ldir;

	ldir =rdir;
	rdir =dir;

	ldir.setList(llist);
	rdir.setList(rlist);
	ldir.setEdit(ledit);
	rdir.setEdit(redit);
}

void dirw::savedir()
{
	savehisdir(lr, dir);
};

void dirw::savedir(char* path)
{
	savehisdir(lr, path);
};


int dirw::getClipMax()
{
	if( !hisf) clipmax =GetPrivateProfileInt(keydirnum, keydirnum, 0, clipdirfile);
	else 
	{
		if(hisLf) clipmax =gethismax(tab_l);
		else clipmax =gethismax(tab_r);
	}
	return clipmax;
}

void getclipstr(char *key, char *ti, char *ans, char *file)
{
	GetPrivateProfileString(key, ti, "", ans, MAX_PATH, file);
}


extern char hisldirfile[];
extern char hisrdirfile[];
extern char keyhis[];

char *dirw::getClip(int num)
{
	static char buf[10], ans[MAX_PATH];
	wsprintf(buf, "%d", num);
	if(!hisf) {
		getclipstr(keydir, buf, ans, clipdirfile);
	//Mes(ans);
	}
	else{
		if(hisRf) {
			getclipstr(keyhis, buf, ans, hisrdirfile);
		}
		if(hisLf) {
			getclipstr(keyhis, buf, ans, hisldirfile);
		}
	}
	return ans;
}


char *getpath(char *dir)
{
	if(!exist(dir)) return dir;
	char path[MAX_PATH];
	wsprintf(path,"%s",dir);
	char *p=strrchr(path,'\\');
	if(p!=NULL) *p=0;
	return path;
}

// iclip:,his:,mouse:,main:j̃`FbN

char *dirw::SetCurrentDirectory(char *d)
{
	//
	BOOL f=FALSE;
	hisf =FALSE;
	if( isclip() || ishis() ||ismouse() ||ismain() )
	{
		if( strcmp(d,".")==0 ) return dir;
		if( strcmp(d,"..")==0 ) 
		{
			wsprintf(dir, _MAIN_FOLDER);
			return dir;
		}
	}

	if(strcmp(dir,d)==0 && strlen(d)>0) f=TRUE;
	if( ::ismouse(d) ) 
	{
		wsprintf(dir, d);
		space=0;
		total=0;
		savedir();
		return dir;
	}
	if( ::isclip(d) ) 
	{
		wsprintf(dir, d);
		space=0;
		total=0;
		openClip(dir);
		savedir();
		return dir;
	}
	if( ::ishis(d) ) 
	{
		hisf =TRUE;
		if(strncmp("his:R",d,5)==0 || strncmp("his:r",d,5)==0) 
		{
			hisRf =TRUE;
			wsprintf(dir, "his:R");
		}
		else 
		{
			hisLf =TRUE;
			wsprintf(dir, "his:L");
		}
		space=0;
		total=0;
		savedir();
		return dir;
	}
	if( ::ismain(d) ) 
	{
		mainf =TRUE;
		wsprintf(dir, d);
		space=0;
		total=0;
		savedir();
		return dir;
	}

	if( strncmp(d,"..",2)==0 && strlen(dir)==3)
		if( dir[1]==':' ) 
		{ 
			wsprintf(dir, _MAIN_FOLDER);
			return dir;
		};
	::SetCurrentDirectory(dir);
	::SetCurrentDirectory(getpath(d));
	::GetCurrentDirectory(1000,dir);
	//Mes(dir);
	setDirHis(dir);
	wsprintf(drive,"%s",dir);
	if(!f && strlen(d)>0) savedir();
	char *p =strchr( drive,'\\' );
	if (p !=NULL ) if(strlen(p) >1 ) p[1]=0;
	int i=GetDiskFreeSpaceEx( drive, &FreeBytesAv,
		&Bytes,
		&FreeBytes);
//	(double)FreeAvBytes.u.HighPart*4294967296.0 + (double)FreeAvBytes.u.LowPart
	if(i) 
	{
		space =((double)(FreeBytesAv.u.LowPart)+
			(double)FreeBytesAv.u.HighPart*4294967296.0)/1024/1024;
		total =((double)(Bytes.u.LowPart)+
			(double)Bytes.u.HighPart*4294967296.0)/1024/1024;
	}
	//space =(double)NumberOfFreeClusters *SectorsPerCluster *BytesPerSector/1024/1024;
	else {space =0;total =0;};
	return dir;
};

void dirw::hisback()
{
	hispos(-1);
	setDir(dirhis);
	cd(dir);
};

void dirw::hisnext()
{
	hispos(1);
	setDir(dirhis);
	cd(dir);
};
// reloadȂ

void dirw::hisBackSee()
{
	hispos(-1);
};

void dirw::hisNextSee()
{
	hispos(1);
};

void dirw::hispos(int i)
{
	loadhisdir(lr, dirhis, i);
	//setDir(dirhis);
}