/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.blogic;

import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.ListType;
import jp.finaluna.api.type.MapType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.SetType;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.StringType;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.TimestampType;

/**
 * ƖWbNɕKvȏێReLXgC^tF[XB
 * <p>
 * ̃IuWFNgɂ́AƖWbNFINALUNA^ADTOADAOȂǂ𐶐t@Ng@\eՂɎgpׂ̋@\B
 * ƖWbNFINALUNA API񋟂APIgpĎׂɁÃReLXggpFINALUNA APĨCX^X𐶐B
 * </p>
 * 
 * @author NTTf[^
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * 
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface ProcessContext {

    /**
     * DateAndTimeType̎擾B
     * <p>
     * 1970N11000b\^쐬B
     * <p>
     * 
     * @return 1970N11000b\^
     */
    DateAndTimeType createDateAndTimeType();

    /**
     * DateAndTimeType̎擾B
     * <p>
     * "yyyy-MM-dd HH:mm:ss"̃tH[}bgł^쐬B sȃtH[}bg̏ꍇ́AFinalunaSysExceptionX[B
     * <p>
     * 
     * @param value "yyyy-MM-dd HH:mm:ss"tH[}bg̕
     * @return yyyyNMMdd HHmmssb\^
     */
    DateAndTimeType createDateAndTimeType(String value);

    /**
     * DateType̎擾B
     * <p>
     * 1970N11\t^쐬B
     * <p>
     * 
     * @return 1970N11̓t^
     */
    DateType createDateType();

    /**
     * DateType̎擾B
     * <p>
     * "yyyy-MM-dd"̃tH[}bgłt^쐬B sȃtH[}bg̏ꍇAFinalunaSysExceptionX[B DateType̍őĺA292278994N817łB
     * <p>
     * 
     * @param value "yyyy-MM-dd"tH[}bg̕
     * @return yyyyNMMdd\t^
     */
    DateType createDateType(String value);

    /**
     * DecimalType̎擾B
     * <p>
     * XP[0Al0̏^쐬B
     * <p>
     * 
     * @return XP[0Al0̏^
     */
    DecimalType createDecimalType();

    /**
     * DecimalType̎擾B
     * <p>
     * ݒl\^쐬܂B̖ѐ̖Aє񐔂łꍇAFinalunaSysExceptionX[Bdoublepꍇ̒ӓ_́ABigDecimal(double)QƂ邱ƁB
     * doubleɊւۂ߂ɂẮuThe Java Language Specificationv́uFloating-Point OperationsvQƂ邱ƁB
     * <p>
     * 
     * @param value 8oCg_
     * @return ^
     */
    DecimalType createDecimalType(double value);

    /**
     * DecimalType̎擾B
     * <p>
     * ݒl\^쐬B
     * <p>
     * 
     * @param value 4oCgt
     * @return ^
     */
    DecimalType createDecimalType(int value);

    /**
     * DecimalType̎擾B
     * <p>
     * ݒl\^쐬܂B
     * <p>
     * 
     * @param value 8oCgt
     * @return ^
     */
    DecimalType createDecimalType(long value);

    /**
     * DecimalType̎擾B
     * <p>
     * ݒl\^쐬܂B镶̏java.math.BigDecimaliString)RXgN^̋LqƓlB
     * <p>
     * 
     * @param value 
     * @return ^
     */
    DecimalType createDecimalType(String value);

    /**
     * IntegerType̎擾B
     * <p>
     * l0̐l^ԋpB
     * <p>
     * 
     * @return l0̐l^
     */
    IntegerType createIntegerType();

    /**
     * IntegerType̎擾B
     * <p>
     * ݒl珬_ȉ[ɋ߂Â悤Ɋۂ߂l^𐶐B̖ѐ̖Aє񐔂̏ꍇFinalunaSysExceptionX[B doubleɊւۂ߂ɂẮuThe Java
     * Language Specificationv́uFloating-Point OperationsvQƂ邱ƁB
     * <p>
     * 
     * @param value 8oCg_
     * @return l^
     */
    IntegerType createIntegerType(double value);

    /**
     * IntegerType̎擾B
     * <p>
     * ݒl\l^𐶐B
     * <p>
     * 
     * @param value 4oCg
     * @return l^
     */
    IntegerType createIntegerType(int value);

    /**
     * IntegerType̎擾B
     * <p>
     * ݒl\l^𐶐B
     * <p>
     * 
     * @param value 8oCg
     * @return l^
     */
    IntegerType createIntegerType(long value);

    /**
     * IntegerType̎擾B
     * <p>
     * ݒl\l^𐶐B Cӂ̃}CiX(\u002d)Ƃɑ1ȏ10i\󂯕t ͕s\ȕ̏ꍇAFinalunaSysExceptionX[B
     * <p>
     * 
     * @param value 
     * @return l^
     */
    IntegerType createIntegerType(String value);

    /**
     * ListType̎擾B
     * <p>
     * e10̑̌^Xg^𐶐B
     * <p>
     * 
     * @param <E> Xgvf
     * @return Xg^
     */
    < E > ListType < E > createListType();

    /**
     * ListType̎擾B
     * <p>
     * w肵eʂ̑̌^Xg^𐶐B
     * <p>
     * 
     * @param <E> Xgvf
     * @param initialCapacity Xg̏e
     * @return Xg^
     */
    < E > ListType < E > createListType(int initialCapacity);

    /**
     * SetType̎擾B
     * <p>
     * e16̑̌^̃Zbg^𐶐B
     * <p>
     * 
     * @param <E> Zbgvf
     * @return Zbg^
     */
    < E > SetType < E > createSetType();

    /**
     * SetType̎擾B
     * <p>
     * w肵eʂ̑̌^Zbg^𐶐B eʂ̒l̏ꍇAFinalunaSysExceptionX[B
     * <p>
     * 
     * @param <E> Zbgvf
     * @param initialCapacity Zbg̏e
     * @return Zbg^
     */
    < E > SetType < E > createSetType(int initialCapacity);

    /**
     * StringCode̎擾B
     * <p>
     * 󕶎i[ǰŒ蕶^쐬B
     * <p>
     * 
     * @return Œ蕶^
     */
    StringCode createStringCode();

    /**
     * StringCode̎擾B
     * <p>
     * ݒl\Œ蕶^쐬B
     * <p>
     * 
     * @param value 2oCgUnicode
     * @return Œ蕶^
     */
    StringCode createStringCode(char value);

    /**
     * StringCode̎擾B
     * <p>
     * ݒl\Œ蕶^쐬BCӂ̃}CiX(\u002d)Ƃɑ1ȏ10i\\Œ蕶^B
     * <p>
     * 
     * @param value 4oCg
     * @return Œ蕶^
     */
    StringCode createStringCode(int value);

    /**
     * StringCode̎擾B
     * <p>
     * ݒl\Œ蕶^쐬BCӂ̃}CiX(\u002d)Ƃɑ1ȏ10i\\Œ蕶^B
     * <p>
     * 
     * @param value 8oCg
     * @return Œ蕶^
     */
    StringCode createStringCode(long value);

    /**
     * StringCode̎擾B
     * <p>
     * ݒl\Œ蕶^쐬B null^ꍇFinalunaSysExceptionX[B
     * <p>
     * 
     * @param value 
     * @return Œ蕶^
     */
    StringCode createStringCode(String value);

    /**
     * StringType̎擾B
     * <p>
     * 󕶎i[j̉ϕ^쐬B
     * <p>
     * 
     * @return ϕ^
     */
    StringType createStringType();

    /**
     * StringType̎擾B
     * <p>
     * "true""false"\ϕ^쐬B
     * <p>
     * 
     * @param value ^Ul
     * @return ϕ^
     */
    StringType createStringType(boolean value);

    /**
     * StringType̎擾B
     * <p>
     * ݒl\ϕ^쐬Bݒl͔Cӂ̃}CiX(\u002d)Ƃɑ1ȏ10i\ɕϊB
     * <p>
     * 
     * @param value 1oCg
     * @return ϕ^
     */
    StringType createStringType(byte value);

    /**
     * StringType̎擾B
     * <p>
     * ݒl\ϕ^쐬B
     * <p>
     * 
     * @param value 2oCgUnicode
     * @return ϕ^
     */
    StringType createStringType(char value);

    /**
     * StringType̎擾B
     * <p>
     * ݒl\ϕ^쐬Bdouble̕\́Ajava.lang.Double#toString(double)QƂ邱ƁB
     * <p>
     * 
     * @param value 8oCg_
     * @return ϕ^
     */
    StringType createStringType(double value);

    /**
     * StringType̎擾B
     * <p>
     * ݒl\ϕ^쐬BCӂ̃}CiX(\u002d)Ƃɑ1ȏ10i\\ϕ^B
     * <p>
     * 
     * @param value 4oCg
     * @return ϕ^
     */
    StringType createStringType(int value);

    /**
     * StringType̎擾B
     * <p>
     * ݒl\ϕ^쐬BCӂ̃}CiX(\u002d)Ƃɑ1ȏ10i\\ϕ^B
     * <p>
     * 
     * @param value 8oCg
     * @return ϕ^
     */
    StringType createStringType(long value);

    /**
     * StringType̎擾B
     * <p>
     * ݒl\ϕ^쐬B null^ꍇFinalunaSysExceptionX[B
     * <p>
     * 
     * @param value 
     * @return ϕ^
     */
    StringType createStringType(String value);

    /**
     * TimestampType̎擾B
     * <p>
     * 1970N11000b0~b\^CX^v^쐬B
     * <p>
     * 
     * @return ^CX^v^
     */
    TimestampType createTimestampType();

    /**
     * TimestampType̎擾B
     * <p>
     * "yyyy-MM-dd HH:mm:ss""yyyy-MM-dd HH:mm:ss.SSSSSSSSS"(S0`9)̃tH[}bgłݒl̃^CX^v^쐬Bnull^ꍇA
     * FinalunaSysExceptionX[B TimestampType̍őĺA292278994N817161255b999999999imb({)łB
     * <p>
     * 
     * @param value "yyyy-MM-dd HH:mm:ss""yyyy-MM-dd HH:mm:ss.SSSSSSSSS"(S0`9)tH[}bg̕
     * @return ^CX^v^
     */
    TimestampType createTimestampType(String value);

    /**
     * TimeType̎擾B
     * <p>
     * 000b\^쐬B
     * <p>
     * 
     * @return ^
     */
    TimeType createTimeType();

    /**
     * TimeType̎擾B
     * <p>
     * "HH:mm:ss"̃tH[}bgłݒl\^쐬B͕s\ȕnull^ꍇAFinalunaSysExceptionX[B TimeType̍ől235959błB
     * <p>
     * 
     * @param value "HH:mm:ss"tH[}bg̕
     * @return ^
     */
    TimeType createTimeType(String value);

    /**
     * MapType̎擾B
     * <p>
     * e16̑̌^}bv^𐶐B
     * <p>
     * 
     * @param <K> }bṽL[l
     * @param <V> }bv̒l
     * @return }bv^
     */
    < K, V > MapType < K, V > createMapType();

    /**
     * MapType̎擾B
     * <p>
     * w肵eʂ̑̌^}bv^𐶐B eʂ̒l̏ꍇAFinalunaSysExceptionX[B
     * <p>
     * 
     * @param <K> }bṽL[l
     * @param <V> }bv̒l
     * @param initialCapacity }bv̏e
     * @return }bv^
     */
    < K, V > MapType < K, V > createMapType(int initialCapacity);

}
