/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.dao;

import jp.finaluna.api.blogic.ProcessContext;
import jp.finaluna.api.dto.DTO;
import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.Rcsid;

/**
 * <code>DAO</code>̍XVSQLsO`FbNB
 * 
 * <p>
 * <code>DAO</code>̍XV\bhɂāAsO oChl(<code>DTO</code>)̒l̃`FbNsB
 * </p>
 * 
 * <p>
 * ̃C^tF[X<code>check</code>\bhAݒt@C<code>DAO</code> CWFNV邱ƂŎgp\ƂȂB<br>
 * <code>
 * <pre>
 * @F
 * 
 *     // DATA2ڂ̃`FbN
 *     private int data2Length = 0;
 * 
 *     // SQLsO`FbNB
 *     public void check(ProcessContext context, DTO dto) throws FinalunaApplException {
 *         RequestDTO reqDto = (RequestDTO) dto;
 * 
 *         // DATA1ڂ̕K{`FbN
 *         StringType data1 = (StringType) reqDto.get("DATA1");
 *         if ((data1 == null) || (data1.isNull())) {
 *             throw new CheckException(new IllegalArgumentException(), "SampleSqlCheck.01", "DATA1 is null");
 *         }
 * 
 *         // DATA2ڂ̒`FbN
 *         StringType data2 = (StringType) reqDto.get("DATA2");
 *         if (data2.length() < this.data2Length) {
 *             throw new CheckException(
 *                 new IllegalArgumentException(), "SampleSqlCheck.02", "Data2 is illegal to length");
 *         }
 *     }
 * 
 *     // DATA2ڂ̃`FbNݒ肷B
 *     public void setData2Length(int data2Length) {
 *         this.data2Length = data2Length;
 *     }
 * 
 * </pre>
 * </code>
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface SqlPreCheck {

    /**
     * SQLsO`FbNB
     * 
     * @param context ReLXg
     * @param dto oChl<code>DTO</code>
     * @throws FinalunaApplException ƖWbNX[O(ƖO)
     */
    void check(ProcessContext context, DTO dto) throws FinalunaApplException;

}
