/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type;

import jp.finaluna.api.type.util.MathUtil;

/**
 * ێ^B
 * <p>
 * ől((2-2<sup>-52</sup>)&middot;2<sup>1023</sup>)Eŏl(-(2-2<sup>-52</sup>)&middot;2<sup>1023</sup>)̋El𒴂lꍇ́C
 * <code>FinalunaSysException</code><code>throw</code>B
 * </p>
 * 
 * @version $Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $")
public interface IntegerType extends BaseType, Comparable < IntegerType >, Copiable < IntegerType > {

    /**
     * <p>
     * l -1B
     * </p>
     */
    public static final IntegerType I_M1 = ConstantFactory.createIntegerType("-1");

    /**
     * <p>
     * l 0B
     * </p>
     */
    public static final IntegerType I_0 = ConstantFactory.createIntegerType("0");

    /**
     * <p>
     * l 1B
     * </p>
     */
    public static final IntegerType I_1 = ConstantFactory.createIntegerType("1");

    /**
     * <p>
     * l 10B
     * </p>
     */
    public static final IntegerType I_10 = ConstantFactory.createIntegerType("10");

    /**
     * <p>
     * l 100B
     * </p>
     */
    public static final IntegerType I_100 = ConstantFactory.createIntegerType("100");

    /**
     * <p>
     * l 1000B
     * </p>
     */
    public static final IntegerType I_1000 = ConstantFactory.createIntegerType("1000");

    /**
     * <p>
     * ̐lw肳ꂽl傫ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl傫ꍇ <code>true</code><br>
     *         ̐lrΏېl菬ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>false</code>
     */
    boolean isGreater(IntegerType compareNum);

    /**
     * <p>
     * ̐lw肳ꂽl傫ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl傫ꍇ <code>true</code><br>
     *         ̐lrΏېl菬ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>true</code>
     */
    boolean isGreaterEqual(IntegerType compareNum);

    /**
     * <p>
     * ̐lw肳ꂽl菬ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl菬ꍇ <code>true</code><br>
     *         ̐lrΏېl傫ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>false</code>
     */
    boolean isLess(IntegerType compareNum);

    /**
     * <p>
     * ̐lw肳ꂽl菬ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl菬ꍇ <code>true</code><br>
     *         ̐lrΏېl傫ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>true</code>
     */
    boolean isLessEqual(IntegerType compareNum);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    IntegerType add(IntegerType val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    DecimalType add(DecimalType val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    IntegerType add(int val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType add(DecimalType val, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    IntegerType subtract(IntegerType val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    DecimalType subtract(DecimalType val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    IntegerType subtract(int val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType subtract(DecimalType val, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    IntegerType multiply(IntegerType val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    DecimalType multiply(DecimalType val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @return Z
     */
    IntegerType multiply(int val);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType multiply(DecimalType val, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param val Zl
     * @param scale XP[
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(IntegerType val, int scale);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param val Zl
     * @param scale XP[
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(DecimalType val, int scale);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param val Zl
     * @param scale XP[
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(int val, int scale);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @param scale XP[
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(IntegerType val, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @param scale XP[
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(DecimalType val, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param val Zl
     * @param scale XP[
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(int val, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐l̐Βl擾B
     * </p>
     * 
     * @return Βl
     */
    IntegerType abs();

    /**
     * <p>
     * ̐lƐΒl̒l擾B
     * </p>
     * 
     * @return Βl̒l
     */
    IntegerType negate();

    /**
     * <p>
     * ̐lAw肳ꂽlAElŔ͈͓ɂ邩ǂ肷B
     * </p>
     * <p>
     * ŏlAől̋EĺA<code>range</code>Ɏw肳ꂽElɏ]B
     * </p>
     * 
     * @param small ŏl
     * @param large ől
     * @param range El
     * @return w肳ꂽlElŔ͈͓ɂꍇA<code>true</code><br>
     *         ȊȌꍇ <code>false</code>
     */
    boolean isInRange(IntegerType small, IntegerType large, MathUtil.InRange range);

    /**
     * <p>
     * ̐lAw̒lŏZ]擾B
     * </p>
     * 
     * @param val ̐lZl
     * @return <code>val</code> ŏZ]
     */
    IntegerType remainder(IntegerType val);

    /**
     * <p>
     * ̐lAw̒lŏZ]擾B
     * </p>
     * 
     * @param val ̐lZl
     * @return <code>val</code> ŏZ]
     */
    IntegerType remainder(int val);

    /**
     * <p>
     * ̐l̕vfԂ܂B
     * </p>
     * 
     * @return ̏ꍇ -1A[̏ꍇ 0Ȁꍇ 1B
     */
    int signum();

}
