package jp.finaluna.api.type.util;
/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.FinalunaFormatException;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;

/**
 * l𕶎ɕϊ`B \`ꂽ߂lɕϊB
 * 
 * <p>
 * p^[w肵āȀóA͂sB
 * </p>
 * 
 * <p>
 * p^[͈ȉ̕gݍ킹Ďw肷B
 * <table border="1">
 * <tr>
 * <td>0</td>
 * <td>w茅ɖȂꍇ̓[ <br>
 * iF123j@00000u00123v</td>
 * </tr>
 * <tr>
 * <td>#</td>
 * <td>[ƕ\Ȃ <br>
 * iF123j@#,###u123v</td>
 * </tr>
 * <tr>
 * <td>.</td>
 * <td>l؂q <br>
 * iF12.3j@##0.00u12.30v</td>
 * </tr>
 * <tr>
 * <td>,</td>
 * <td>O[v؂q <br>
 * iF123456j#,###u123,456v</td>
 * </tr>
 * <tr>
 * <td>-</td>
 * <td>}CiXL <br>
 * iF-123456j#,###;-#,###u-123,456v</td>
 * </tr>
 * <tr>
 * <td>%</td>
 * <td>ڔ(100 {ăp[Zg\)<br>
 * iF1.234j@###.##%u123.4v</td>
 * </tr>
 * <tr>
 * <td>;</td>
 * <td>Tup^[E(ƕ̃Tup^[؂)<br>
 * iF123456j@#,###;#,###CRu123,456v <br>
 * iF-123456j@#,###;#,###CRu123,456CRv</td>
 * </tr>
 * </table>
 * </p>
 * 
 * @author NTTf[^
 * @version $Revision$ $Date$
 */
@Rcsid("$Revision$ $Date")
public interface NumberFormatUtil {

    /**
     * wtB[hȂŁA󂯎DecimalType̕\ԂB
     * 
     * @param number ϊΏۂ̌^
     * @return ʕ\
     **/
    StringCode toPlainStringCode(DecimalType number);

    /**
     * 󂯎DecimalType𐔒ltH[}bgŎw肵tH[}bg̕\ŕԂB ۂ߂KvȏꍇɂMathUtil.ROUND_HALF_EVENgpB
     * 
     * @param number w萔l
     * @param pattern ltH[}bg
     * @return ʕ\
     **/
    StringCode format(DecimalType number, StringCode pattern);

    /**
     * 󂯎DecimalType𐔒ltH[}bgŎw肵tH[}bg̕\ŕԂB
     * 
     * @param number w萔l
     * @param pattern ltH[}bg
     * @param roundingMode ۂ߃[h
     * @return ʕ\
     **/
    StringCode format(DecimalType number, StringCode pattern, MathUtil.Round roundingMode);

    /**
     * 󂯎IntegerType𐔒ltH[}bgŎw肵tH[}bg̕\ŕԂB
     * 
     * @param integer w萔l
     * @param pattern ltH[}bg
     * @return ʕ\
     **/
    StringCode format(IntegerType integer, StringCode pattern);

    /**
     * 󂯎StringCodeDecimalTypeparseĕԂB
     * 
     * @param numberString w蕶
     * @param pattern ltH[}bg
     * @return ʕ\
     * @throws FinalunaFormatException tH[}bgɎsꍇ
     **/
    DecimalType parseDecimalType(StringCode numberString, StringCode pattern) throws FinalunaFormatException;

    /**
     * 󂯎StringCodeIntegerTypeparseĕԂB
     * 
     * <p>
     * ȉ̐͐؂̂ĂB
     * </p>
     * 
     * @param integerString w蕶
     * @param pattern ltH[}bg
     * @return ϊIuWFNg
     * @throws FinalunaFormatException tH[}bgɎsꍇ
     **/
    IntegerType parseIntegerType(StringCode integerString, StringCode pattern) throws FinalunaFormatException;
}

