/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util.validator;

import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.util.MathUtil;

/**
 * <code>TimeType</code>^̓̓`FbNs@\B
 * <p>
 * ̑O֌W̃`FbNA͈̔̓`FbNȂǂsB
 * </p>
 * 
 * @version $Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $")
public interface TimeValidator {

    /**
     * <p>
     * TimeType^͈̔̓`FbNsB
     * <p>
     * <code>range</code>̋Ȅ<br>
     * 
     * <pre>
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     * </pre>
     * 
     * <code>value</code>A<code>min</code>A<code>max</code>nullݒ肳ĂꍇAFinalunaSysExceptionthrowB<br>
     * <code>range</code>ɕsȒlݒ肳ĂꍇAFinalunaSysExceptionthrowB<br>
     * <p>
     * 
     * @param value Ώےl
     * @param min ŏl
     * @param max ől
     * @param range Ȅێl<br>
     * @return ΏےlE͈͓ɂꍇA<code>true</code><br>
     *         ΏےlE͈͊OɂꍇA<code>false</code><br>
     *         ΏےlEŏl  ől̏ꍇA<code>false</code><br>
     */
    boolean isInRange(TimeType value, TimeType min, TimeType max, MathUtil.InRange range);

    /**
     * <p>
     * w肵ɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂܂ȂB
     * <code>value</code>A<code>afterTime</code>nullݒ肳ĂꍇAFinalunaSysExceptionthrowB<br>
     * 
     * @param value 
     * @param afterTime r
     * @return rɂꍇA<code>true</code><br>
     *         rOɂꍇA<code>false</code><br>
     *         rƓꍇA<code>false</code><br>
     */
    boolean isAfter(TimeType value, TimeType afterTime);

    /**
     * <p>
     * w肵ɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂ށB
     * <code>value</code>A<code>afterTime</code>nullݒ肳ĂꍇAFinalunaSysExceptionthrowB<br>
     * 
     * @param value 
     * @param afterTime r
     * @return rɂꍇA<code>true</code><br>
     *         rOɂꍇA<code>false</code><br>
     *         rƓꍇA<code>true</code><br>
     */
    boolean isOnAndAfter(TimeType value, TimeType afterTime);

    /**
     * <p>
     * w肵Oɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂܂ȂB
     * <code>value</code>A<code>beforeTime</code>nullݒ肳ĂꍇAFinalunaSysExceptionthrowB<br>
     * 
     * @param value 
     * @param beforeTime r
     * @return rOɂꍇA<code>true</code><br>
     *         rɂꍇA<code>false</code><br>
     *         rƓꍇA<code>false</code><br>
     */
    boolean isBefore(TimeType value, TimeType beforeTime);

    /**
     * <p>
     * w肵Oɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂ށB
     * <code>value</code>A<code>beforeTime</code>nullݒ肳ĂꍇAFinalunaSysExceptionthrowB<br>
     * 
     * @param value 
     * @param beforeTime r
     * @return rOɂꍇA<code>true</code><br>
     *         rɂꍇA<code>false</code><br>
     *         rƓꍇA<code>true</code><br>
     */
    boolean isOnAndBefore(TimeType value, TimeType beforeTime);

}
