/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type;

import jp.finaluna.api.type.util.DateUtil;
import jp.finaluna.api.type.util.MathUtil;

/**
 * Nbێ^B
 * <p>
 * ̔rAҏW\bhBɕێ͔NbB̌^̕\yyyy-MM-dd HH:mm:ss`łB
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface DateAndTimeType extends BaseType, Comparable < DateAndTimeType >, Copiable < DateAndTimeType > {

    /**
     * <p>
     * ̓t̓ttB[hɑ΂Aw肳ꂽlŉZsB
     * </p>
     * )t5ꍇ́A<br>
     * 
     * <pre>
     * add(DateUtil.DATE, -5);
     * </pre>
     * 
     * <p>
     * 
     * @param field ttB[h
     * @param amount Zl
     * @return Zst^
     */
    DateAndTimeType add(DateUtil.Calendar field, int amount);

    /**
     * <p>
     * ̓t̓ttB[hɑ΂Aw肳ꂽlŉZsB
     * </p>
     * 
     * @param field ttB[h
     * @param amount Zl
     * @return Zst^
     */
    DateAndTimeType add(DateUtil.Calendar field, IntegerType amount);

    /**
     * <p>
     * ̓ť̓tԂB
     * </p>
     * 
     * @return ̓ť̓t
     */
    DateAndTimeType getFirstDayOfMonth();

    /**
     * <p>
     * ̓ť̓tԂB
     * </p>
     * 
     * @return ̓ť̓t
     */
    DateAndTimeType getLastDayOfMonth();

    /**
     * <p>
     * ̓t̗jԂB
     * </p>
     * 
     * @return ̓t̗j
     */
    DateUtil.DayOfWeek getWeek();

    /**
     * <p>
     * ̓tAw肵tɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏۓt
     * @return rΏۓtɂꍇA<code>true</code><br>
     *         rΏۓtOɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>false</code>
     */
    boolean isAfter(DateAndTimeType compareTime);

    /**
     * <p>
     * ̓tAw肵tOɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏۓt
     * @return rΏۓtOɂꍇA<code>true</code><br>
     *         rΏۓtɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>false</code>
     */
    boolean isBefore(DateAndTimeType compareTime);

    /**
     * <p>
     * ̓tAw肳ꂽlAElŔ͈͓ɂ邩ǂ肷B
     * </p>
     * <p>
     * JntAIt̋EĺA<code>range</code>Ɏw肳ꂽElR[h ɏ]B
     * </p>
     * 
     * @param startTime Jnt
     * @param endTime It
     * @param range El
     * @return w肳ꂽlElŔ͈͓ɂꍇA<code>true</code><br>
     *         ȊȌꍇ <code>false</code>
     */
    boolean isInRange(DateAndTimeType startTime, DateAndTimeType endTime, MathUtil.InRange range);

    /**
     * <p>
     * ̓tAw肵tɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏۓt
     * @return rΏۓtɂꍇA<code>true</code><br>
     *         rΏۓtOɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>true</code>
     */
    boolean isOnAndAfter(DateAndTimeType compareTime);

    /**
     * <p>
     * ̓tAw肵tOɂ邩ǂ𔻒肷B
     * </p>
     * <p>
     * <code>compareTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param compareTime rΏۓt
     * @return rΏۓtOɂꍇA<code>true</code><br>
     *         rΏۓtɂꍇA<code>false</code><br>
     *         rΏۓtƓꍇA<code>true</code>
     */
    boolean isOnAndBefore(DateAndTimeType compareTime);

    /**
     * <p>
     * ̓t̎wtB[hɑ΂Aw肳ꂽlݒ肷B
     * </p>
     * )t1ݒ肷B<br>
     * 
     * <pre>
     * set(DateUtil.DATE, 1);
     * </pre>
     * 
     * <p>
     * Note:<br>
     * tB[h́A10琔A1211ƂĈ܂B
     * 
     * @param field ttB[h
     * @param amount ݒ肷l
     * @return ݒ肵t^
     */
    DateAndTimeType set(DateUtil.Calendar field, int amount);

    /**
     * <p>
     * ̓t̎wtB[hɑ΂Aw肳ꂽlݒ肷B
     * </p>
     * 
     * @param field ttB[h
     * @param amount ݒ肷l
     * @return ݒ肵t^
     */
    DateAndTimeType set(DateUtil.Calendar field, IntegerType amount);

    /**
     * <p>
     * ̓t̎wtB[h擾B
     * </p>
     * 
     * @param field ttB[h
     * @return w肵tB[h̒l
     */
    int get(DateUtil.Calendar field);
}
