/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type;

import jp.finaluna.api.type.util.MathUtil;

/**
 * ێ^B
 * <p>
 * ől((2-2<sup>-52</sup>)&middot;2<sup>1023</sup>)Eŏl(-(2-2<sup>-52</sup>)&middot;2<sup>1023</sup>)̋El𒴂lꍇ́C
 * <code>FinalunaSysException</code><code>throw</code>B
 * </p>
 * 
 * @version $Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $")
public interface DecimalType extends BaseType, Comparable < DecimalType >, Copiable < DecimalType > {

    /**
     * <p>
     * XP[ 0 ̒l 0B
     * </p>
     */
    public static final DecimalType D_0 = ConstantFactory.createDecimalType("0");

    /**
     * <p>
     * XP[ 0 ̒l 1B
     * </p>
     */
    public static final DecimalType D_1 = ConstantFactory.createDecimalType("1");

    /**
     * <p>
     * XP[ 0 ̒l 10B
     * </p>
     */
    public static final DecimalType D_10 = ConstantFactory.createDecimalType("10");

    /**
     * <p>
     * XP[ 0 ̒l 100B
     * </p>
     */
    public static final DecimalType D_100 = ConstantFactory.createDecimalType("100");

    /**
     * <p>
     * XP[ 0 ̒l 1000B
     * </p>
     */
    public static final DecimalType D_1000 = ConstantFactory.createDecimalType("1000");

    /**
     * <p>
     * XP[ 0 ̒l -1B
     * </p>
     */
    public static final DecimalType D_M1 = ConstantFactory.createDecimalType("-1");

    /**
     * <p>
     * ̐l̐Βl擾B
     * </p>
     * 
     * @return Βl
     */
    DecimalType abs();

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param augend Zl
     * @return <code>augend</code>̉Z
     */
    DecimalType add(DecimalType augend);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#add(DecimalType)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * 
     * </p>
     * 
     * @param augend Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return <code>augend</code>̉ZAw肳ꂽۂ߃[hKp
     */
    DecimalType add(DecimalType augend, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param augend Zl
     * @return <code>augend</code>̉Z
     */
    DecimalType add(int augend);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#add(int)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param augend Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return <code>augend</code>̉ZAw肳ꂽۂ߃[hKp
     */
    DecimalType add(int augend, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param augend Zl
     * @return <code>augend</code>̉Z
     */
    DecimalType add(IntegerType augend);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#add(IntegerType)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param augend Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return <code>augend</code>̉ZAw肳ꂽۂ߃[hKp
     */
    DecimalType add(IntegerType augend, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param divisor l
     * @param scale ۂ߈ʒu
     * @return <code>divisor</code>0ɋ߂Âۂ߃[hKpZ
     * @see jp.finaluna.api.type.util.MathUtil.Round#ROUND_DOWN
     */
    DecimalType divide(DecimalType divisor, int scale);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param divisor l
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(DecimalType divisor, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param divisor l
     * @param scale ۂ߈ʒu
     * @return 0ɋ߂Âۂ߃[hKpZ
     * @see jp.finaluna.api.type.util.MathUtil.Round#ROUND_DOWN
     */
    DecimalType divide(int divisor, int scale);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param divisor l
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(int divisor, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param divisor l
     * @param scale ۂ߈ʒu
     * @return 0ɋ߂Âۂ߃[hKpZ
     * @see jp.finaluna.api.type.util.MathUtil.Round#ROUND_DOWN
     */
    DecimalType divide(IntegerType divisor, int scale);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param divisor l
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType divide(IntegerType divisor, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lAlɕϊB
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @return 0ɋ߂Âۂ߃[hKpl
     * @see jp.finaluna.api.type.util.MathUtil.Round#ROUND_DOWN
     */
    IntegerType getInteger();

    /**
     * <p>
     * ̐lAw肳ꂽۂ߃[hKplŎ擾B
     * </p>
     * 
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpl
     */
    IntegerType getInteger(MathUtil.Round round);

    /**
     * <p>
     * ̐lw肳ꂽl傫ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl傫ꍇ <code>true</code><br>
     *         ̐lrΏېl菬ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>false</code>
     */
    boolean isGreater(DecimalType compareNum);

    /**
     * <p>
     * ̐lw肳ꂽl傫ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl傫ꍇ <code>true</code><br>
     *         ̐lrΏېl菬ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>true</code>
     */
    boolean isGreaterEqual(DecimalType compareNum);

    /**
     * <p>
     * ̐lAw肳ꂽlAElŔ͈͓ɂ邩ǂ肷B
     * </p>
     * <p>
     * ŏlAől̋EĺA<code>range</code>Ɏw肳ꂽElɏ]B
     * </p>
     * 
     * @param small ŏl
     * @param large ől
     * @param range El
     * @return w肳ꂽlElŔ͈͓ɂꍇA<code>true</code><br>
     *         ȊȌꍇ <code>false</code>
     */
    boolean isInRange(DecimalType small, DecimalType large, MathUtil.InRange range);

    /**
     * <p>
     * ̐lw肳ꂽl菬ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl菬ꍇ <code>true</code><br>
     *         ̐lrΏېl傫ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>false</code>
     */
    boolean isLess(DecimalType compareNum);

    /**
     * <p>
     * ̐lw肳ꂽl菬ǂ𔻒肷B
     * </p>
     * 
     * @param compareNum rΏېl
     * @return ̐lrΏېl菬ꍇ <code>true</code><br>
     *         ̐lrΏېl傫ꍇ <code>false</code><br>
     *         ̐lrΏېlƓꍇ <code>true</code>
     */
    boolean isLessEqual(DecimalType compareNum);

    /**
     * <p>
     * ̐l̏_Aw肳ꂽlֈړl擾B
     * </p>
     * 
     * @param point _ړl
     * @return _̃|CgAw肳ꂽlֈړl
     */
    DecimalType movePointLeft(int point);

    /**
     * <p>
     * ̐l̏_Aw肳ꂽlEֈړl擾B
     * </p>
     * 
     * @param point _ړl
     * @return _̃|CgAw肳ꂽlEֈړl
     */
    DecimalType movePointRight(int point);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param multiplicand Zl
     * @return Z
     */
    DecimalType multiply(DecimalType multiplicand);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#multiply(DecimalType)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param multiplicand Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType multiply(DecimalType multiplicand, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param multiplicand Zl
     * @return Z
     */
    DecimalType multiply(int multiplicand);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#multiply(int)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param multiplicand Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType multiply(int multiplicand, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param multiplicand Zl
     * @return Z
     */
    DecimalType multiply(IntegerType multiplicand);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#multiply(IntegerType)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param multiplicand Zl
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType multiply(IntegerType multiplicand, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐l-1悶l擾B
     * </p>
     * 
     * @return ̐l-1悶l
     */
    DecimalType negate();

    /**
     * <p>
     * ̐lAw̒lłׂ悵l擾B
     * </p>
     * 
     * @param exponent ̐lׂ悷
     * @param precision x
     * @param round ۂ߃[h
     * @return <code>exponent</code>ׂ悵l
     */
    DecimalType pow(int exponent, int precision, MathUtil.Round round);

    /**
     * <p>
     * ̐ĺuxvԂ܂BxƂ́AXP[Ȃ̒ľ̂ƂłB0̐x1łB
     * </p>
     * 
     * @return x
     */
    int precision();

    /**
     * <p>
     * ̐lAw̒lŏZ]擾B
     * </p>
     * <p>
     * Zɗpۂ߈ʒu0Aۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param divisor l
     * @return <code>divisor</code> ŏZ]
     * @see jp.finaluna.api.type.util.MathUtil.Round#ROUND_DOWN
     */
    DecimalType remainder(DecimalType divisor);

    /**
     * <p>
     * ̐lAw̒lŏZ]擾B
     * </p>
     * 
     * @param divisor l
     * @param scale ZɎgpۂ߈ʒu
     * @param round ۂ߃[h
     * @return <code>divisor</code> ŏZ]<br>
     */
    DecimalType remainder(DecimalType divisor, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lAw̒lŏZ]擾B
     * </p>
     * 
     * @param divisor l
     * @return <code>divisor</code> ŏZ]
     */
    DecimalType remainder(int divisor);

    /**
     * <p>
     * ̐lAw̒lŏZ]擾B
     * </p>
     * 
     * @param divisor l
     * @param scale ZɎgpۂ߈ʒu
     * @param round ۂ߃[h
     * @return <code>divisor</code> ŏZ]<br>
     */
    DecimalType remainder(int divisor, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐ĺuXP[vԂ܂B0 ܂͐̏ꍇAXP[͏_ȉ̌łB̏ꍇAXP[Ȃ̐lɁAXP[̐tɂlwƂ10
     * ̗ݏZ܂BƂ΁A-3̃XP[ł́AXP[Ȃ̒l1000Z܂B
     * </p>
     * 
     * @return XP[
     */
    int scale();

    /**
     * <p>
     * ̊ۂ߈ʒuŊۂ߂lԂB
     * </p>
     * <p>
     * ۂ߃[hɂ0ɋ߂Â郂[hKpB
     * </p>
     * 
     * @param scale ۂ߈ʒu
     * @return ۂߌ
     * @see jp.finaluna.api.type.util.MathUtil.Round#ROUND_DOWN
     */
    DecimalType setScale(int scale);

    /**
     * <p>
     * ̊ۂ߈ʒuAۂ߃[hŐݒ肳ꂽlԂB
     * </p>
     * 
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return ۂߌ
     */
    DecimalType setScale(int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐l̕vfԂ܂B
     * </p>
     * 
     * @return ̏ꍇ -1A[̏ꍇ 0Ȁꍇ 1B
     */
    int signum();

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param subtrahend l
     * @return Z
     */
    DecimalType subtract(DecimalType subtrahend);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B̉Z{@link DecimalType#subtract(DecimalType)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param subtrahend l
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType subtract(DecimalType subtrahend, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param subtrahend l
     * @return Z
     */
    DecimalType subtract(int subtrahend);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#subtract(int)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param subtrahend l
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType subtract(int subtrahend, int scale, MathUtil.Round round);

    /**
     * <p>
     * ̐lɁAw肵lZʂ擾B
     * </p>
     * 
     * @param subtrahend l
     * @return Z
     */
    DecimalType subtract(IntegerType subtrahend);

    /**
     * <p>
     * ̐lɁAw肵lZAw肳ꂽۂ߈ʒuъۂ߃[hpĊۂ߂ꂽʂ擾B ̉Z{@link DecimalType#subtract(IntegerType)}̌ɁA
     * {@link DecimalType#setScale(int, jp.finaluna.api.type.util.MathUtil.Round)}ĂяoƂƓłB
     * </p>
     * 
     * @param subtrahend l
     * @param scale ۂ߈ʒu
     * @param round ۂ߃[h
     * @return w肳ꂽۂ߃[hKpZ
     */
    DecimalType subtract(IntegerType subtrahend, int scale, MathUtil.Round round);

}
