/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */
package jp.finaluna.api.type.util;

import jp.finaluna.api.exception.FinalunaApplException;
import jp.finaluna.api.type.CodeType;
import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.DecimalType;
import jp.finaluna.api.type.IntegerType;
import jp.finaluna.api.type.KeyCodeType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.StringType;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.TimestampType;

/**
 * javaFINALUNA^ݕϊ[eBeBC^[tF[XB
 * <p>
 * javaFINALUNA^ݕϊ̃[eBeBNX͂ConvertTypeUtilC^[tF[XB
 * </p>
 * 
 * @version $Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 15138 $ $Date: 2009-01-17 02:38:48 +0900 $")
public interface ConvertUtilDelegate {

    /**
     * <code>CodeType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public String toString(CodeType target);

    /**
     * <code>KeyCodeType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public String toString(KeyCodeType target);

    /**
     * <code>StringType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public String toString(StringType target);

    /**
     * <code>IntegerType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public int intValue(IntegerType target);

    /**
     * <code>IntegerType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public int intValueExact(IntegerType target) throws FinalunaApplException;

    /**
     * <code>IntegerType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public String toString(IntegerType target);

    /**
     * <code>DecimalType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public int intValue(DecimalType target);

    /**
     * <code>DecimalType</code><code>int<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public int intValueExact(DecimalType target) throws FinalunaApplException;

    /**
     * <code>DecimalType</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public String toString(DecimalType target);

    /**
     * <code>String</code><code>CodeType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public CodeType toCodeType(String target);

    /**
     * <code>String</code><code>KeyCodeType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public KeyCodeType toKeyCodeType(String target);

    /**
     * <code>String</code><code>StringType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public StringType toStringType(String target);

    /**
     * <code>int</code><code>IntegerType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public IntegerType toIntegerType(int target);

    /**
     * <code>String</code><code>IntegerType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public IntegerType toIntegerType(String target);

    /**
     * <code>String</code><code>IntegerType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public IntegerType toIntegerTypeExact(String target) throws FinalunaApplException;

    /**
     * <code>int</code><code>DecimalType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DecimalType toDecimalType(int target);

    /**
     * <code>String</code><code>DecimalType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DecimalType toDecimalType(String target);

    /**
     * <code>String</code><code>DecimalType<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     * @throws FinalunaApplException ꂽ񂪂ꍇAFinalunaApplExceptionX[B
     */
    public DecimalType toDecimalTypeExact(String target) throws FinalunaApplException;

    /**
     * <code>String</code><code>DateType<code>ɕϊB
     * 
     * <p>
     * DateTypeێ͔N̂߁AN̂ݐݒ肳B
     * wtH[}bgFyyyy-MM-dd <br/>
     * target̐ݒF2009-10-10
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateType toDateType(String target);

    /**
     * <code>String</code><code>TimeType<code>ɕϊB
     * 
     * <p>
     * TimeTypeێ͎b̂߁Ab̂ݐݒ肳B
     * wtH[}bgFHH:mm:ss <br/>
     * target̐ݒF10:20:30
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimeType toTimeType(String target);

    /**
     * <code>String</code><code>TimestampType<code>ɕϊB
     * 
     * <p>
     * wtH[}bgFyyyy-MM-dd HH:mm:ss or yyyy-MM-dd HH:mm:ss.S`S (9ȓ) <br/>
     * target̐ݒF2009-10-10 10:20:30
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public TimestampType toTimestampType(String target);

    /**
     * <code>String</code><code>DateAndTimeType<code>ɕϊB
     * 
     * <p>
     * wtH[}bgFyyyy-MM-dd HH:mm:ss <br/>
     * target̐ݒF2009-10-10 10:20:30
     * </p>
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public DateAndTimeType toDateAndTimeType(String target);

    /**
     * <code>StringCode</code><code>String<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public String toString(StringCode target);

    /**
     * <code>String</code><code>StringCode<code>ɕϊB
     * 
     * @param target ϊÕIuWFNg
     * @return ϊ̃IuWFNg
     */
    public StringCode toStringCode(String target);

}
