/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util;

import jp.finaluna.api.type.DateAndTimeType;
import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.FinalunaFormatException;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.StringCode;
import jp.finaluna.api.type.TimeType;
import jp.finaluna.api.type.TimestampType;

/**
 * t̏óA͂s[eBeB
 * 
 * <p>
 * p^[w肵āAt̏óA͂sB
 * </p>
 * 
 * <p>
 * p^[͈ȉ̕gݍ킹Ďw肷B
 * <table border="1">
 * <tr><td>G</td><td></td><td>apP[ݒ肳ĂꍇAG̐ŘavpeBt@C
 * `Ăǂ̘a\Lgp邩肷B<br>
 * ijavpeBu19890108=h,H,v̏ꍇAGuhvAGGuHvAGGGuv</td></tr>
 * <tr><td>y</td><td>N</td><td>iF2009Nj
 * yyyyu2009vAyyu09vAiapP[Łjyyu21v</td></tr>
 * <tr><td>M</td><td></td><td>iF3j@MMu03v</td></tr>
 * <tr><td>d</td><td></td><td>iF3j@ddu03v</td></tr>
 * <tr><td>H</td><td>i24\Lj</td><td>iFߌPj@HHu13v</td></tr>
 * <tr><td>m</td><td></td><td>iF15j@mmu15v</td></tr>
 * <tr><td>s</td><td>b</td><td>iF20bj@ssu20v</td></tr>
 * <tr><td>S</td><td>~b</td><td>iF123~bj@SSSu123v~b͐؂̂</td></tr>
 * <tr><td>N</td><td>imb</td><td>iF123456789imbj@NNNNNNNNNu123456789v~b܂</td></tr>
 * <tr><td>Z</td><td>^C][</td><td>iF{ԁj@Zu+0900v</td></tr>
 * </table>
 * </p>
 * 
 * @author NTTf[^
 * @version $Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $
 */
@Rcsid("$Revision: 38309 $ $Date: 2010-03-18 17:14:55 +0900 $")
public interface DateFormatUtil {

    /**
     * <p>
     * w肳ꂽp^[<code>DateType</code>ϊt <code>StringCode</code> Ŏ擾B
     * </p>
     * 
     * @param date tf[^
     * @param pattern ttH[}bgp^[
     * @return tH[}bgt
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    StringCode format(DateType date, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[<code>TimeType</code>ϊ <code>StringCode</code> Ŏ擾B
     * </p>
     * 
     * @param time f[^
     * @param pattern tH[}bgp^[
     * @return tH[}bg
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    StringCode format(TimeType time, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[<code>DateAndTimeType</code>ϊ <code>StringCode</code> Ŏ擾B
     * </p>
     * 
     * @param dateTime f[^
     * @param pattern tH[}bgp^[
     * @return tH[}bg
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    StringCode format(DateAndTimeType dateTime, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[<code>TimestampType</code>ϊ^CX^v <code>StringCode</code> Ŏ擾B
     * </p>
     * 
     * <p>
     * aP[Ńp^[ɔN(y)w肳N(G)w肳ĂȂꍇFinalunaFormatExceptionX[B
     * </p>
     * 
     * @param timestamp ^CX^vf[^
     * @param pattern ^CX^vtH[}bgp^[
     * @return tH[}bg^CX^v
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    StringCode format(TimestampType timestamp, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[œtϊA <code>DateType</code> Ŏ擾B
     * </p>
     * 
     * <p>
     * aP[Ńp^[ɔN(y)w肳N(G)w肳ĂȂꍇFinalunaFormatExceptionX[B
     * </p>
     * 
     * @param dateString t
     * @param pattern ttH[}bgp^[
     * @return ͂tf[^
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    DateType toDateType(StringCode dateString, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[ŎϊA <code>TimeType</code> Ŏ擾B
     * </p>
     * 
     * <p>
     * aP[Ńp^[ɔN(y)w肳N(G)w肳ĂȂꍇFinalunaFormatExceptionX[B
     * </p>
     * 
     * @param timeString 
     * @param pattern tH[}bgp^[
     * @return ͂f[^
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    TimeType toTimeType(StringCode timeString, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[œϊA <code>DateAndTimeType</code> Ŏ擾B
     * </p>
     * 
     * <p>
     * aP[Ńp^[ɔN(y)w肳N(G)w肳ĂȂꍇFinalunaFormatExceptionX[B
     * </p>
     * 
     * @param dateAndTimeString 
     * @param pattern tH[}bgp^[
     * @return ͂f[^
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    DateAndTimeType toDateAndTimeType(StringCode dateAndTimeString, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽp^[Ń^CX^vϊA <code>TimestampType</code> Ŏ擾B
     * </p>
     * 
     * @param timestampString ^CX^v
     * @param pattern ^CX^vtH[}bgp^[
     * @return ͂^CX^vf[^
     * @throws FinalunaFormatException tH[}bgE͏Ɏsꍇ
     */
    TimestampType toTimestampType(StringCode timestampString, StringCode pattern) throws FinalunaFormatException;

    /**
     * <p>
     * w肳ꂽt񂪁AJ_[ɑ݂t𔻒肷B
     * </p>
     * 
     * <p>
     * aP[Ńp^[ɔN(y)w肳N(G)w肳ĂȂꍇfalseԂB
     * </p>
     * 
     * @param dateString t
     * @param pattern ttH[}bgp^[
     * @return p^[ɉtȂtrueAłȂfalse
     */
    boolean isDateString(StringCode dateString, StringCode pattern);
}
