/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util.validator;

import jp.finaluna.api.type.DateType;
import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.util.MathUtil;

/**
 * <code>DateType</code>^̓̓`FbNs@\B
 * <p>
 * t̑O֌W̃`FbNAt͈̔̓`FbNȂǂsB
 * </p>
 * 
 * @version $Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $")
public interface DateValidator {

    /**
     * <p>
     * <code>DateType</code>^͈̔̓`FbNsB
     * <p>
     * <code>range</code>̋Ȅ<br>
     * 
     * <pre>
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     * </pre>
     * 
     * <br>
     * <code>range</code>ɕsȒlݒ肳ĂꍇAFinalunaSysExceptionthrowB
     * <p>
     * 
     * @param value Ώےl
     * @param min ŏl
     * @param max ől
     * @param range Ȅێl<br>
     * @return ΏےlE͈͓ɂꍇA<code>true</code><br>
     *         ΏےlE͈͊OɂꍇA<code>false</code><br>
     *         ΏےlEŏlEőlnull̏ꍇA<code>false</code><br>
     *         ΏےlEŏl  ől̏ꍇA<code>false</code><br>
     */
    boolean isInRange(DateType value, DateType min, DateType max, MathUtil.InRange range);

    /**
     * <p>
     * tw肵tɂ邩`FbNB
     * <p>
     * `FbN̍ہArt܂܂ȂB
     * <p>
     * <code>afterDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value t
     * @param afterDate rt
     * @return trtɂꍇA<code>true</code><br>
     *         trtOɂꍇA<code>false</code><br>
     *         trtƓꍇA<code>false</code><br>
     *         tErtnullłꍇA<code>false</code><br>
     */
    boolean isAfter(DateType value, DateType afterDate);

    /**
     * <p>
     * tw肵tɂ邩`FbNB
     * <p>
     * `FbN̍ہArt܂ށB
     * <p>
     * <code>afterDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value t
     * @param afterDate rt
     * @return trtɂꍇA<code>true</code><br>
     *         trtOɂꍇA<code>false</code><br>
     *         trtƓꍇA<code>true</code><br>
     *         tErtnullłꍇA<code>false</code><br>
     */
    boolean isOnAndAfter(DateType value, DateType afterDate);

    /**
     * <p>
     * tw肵tOɂ邩`FbNB
     * <p>
     * `FbN̍ہArt܂܂ȂB
     * <p>
     * <code>beforeDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value t
     * @param beforeDate rt
     * @return trtOɂꍇA<code>true</code><br>
     *         trtɂꍇA<code>false</code><br>
     *         trtƓꍇA<code>false</code><br>
     *         tErtnullłꍇA<code>false</code><br>
     */
    boolean isBefore(DateType value, DateType beforeDate);

    /**
     * <p>
     * tw肵tOɂ邩`FbNB
     * <p>
     * `FbN̍ہArt܂ށB
     * <p>
     * <code>beforeDate</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value t
     * @param beforeDate rt
     * @return trtOɂꍇA<code>true</code><br>
     *         trtɂꍇA<code>false</code><br>
     *         trtƓꍇA<code>true</code><br>
     *         tErtnullłꍇA<code>false</code><br>
     */
    boolean isOnAndBefore(DateType value, DateType beforeDate);

}
