/*
 * Copyright (C) 2010 NTT DATA Corporation.
 */

package jp.finaluna.api.type.util.validator;

import jp.finaluna.api.type.Rcsid;
import jp.finaluna.api.type.TimestampType;
import jp.finaluna.api.type.util.MathUtil;

/**
 * <code>TimestampType</code>^̓̓`FbNs@\B
 * <p>
 * ̑O֌W̃`FbNA͈̔̓`FbNȂǂsB
 * </p>
 * 
 * @version $Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $
 * @author NTTf[^
 */
@Rcsid("$Revision: 16647 $ $Date: 2009-02-02 17:26:13 +0900 $")
public interface TimestampValidator {

    /**
     * <p>
     * TimestampType^͈̔̓`FbNsB
     * <p>
     * <code>range</code>̋Ȅ<br>
     * 
     * <pre>
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     *         ŏlΏہől
     * 
     * </pre>
     * 
     * <br>
     * <code>range</code>ɕsȒlݒ肳ĂꍇAFinalunaSysExceptionthrowB
     * <p>
     * 
     * @param value Ώےl
     * @param min ŏl
     * @param max ől
     * @param range Ȅێl<br>
     * @return ΏےlE͈͓ɂꍇA<code>true</code><br>
     *         ΏےlE͈͊OɂꍇA<code>false</code><br>
     *         ΏےlEŏlEőlnull̏ꍇA<code>false</code><br>
     *         ΏےlEŏl  ől̏ꍇA<code>false</code><br>
     */
    boolean isInRange(TimestampType value, TimestampType min, TimestampType max, MathUtil.InRange range);

    /**
     * <p>
     * tw肵tɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂܂ȂB
     * <p>
     * <code>afterTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value 
     * @param afterTime r
     * @return rɂꍇA<code>true</code><br>
     *         rOɂꍇA<code>false</code><br>
     *         rƓꍇA<code>false</code><br>
     *         ErnullłꍇA<code>false</code><br>
     */
    boolean isAfter(TimestampType value, TimestampType afterTime);

    /**
     * <p>
     * tw肵tɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂ށB
     * <p>
     * <code>afterTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value 
     * @param afterTime r
     * @return rɂꍇA<code>true</code><br>
     *         rOɂꍇA<code>false</code><br>
     *         rƓꍇA<code>true</code><br>
     *         ErnullłꍇA<code>false</code><br>
     */
    boolean isOnAndAfter(TimestampType value, TimestampType afterTime);

    /**
     * <p>
     * tw肵tOɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂܂ȂB
     * <p>
     * <code>beforeTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value t
     * @param beforeTime rt
     * @return trtOɂꍇA<code>true</code><br>
     *         trtɂꍇA<code>false</code><br>
     *         rƓꍇA<code>false</code><br>
     *         tErtnullłꍇA<code>false</code><br>
     */
    boolean isBefore(TimestampType value, TimestampType beforeTime);

    /**
     * <p>
     * tw肵tOɂ邩`FbNB
     * <p>
     * `FbN̍ہAr܂ށB
     * <p>
     * <code>beforeTime</code>  <code>NULL</code> l̏ꍇA <code>false</code> ԋpB
     * </p>
     * 
     * @param value t
     * @param beforeTime rt
     * @return trtOɂꍇA<code>true</code><br>
     *         trtɂꍇA<code>false</code><br>
     *         rƓꍇA<code>true</code><br>
     *         tErtnullłꍇA<code>false</code><br>
     */
    boolean isOnAndBefore(TimestampType value, TimestampType beforeTime);

}
