/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator;

import com.small_it_office.flatserve.validator.ValidatorConfig;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageResource {
    private ResourceBundle defaultBundle;
    private ResourceBundle bundle;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public MessageResource(ValidatorConfig validatorConfig) {
        String bundleName = validatorConfig.getMessageBundleName();
        Locale locale = validatorConfig.getMessageLocale();
        this.defaultBundle = ResourceBundle.getBundle("flatserve-validation-error-messages", locale);
        if (bundleName != null) {
            try {
                this.bundle = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (MissingResourceException e) {
                this.logger.warn("FSVLD-LOGW002", new Object[]{bundleName});
                this.bundle = null;
                return;
            }
            this.logger.debug("FSVLD-LOGD027", new Object[]{bundleName});
        }
    }

    public String getString(String key, Object ... params) {
        String result = null;
        if (this.bundle != null) {
            try {
                result = this.bundle.getString(key);
            }
            catch (MissingResourceException e) {
                this.logger.debug("FSVLD-LOGD028", new Object[]{key});
            }
        }
        if (result == null) {
            result = this.defaultBundle.getString(key);
        }
        return MessageFormat.format(result, params);
    }
}

