/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.mapping.internal;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.Param;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapping;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMappingFactory;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMappingFactoryImpl;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.ValidationRuleList;
import com.small_it_office.flatserve.validator.internal.util.AnnotationUtil;
import com.small_it_office.flatserve.validator.processor.internal.ParameterValidationProcessor;
import com.small_it_office.flatserve.validator.processor.internal.ParameterValidationProcessorImpl;
import com.small_it_office.flatserve.validator.type.internal.TypeValidation;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationParameterMapping<T>
implements RequestParameterMapping {
    private MessageResource messageResource;
    private ParameterValidationProcessor<T> processor;
    private Class<T> type;
    private RequestParameterMappingFactory deligatingMappingFactory;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public ValidationParameterMapping(MessageResource messageResource, TypeValidation<T> typeValidation, Config config, Class<T> type) {
        this.messageResource = messageResource;
        this.processor = new ParameterValidationProcessorImpl<T>(messageResource, typeValidation);
        this.type = type;
        this.deligatingMappingFactory = new RequestParameterMappingFactoryImpl(config);
    }

    public T mapParameter(RequestContext context, Annotation[] annotations) {
        String paramName = this.getParameterName(annotations);
        if (paramName == null) {
            this.logger.debug("FSVLD-LOGD008", new Object[0]);
            RequestParameterMapping mapping = this.deligatingMappingFactory.getMapping(this.type);
            return this.type.cast(mapping.mapParameter(context, annotations));
        }
        ValidationRuleList ruleList = ValidationRuleList.assignRules(annotations, this.messageResource);
        return this.processor.process(context, ruleList, paramName, annotations);
    }

    private String getParameterName(Annotation[] annotations) {
        Param paramAnnotation = AnnotationUtil.findAnnotation(annotations, Param.class);
        return paramAnnotation == null ? null : paramAnnotation.value();
    }
}

