/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.processor.internal;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.ValidationRuleList;
import com.small_it_office.flatserve.validator.internal.util.AnnotationUtil;
import com.small_it_office.flatserve.validator.internal.util.ErrorUtil;
import com.small_it_office.flatserve.validator.processor.internal.ParameterValidationProcessor;
import com.small_it_office.flatserve.validator.rule.ItemName;
import com.small_it_office.flatserve.validator.type.internal.ArrayTypeValidation;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayParameterValidationProcessor<T>
implements ParameterValidationProcessor<T> {
    private MessageResource messageResource;
    private ArrayTypeValidation<T> typeValidation;
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    public ArrayParameterValidationProcessor(MessageResource messageResource, ArrayTypeValidation<T> typeValidation) {
        this.messageResource = messageResource;
        this.typeValidation = typeValidation;
    }

    @Override
    public T process(RequestContext context, ValidationRuleList ruleList, String paramName, Annotation[] annotations) {
        T value;
        String itemName;
        HttpServletRequest request = context.getHttpServletRequest();
        String[] valueString = request.getParameterValues(paramName);
        ItemName itemNameAnnotation = AnnotationUtil.findAnnotation(annotations, ItemName.class);
        String string = itemName = itemNameAnnotation == null ? null : itemNameAnnotation.value();
        if (valueString == null) {
            this.logger.debug("FSVLD-LOGD020", new Object[]{paramName});
            value = null;
        } else {
            if (!this.validateArrayElementType(context, paramName, valueString, annotations, itemName)) {
                this.logger.debug("FSVLD-LOGD010", new Object[]{paramName});
                return null;
            }
            this.logger.debug("FSVLD-LOGD011", new Object[]{paramName});
            value = this.typeValidation.validTypeValue(valueString, annotations);
        }
        this.logger.debug("FSVLD-LOGD012", new Object[]{paramName});
        if (!ruleList.validateRules(context, paramName, valueString, value, itemName)) {
            this.logger.debug("FSVLD-LOGD013", new Object[]{paramName});
            return null;
        }
        return value;
    }

    private boolean validateArrayElementType(RequestContext context, String paramName, String[] valueString, Annotation[] annotations, String itemName) {
        boolean result = true;
        for (int i = 0; i < valueString.length; ++i) {
            if (this.typeValidation.isValidType(valueString[i], annotations)) continue;
            result = false;
            String message = this.typeValidation.getInvalidTypeMessage(this.messageResource, valueString[i], annotations);
            message = ErrorUtil.addItemNameMessage(this.messageResource, itemName, message);
            ErrorUtil.createValidationErrorObject(context, paramName, valueString, message, i);
        }
        return result;
    }
}

