/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.validator.type.internal;

import com.small_it_office.flatserve.core.UnexpectedException;
import com.small_it_office.flatserve.validator.MessageResource;
import com.small_it_office.flatserve.validator.internal.util.AnnotationUtil;
import com.small_it_office.flatserve.validator.rule.NumberFormat;
import com.small_it_office.flatserve.validator.type.internal.TypeValidation;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;
import java.lang.annotation.Annotation;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongTypeValidation
implements TypeValidation<Long> {
    private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

    @Override
    public Long getNullValue() {
        return null;
    }

    @Override
    public String getInvalidTypeMessage(MessageResource messageResource, String value, Annotation[] annotations) {
        return messageResource.getString("message.error.type.long", value);
    }

    @Override
    public boolean isValidType(String value, Annotation[] annotations) {
        if (value == null) {
            this.logger.debug("FSVLD-LOGD020", new Object[0]);
            return true;
        }
        NumberFormat numberFormatAnnotation = AnnotationUtil.findAnnotation(annotations, NumberFormat.class);
        if (numberFormatAnnotation == null) {
            try {
                Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return this.isValidFormat(value, numberFormatAnnotation.value());
    }

    private boolean isValidFormat(String value, String format) {
        this.logger.debug("FSVLD-LOGD021", new Object[]{value, format});
        DecimalFormat snf = new DecimalFormat(format);
        ParsePosition position = new ParsePosition(0);
        Number number = snf.parse(value, position);
        if (number == null) {
            this.logger.debug("FSVLD-LOGD022", new Object[]{value, position.getErrorIndex() + 1});
            return false;
        }
        if (position.getIndex() < value.length()) {
            this.logger.debug("FSVLD-LOGD023", new Object[]{value, position.getIndex() + 1});
            return false;
        }
        boolean result = number instanceof Long;
        if (!result) {
            this.logger.debug("FSVLD-LOGD024", new Object[]{value, Long.class.getName()});
        }
        return result;
    }

    @Override
    public Long validTypeValue(String value, Annotation[] annotations) {
        if (value == null) {
            return this.getNullValue();
        }
        NumberFormat numberFormatAnnotation = AnnotationUtil.findAnnotation(annotations, NumberFormat.class);
        if (numberFormatAnnotation == null) {
            return Long.valueOf(value);
        }
        DecimalFormat snf = new DecimalFormat(numberFormatAnnotation.value());
        try {
            return (Long)snf.parse(value);
        }
        catch (ParseException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

