/*
 * Copyright 2009-2016 Cosmos Inc. All right reserved.
 * http://www.cos-mos.co.jp/
 */

// 名称
var NAME = "DML Breaker";
// バージョン
var VERSION = "3.02";
// コピーライト
var COPYRIGHT = "Copyright 2009-2016 <a href=\"http://www.cos-mos.co.jp/\" target=\"_blank\">Cosmos Inc.</a> All right reserved.";

// ブランク画像（サーバーを指定しない）
Ext.BLANK_IMAGE_URL = "ext/resources/images/default/s.gif";

// 入力タブID管理
var inTabId = 3;

// ブラウザ識別
var userAgent = window.navigator.userAgent.toLowerCase();
// IE
var ieFlg = userAgent.indexOf("msie") != -1 || userAgent.indexOf("trident") != -1;
// Chrome
var chromeFlg = userAgent.indexOf("chrome") != -1;
// Safari
var safariFlg = userAgent.indexOf("AppleWebKit") != -1;
// Sleipnir(Chrome)
var sleipnirFlg = userAgent.indexOf("sleipnir") != -1;

// 言語
var language = "ja";
if (document.all) {
	language = navigator.browserLanguage;
} else if (document.layers) {
	language = navigator.language;
} else {
	language = navigator.language.substr(0, 2);
}

// 定数(言語別)
var constant={};

if (language == "ja") {

	// 日本版
	constant = {
		ui: {
			fileOutput: "ファイル出力(ALL)",
			tabAdd: "新しいタブを追加",
			formatShortcut: "整形ショートカット",
			tabName: "新しいタブ",
			inputEmptyText: "ここにDML(SQL)を入力し、[整形]ボタンを押下してください。",
			btnFormat: "整形",
			btnClear: "クリア",
			btnConfig: "設定"
		},
		config: {
			message: "初期値はconfig.jsで設定できます。",
			indent: {name: "インデント", v1: "スペース4", v2: "タブ"},
			andor: {name: "AND/OR/ON位置", v1: "前1", v2: "前2", v3: "後"},
			comma: {name: "カンマ位置", v1: "前", v2: "後"},
			caseFormat: {name: "CASE整形", v1: "有効", v2: "無効"},
			keyword: {name: "キーワード", v1: "変換なし", v2: "小文字", v3: "大文字"},
			lineBreak: {name: "改行コード", v1: "CR+LF", v2: "LF"},
			formatSqlEnd: {name: "整形後SQLの末尾", v1: "処理なし", v2: "空白行を付与"}
		},
		message: {
			title: "確認",
			emptyInput: "DML(SQL)が未入力です。",
			noSupportBrowser: "対応していないブラウザです。",
			noSupportMultiFileOutput: "複数のファイル出力に対応してません。",
			isMultiFileOutput: "整形結果をファイル出力しますか？"
		}
	}

} else {

	// 英語版
	constant = {
		ui: {
			fileOutput: "FileOutput(ALL)",
			tabAdd: "NewTabAdd",
			formatShortcut: "FormatShortcut",
			tabName: "NewTab",
			inputEmptyText : "Please input DML(SQL) here and push the Format button.",
			btnFormat: "Format",
			btnClear: "Clear",
			btnConfig: "Config"
		},
		config: {
			message: "The initial value you can be set in config.js.",
			indent: {name: "Indent", v1: "Space4", v2: "Tab"},
			andor: {name: "AND/OR/ON", v1: "Front1", v2: "Front2", v3: "Back"},
			comma: {name: "Comma", v1: "Front", v2: "Back"},
			caseFormat: {name: "CASE", v1: "Enable", v2: "Disable"},
			keyword: {name: "Keyword", v1: "None", v2: "LowerCase", v3: "UpperCase"},
			lineBreak: {name: "LineBreak", v1: "CR+LF", v2: "LF"},
			formatSqlEnd: {name: "FormatSqlEnd", v1: "None", v2: "BlankLine"}
		},
		message: {
			title: "Confirm",
			emptyInput: "DML(SQL) is a uninput.",
			noSupportBrowser: "It is a browser that does not support this.",
			noSupportMultiFileOutput: "It does not support multiple file output.",
			isMultiFileOutput: "Do you want to file output?"
		}
	}
}

Ext.onReady(function() {

	// タイトル
//	document.title = NAME + " " + VERSION;

	// 入力テキストエリア
	var inTextarea = {
		id: "inTextarea",
		xtype: "tabpanel",
		activeTab: 0,
		enableTabScroll: true,
		deferredRender: false,
		resizeTabs: true,
		minTabWidth: 150,
		items: [
			{
				id: "inTab1",
				title: constant.ui.tabName + " (1)",
				layout: "fit",
				closable: false,
				xtype: "textarea",
				emptyText: constant.ui.inputEmptyText,
				style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
			},
			{
				id: "inTab2",
				title: constant.ui.tabName + " (2)",
				layout: "fit",
				closable: true,
				xtype: "textarea",
				emptyText: constant.ui.inputEmptyText,
				style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
			},
			{
				id: "inTab3",
				title: constant.ui.tabName + " (3)",
				layout: "fit",
				closable: true,
				xtype: "textarea",
				emptyText: constant.ui.inputEmptyText,
				style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
			}
		]
	};

	// Plain Textタブ
	var outPlainText = {
		id: "outPlainText",
		xtype: "textarea",
		style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
	};

	// Rich Textタブ
	var outRichText = {
		id: "outRichText",
		xtype: "box",
		autoScroll: true,
		style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
	};

	// Line Textタブ
	var outLineText = {
		id: "outLineText",
		xtype: "textarea",
		style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
	};

	// Historyタブ
	var outHistory = {
		id: "outHistory",
		xtype: "textarea",
		style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
	};

	// Config
	var setConfig = {
		id: "setConfig",
		xtype: "box",
		autoScroll: true,
		style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;font-size:11px;"
	};

	// 入力パネルを作成
	var inputPanel = new Ext.Panel({
		id: "inPanel",
		title: "<span style='font-size:20px;'>" + NAME + " " + VERSION + "</span>　　" +
			"Config [" +
			constant.config.indent.name + "：<indent></indent>、" +
			constant.config.andor.name + "：<andor></andor>、" +
			constant.config.comma.name + "：<comma></comma>、" +
			constant.config.caseFormat.name + "：<caseFormat></caseFormat>、" +
			constant.config.keyword.name + "：<keyword></keyword>" +
		"]",
		collapsible: true,
		height: inputPanelHeight,
		layout: "fit",
		items: [inTextarea],
		buttons: [
			{id: "btnFormat", text: constant.ui.btnFormat, handler: onClickBtnFormat},
			{id: "btnClear", text: constant.ui.btnClear, handler: onClickBtnClear},
			{id: "btnConfig", text: constant.ui.btnConfig, handler: onClickBtnConfig, enableToggle: true, pressed: conifgStatus == 1}
		],
		tbar: {
			items: [
				{
					id: "tbarFileAll", text: constant.ui.fileOutput, handler: function() {
						onClickFileExport("all", "");
					}
				},
/*
				{
					id: "tbarInputText", text: "InputText", handler: function() {
						onClickFileExport(Ext.getCmp("inTextarea").getActiveTab().id, "sql");
					}
				},
*/
				{
					id: "tbarPlainText", text: "PlainText", handler: function() {
						onClickFileExport("outPlainText", "sql");
					}
				},
				{
					id: "tbarRichText", text: "RichText", handler: function() {
						onClickFileExport("outRichText", "html");
					}
				},
				{
					id: "tbarLineText", text: "LineText", handler: function() {
						onClickFileExport("outLineText", "sql");
					}
				},
				{
					id: "tbarHistory", text: "History", handler: function() {
						onClickFileExport("outHistory", "txt");
					}
				},
				"-",
				{
					text: constant.ui.tabAdd, handler: function() {
						inTabId += 1;
						var panel = Ext.getCmp("inTextarea").add({
							id: "inTab" + inTabId,
							title: constant.ui.tabName + " (" + inTabId + ")",
							layout: "fit",
							closable: true,
							xtype: "textarea",
							emptyText: constant.ui.inputEmptyText,
							style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;"
						});
						Ext.getCmp("inTextarea").setActiveTab(panel);
					}
				},
				"-",
				{
					text: "【IE】" + constant.ui.formatShortcut, handler: function() {

						if (window.clipboardData){

							// クリップボードから貼り付けて、整形して、クリップボードへ設定する
							Ext.getCmp("inTextarea").getActiveTab().setValue(clipboardData.getData("Text"));
							onClickBtnFormat();
							clipboardData.setData("Text", Ext.getCmp("outPlainText").getValue());

						} else {

							Ext.MessageBox.alert(constant.message.title, constant.message.noSupportBrowser);
						}
					}
				}
			]
		},
		region: "north"
	});

	// Rich Textタブを表示しない
	if (configRichTab == 2) {

		inputPanel["topToolbar"]["items"].removeKey("tbarRichText");
	}

	// Line Textタブを表示しない
	if (configLineTab == 2) {

		inputPanel["topToolbar"]["items"].removeKey("tbarLineText");
	}

	// Historyタブを表示しない
	if (configHistoryTab == 2) {

		inputPanel["topToolbar"]["items"].removeKey("tbarHistory");
	}

	// 出力パネルを作成
	var outPanel = new Ext.Panel({
		id: "outPanel",
		title: "",
		layout: "fit",
		items: [
			{
				id: "outTab",
				xtype: "tabpanel",
				activeTab: 0,
				enableTabScroll: true,
				deferredRender: false,
				items: [
					{
						id: "outPlainTab",
						title: "Plain Text",
						layout: "fit",
						items: outPlainText
					},
					{
						id: "outRichTab",
						title: "Rich Text",
						layout: "fit",
						items: {
							xtype: "panel",
//							layout: "fit",
							autoScroll: true,
							items: outRichText
						},
						preventBodyReset: true,
						style: "background-color:yellow;font-size:11px;",
						listeners: {activate: selectRichTextTab}
					},
					{
						id: "outLineTab",
						title: "Line Text",
						layout: "fit",
						items: outLineText
					},
					{
						id: "outHistoryTab",
						title: "History",
						layout: "fit",
						items: outHistory
					}
				]
			}
		],
		region: "center"
	});

	// Rich Textタブを表示しない
	if (configRichTab == 2) {

		outPanel["items"]["items"][0]["items"].removeKey("outRichTab");
	}

	// Line Textタブを表示しない
	if (configLineTab == 2) {

		outPanel["items"]["items"][0]["items"].removeKey("outLineTab");
	}

	// Historyタブを表示しない
	if (configHistoryTab == 2) {

		outPanel["items"]["items"][0]["items"].removeKey("outHistoryTab");
	}

	// Viewportを設定
	new Ext.Viewport({
		layout: "border",
		defaults: {split: true},
		items: [
			inputPanel,
			outPanel,
			{
				id: "conifgPanel",
				title: "Conifg",
				collapsible: true,
				collapsed: conifgStatus == 1 ? false : true,
				collapseMode: "mini",
				xtype: "panel",
				height: 0,
				width: 450,
				layout: "fit",
				region: "east",
				html: getConfigHtml(),
				style: "font-family: \"Courier New\", Courier, monospace;font-weight: normal;font-size:11px;",
				listeners: {expand: onClickConfigPanel, collapse: onClickConfigPanel}
			},
			{
				xtype: "panel",
				layout: "fit",
				split: false,
				border: false,
				bodyBorder: false,
				preventBodyReset: true,
				region: "south",
				style: "padding:5px;color:#15428b;font:bold 11px tahoma,arial,verdana,sans-serif;",
				html: "<div style=\"background-color:#dfe8f6;\">" +
					"<center>" + COPYRIGHT + "</center>" +
					"<a href=\"javascript:void(0);\" id=\"export\" target=\"_blank\"></a>" +
					"</div>"
			}
		]
	});

	// インデントの設定反映
	var objArray = new Array(
		Ext.getDom("link_indent_" + configIndent),
		Ext.getDom("link_andor_" + configAndor),
		Ext.getDom("link_comma_" + configComma),
		Ext.getDom("link_caseFormat_" + configCaseFormat),
		Ext.getDom("link_keyword_" + configKeyword),
		Ext.getDom("link_lineBreak_" + configLineBreak),
		Ext.getDom("link_formatSqlEnd_" + configFormatSqlEnd)
	);
	for (var i = 0; i < objArray.length; i++) {
		if (objArray[i] != null) {
			objArray[i].click();
		}
	}

	// ファイル出力
	function onClickFileExport(id, type) {

		window.URL = window.URL || window.webkitURL;

		if (typeof window.URL == "undefined" || typeof window.URL.createObjectURL == "undefined") {

			// createObjectURL非対応エラー（Windows Safari5）
			Ext.MessageBox.alert(constant.message.title, constant.message.noSupportBrowser);

			return;

		} else if (typeof Blob == "undefined") {

			// Blob非対応エラー
			Ext.MessageBox.alert(constant.message.title, constant.message.noSupportBrowser);

			return;
		}


		if (ieFlg) {

			if (!window.navigator.msSaveBlob) {

				// msSaveBlob非対応エラー（IE9以下）
				Ext.MessageBox.alert(constant.message.title, constant.message.noSupportBrowser);
			}

		} else if (safariFlg) {

			// 非対応エラー（Safari6、Blobだと保存機能が動作しない）
			Ext.MessageBox.alert(constant.message.title, constant.message.noSupportBrowser);

			return;
		}

		if (id == "all") {

			if (sleipnirFlg) {

				Ext.MessageBox.alert(constant.message.title, constant.message.noSupportMultiFileOutput);

				return;

			}

			var callback = function(btn) {

				if (btn != "yes") {

					return;
				}

				// ブラウザに応じて出力順を決める
				if (chromeFlg) {

/*
					// 入力データをファイル出力
					for (var i = 1; i <= inTabId; i++) {
						var inTab = Ext.getCmp("inTab" + i);
						if (typeof inTab != "undefined" && inTab.getValue() != "") {
							onClickFileExport("inTab" + i, "sql");
						}
					}
*/

					// 出力データをファイル出力
					onClickFileExport("outPlainText", "sql");
					if (configRichTab != 2) {
						onClickFileExport("outRichText", "html");
					}
					if (configLineTab != 2) {
						onClickFileExport("outLineText", "sql");
					}
					if (configHistoryTab != 2) {
						onClickFileExport("outHistory", "txt");
					}

				} else {

					// 出力データをファイル出力
					if (configHistoryTab != 2) {
						onClickFileExport("outHistory", "txt");
					}
					if (configLineTab != 2) {
						onClickFileExport("outLineText", "sql");
					}
					if (configRichTab != 2) {
						onClickFileExport("outRichText", "html");
					}
					onClickFileExport("outPlainText", "sql");

/*
					// 入力データをファイル出力
					for (var i = inTabId; i > 0; i--) {
						var inTab = Ext.getCmp("inTab" + i);
						if (typeof inTab != "undefined" && inTab.getValue() != "") {
							onClickFileExport("inTab" + i, "sql");
						}
					}
*/
				}
			};

			Ext.MessageBox.confirm(constant.message.title, constant.message.isMultiFileOutput, callback);

			return;

		} else if (id == "outRichText") {

			var dom = Ext.getDom(id);
			var data = dom.innerHTML;

			// 未生成の場合は、新しく生成
			if (data == "" && Ext.getCmp("outPlainText").getValue() != "") {
				dom.innerHTML = getRichText(Ext.getCmp("outPlainText").getValue());
				data = dom.innerHTML;
			}

			data = "<html>" +
				"<head>" +
				"<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\">" +
				"<title>" + document.title + "</title>" +
				"<style type=\"text/css\">" +
				"<!--" +
				"hr {border: 0;border-bottom: solid 1px #999;margin: 0;padding: 0;}" +
				"ol {margin: 0px;padding: 5px 0px 5px 50px;background: #FFF;list-style-type: decimal-leading-zero;}" +
				"ol li {padding: 1px 1px 1px 5px;border-left: 3px solid #9BFCA0;}" +
				"ol li.odd {background-color: #FFF;}" +
				"ol li.even {background-color: #EEE;}" +
				"ol li span.highlight {color: #003D84;font-weight: bold;}" +
				"ol li span.string {color: #ED007F;font-weight: bold;}" +
				"ol li span.oracle {color: #00582A;font-weight: bold;}" +
				"-->" +
				"</style>" +
				"</head>" +
				"<body>" + data + "</body>" +
				"</html>";

		} else {

			var data = Ext.getCmp(id).getValue();

			// 改行コードを変換
			if (configLineBreak != 2) {
				data = data.replace(/\n/g, "\r\n");
			}
		}

		var blob = new Blob([data], {"type": "application/x-msdownload"});

		if (ieFlg) {

			// ファイルを保存する
			window.navigator.msSaveBlob(blob, id + "." + type);
//			window.navigator.msSaveOrOpenBlob(blob, id + "." + type);

		} else {

			// 出力リンクを生成して出力
			var exportLink = Ext.getDom("export");
			exportLink.setAttribute("href", window.URL.createObjectURL(blob));
			exportLink.setAttribute("download", id + "." + type);
			exportLink.click();

			// クリア
			exportLink.setAttribute("href", "javascript:void(0);");
			exportLink.removeAttribute("download");
			try {
				window.URL.revokeObjectURL();
			} catch(e) {
			}
		}
	}

	// 整形ボタン押下イベント
	function onClickBtnFormat() {

		// 入力テキストエリアから取得
		var input = Ext.getCmp("inTextarea").getActiveTab().getValue();

		if (input.trim() == "") {

			// 未入力エラー
			Ext.MessageBox.alert(constant.message.title, constant.message.emptyInput);

		} else {

			// 入力タブ名を変更
			var tabTitle = input.trim().substr(0, 20);
			var activeId = "inTextarea__" + Ext.getCmp("inTextarea").getActiveTab().id;
			Ext.DomQuery.select("span[@class='x-tab-strip-text ']", Ext.getDom(activeId))[0].innerHTML = tabTitle;

			// Plain Textタブを生成
			Ext.getCmp("outPlainText").setValue(breakerDML("DML", input));

			if (configRichTab != 2) {

				// Rich Textタブを生成（選択時のみ）
				if (Ext.getCmp("outTab").getActiveTab().id == "outRichTab") {
					selectRichTextTab();
				}
			}

			if (configLineTab != 2) {

				// Line Textタブを生成
				Ext.getCmp("outLineText").setValue(breakerDML("LINE", input));
			}

			if (configHistoryTab != 2) {

				// Historyタブを生成
				var lb = configLineBreak == 2 ? "\n" : "\r\n";
				var value = new Date().toLocaleString() + lb + lb;
				value += "【Input Text】" + lb + input.replace(/\r\n$|\n$/, "") + lb + lb;
				value += "【Plain Text】" + lb + Ext.getCmp("outPlainText").getValue() + lb + lb;
				value += "【Line Text】" + lb + Ext.getCmp("outLineText").getValue() + lb;
				value += "----------------------------------------------------------------------------------------------------" + lb;
				Ext.getCmp("outHistory").setValue(value + Ext.getCmp("outHistory").getValue());
			}
		}
	};

	// クリアボタン押下イベント
	function onClickBtnClear() {

		// クリア
		for (var i = 1; i <= inTabId; i++) {
			var inTab = Ext.getCmp("inTab" + i);
			if (typeof inTab != "undefined") {
				inTab.setValue("");
			}
		}
		Ext.getCmp("outPlainText").setValue("");
		Ext.getDom("outRichText") == null ? "" : Ext.getDom("outRichText").innerHTML = "";
		Ext.getCmp("outLineText").setValue("");
		if (configHistoryTab != 2) {
			Ext.getCmp("outHistory").setValue("");
		}
	};

	// 設定ボタン押下イベント
	function onClickBtnConfig() {

		// Configパネルを展開・収納
		if (Ext.getCmp("btnConfig").pressed) {
			Ext.getCmp("conifgPanel").expand();
		} else {
			Ext.getCmp("conifgPanel").collapse();
		}
	};

	// Rich Textタブを選択
	function selectRichTextTab() {

		if (Ext.getCmp("outPlainText").getValue() != "") {
			Ext.getDom("outRichText").innerHTML = getRichText(Ext.getCmp("outPlainText").getValue());
		} else {
			Ext.getDom("outRichText").innerHTML = "";
		}
	}

	// Configパネルを展開・収納
	function onClickConfigPanel() {

		Ext.getCmp("btnConfig").toggle(!this.collapsed);
	}

	/**
	 * Rich Text用のHTML取得
	 */
	function getRichText(targetStr) {

		if (targetStr == null) {

			return;
		}

		var richText = "";
		var key = "";
		var regExp = "";

		// 固定文言を太字の色付けに変換
		targetStr = targetStr.replace(/'[^']*'|"[^"]*"/g, "<span class=\"string\">$&</span>");

		// 復帰文字を除去して、SQLで分割（簡易版）
		var sqlArray = targetStr.replace(/\r/g, "").replace(/;/g, ";__SEMICOLON__").split("__SEMICOLON__");

		// HTMLに変換
		for (var i = 0; i < sqlArray.length; i++) {

			if (sqlArray[i] == "") {

				continue;
			}

			var text = "";
			var line = sqlArray[i].trim().split("\n");

			for (var j = 0; j < line.length; j++) {

				text += "<li class=\"" + (j % 2 ? "even" : "odd") + "\">" + line[j].replace(/\s\s/g, "&nbsp;&nbsp;") + "</li>";
			}

			richText += "<ol>" + text + "</ol><hr />";
		}

		// 予約語を変換
		richText = convertKeyword(2, richText, "<span class=\"highlight\">KEY</span>", "<span class=\"oracle\">KEY</span>");

		return  richText;
	}
});

// 設定HTML
function getConfigHtml() {

	var html =
			"<table border=\"0\" cellspacing=\"10\" cellpadding=\"10\">" +
				"<tr><td colspan=\"4\">" + constant.config.message + "</td></tr>" +
				"<tr>" +
					"<td>" + constant.config.indent.name + "</td>" +
					getRadioHtml("indent", "1", constant.config.indent.v1) +
					getRadioHtml("indent", "2", constant.config.indent.v2) +
				"</tr>" +
				"<tr>" +
					"<td>" + constant.config.andor.name + "</td>" +
					getRadioHtml("andor", "1", constant.config.andor.v1) +
					getRadioHtml("andor", "2", constant.config.andor.v2) +
					getRadioHtml("andor", "3", constant.config.andor.v3) +
				"</tr>" +
				"<tr>" +
					"<td>" + constant.config.comma.name + "</td>" +
					getRadioHtml("comma", "1", constant.config.comma.v1) +
					getRadioHtml("comma", "2", constant.config.comma.v2) +
				"</tr>" +
				"<tr>" +
					"<td>" + constant.config.caseFormat.name + "</td>" +
					getRadioHtml("caseFormat", "1", constant.config.caseFormat.v1) +
					getRadioHtml("caseFormat", "2", constant.config.caseFormat.v2) +
				"</tr>" +
				"<tr>" +
					"<td>" + constant.config.keyword.name + "</td>" +
					getRadioHtml("keyword", "1", constant.config.keyword.v1) +
					getRadioHtml("keyword", "2", constant.config.keyword.v2) +
					getRadioHtml("keyword", "3", constant.config.keyword.v3) +
				"</tr>" +
				"<tr>" +
					"<td colspan=\"4\"></td>" +
				"</tr>" +
				"<tr>" +
					"<td>" + constant.config.lineBreak.name + "</td>" +
					getRadioHtml("lineBreak", "1", constant.config.lineBreak.v1) +
					getRadioHtml("lineBreak", "2", constant.config.lineBreak.v2) +
				"</tr>" +
				"<tr>" +
					"<td>" + constant.config.formatSqlEnd.name + "</td>" +
					getRadioHtml("formatSqlEnd", "1", constant.config.formatSqlEnd.v1) +
					getRadioHtml("formatSqlEnd", "2", constant.config.formatSqlEnd.v2) +
				"</tr>" +
			"</table>";

	return html;
}

// 設定ラジオボタンHTML
function getRadioHtml(name, no, text) {

	var id1 = "config_" + name + "_" + no;
	var id2 = "link_" + name + "_" + no;
	var reg = new RegExp("<" + name + ">.*<\\/" + name + ">");
	var click1 = "config" + name.charAt(0).toUpperCase() + name.slice(1) + " = " + no + ";" +
		"var p = Ext.getCmp('inPanel');p.setTitle(p.title.replace(" + reg + ", '<" + name + ">" + text + "</" + name + ">'));";
	var click2 = "Ext.getDom('" + id1 + "').click();";
	var style = "color:black;text-decoration:none;";

	var radio = '<input type="radio" id="' + id1 + '" name="' + name + '" value="' + no + '" onclick="' + click1 + '">' +
		'<a id="' + id2 + '" href="javascript:void(0);" onclick="' + click2 + '" style="' + style + '"> ' + text + '</a>';

	return "<td>　" + radio + "</td>";
}

// IE限定、ODBC経由でSQL実行（お遊び中）
function runSQL(sql) {

	if (!ieFlg) {

		Ext.MessageBox.alert(constant.message.title, constant.message.noSupportBrowser);

		return;
	}

	var con = null;
	var rs = null;

	try {

		con = new ActiveXObject("ADODB.Connection");
		con.ConnectionString = "Driver={Oracle in XE};DBQ=XE;UID=system;PWD=manager;"
		con.Open();

		rs = new ActiveXObject("ADODB.Recordset");
		rs.Open(sql, con);

	    var row = 1;
		while (!rs.EOF) {

			var line = "" + row++;

			for (var i = 0; i < rs.Fields.Count; i++) {

				// 日付
				if (rs.Fields(i).Value != null && rs.Fields(i).Type == 135) {

					line += " " + df(new Date(rs.Fields(i).Value));

				} else {

					line += " " + rs.Fields(i).Value;
				}
			}
			alert(line);
			rs.MoveNext();
		}

	} catch (e) {

		alert("【ODBCエラー】" + e);

	} finally {

		try {
			if (rs != null) {
				rs.Close();
			}
		} catch (e) {
		}

		try {
			if (con != null) {
				con.Close();
			}
		} catch (e) {
		}
	}
}