/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.fs;

import java.io.File;
import org.cmc.music.clean.NameRectifier;
import org.cmc.music.fs.ParsedFilename;
import org.cmc.music.metadata.MusicMetadata;
import org.cmc.music.myid3.TagFormat;
import org.cmc.music.util.TextUtils;

public abstract class FSParser {
    private static final TagFormat utils = new TagFormat();
    private static final NameRectifier nameRectifier = new NameRectifier();

    public static final ParsedFilename parseFolder(File file) {
        return FSParser.parseFolder(file.getName());
    }

    public static final ParsedFilename parseFolder(String s) {
        ParsedFilename result = new ParsedFilename(s);
        int hyphen_count = TextUtils.split(s, "-").length - 1;
        if (hyphen_count != 1) {
            return result;
        }
        String artist = s.substring(0, s.indexOf(45));
        String album = s.substring(s.indexOf(45) + 1);
        artist = nameRectifier.rectifyArtist(artist);
        album = nameRectifier.rectifyAlbum(album);
        if (artist == null && album == null) {
            return result;
        }
        result.setArtist(artist);
        result.setAlbum(album);
        return result;
    }

    public static final boolean isTrackNumber(String s) {
        if (s == null) {
            return false;
        }
        if ((s = s.trim()).length() < 1 || s.length() > 3) {
            return false;
        }
        if (TextUtils.kALPHABET.indexOf(s.charAt(0)) >= 0 && (s = s.substring(1)).length() < 1) {
            return false;
        }
        return TextUtils.filter(s, "0123456789").equals(s);
    }

    private static Number getTrackNumber(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final MusicMetadata parseFilename(String fileName, String folderName) {
        String song_title;
        Number track_number;
        String artist;
        if (fileName == null) {
            return null;
        }
        if (!fileName.toLowerCase().endsWith(".mp3")) {
            return null;
        }
        String[] splits = (fileName = fileName.substring(0, fileName.length() - 4)).split("-");
        if (splits.length == 2) {
            if (FSParser.isTrackNumber(splits[0])) {
                artist = null;
                track_number = FSParser.getTrackNumber(splits[0].trim());
                song_title = utils.processSongTitle(splits[1]);
            } else if (FSParser.isTrackNumber(splits[1])) {
                artist = null;
                song_title = utils.processSongTitle(splits[0]);
                track_number = FSParser.getTrackNumber(splits[1].trim());
            } else {
                artist = utils.processArtist(splits[0]);
                song_title = utils.processSongTitle(splits[1]);
                track_number = null;
            }
        } else {
            if (splits.length != 3) return null;
            if (FSParser.isTrackNumber(splits[0])) {
                track_number = FSParser.getTrackNumber(splits[0].trim());
                artist = utils.processArtist(splits[1]);
                song_title = utils.processSongTitle(splits[2]);
            } else {
                if (!FSParser.isTrackNumber(splits[1])) return null;
                artist = utils.processArtist(splits[0]);
                track_number = FSParser.getTrackNumber(splits[1].trim());
                song_title = utils.processSongTitle(splits[2]);
            }
        }
        if (FSParser.isTrackNumber(artist)) {
            return null;
        }
        if (FSParser.isTrackNumber(song_title)) {
            return null;
        }
        if (folderName != null && folderName.endsWith("(!)")) {
            folderName = folderName.substring(0, folderName.length() - 3);
        }
        String kVariousArtists = "Various Artists";
        String album = null;
        if (folderName != null && !folderName.startsWith("@")) {
            if (artist != null) {
                if (folderName.toLowerCase().startsWith(kVariousArtists.toLowerCase())) {
                    folderName = folderName.substring(kVariousArtists.length());
                } else if (folderName.toLowerCase().startsWith(artist.toLowerCase())) {
                    folderName = folderName.substring(artist.length());
                } else {
                    if (!folderName.toLowerCase().endsWith(artist.toLowerCase())) return null;
                    folderName = folderName.substring(0, folderName.length() - artist.length());
                }
                album = utils.processAlbum(folderName);
            } else {
                int first_hyphen = folderName.indexOf(45);
                int last_hyphen = folderName.lastIndexOf(45);
                if (first_hyphen < 0 || first_hyphen != last_hyphen) return null;
                artist = utils.processArtist(folderName.substring(0, first_hyphen));
                album = utils.processAlbum(folderName.substring(first_hyphen + 1));
            }
        }
        if (artist == null) {
            return null;
        }
        if (artist.equalsIgnoreCase(kVariousArtists)) {
            artist = null;
        }
        MusicMetadata result = new MusicMetadata("filename");
        result.setAlbum(album);
        result.setArtist(artist);
        result.setSongTitle(song_title);
        if (track_number == null) return result;
        result.setTrackNumber(track_number);
        return result;
    }
}

