/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.metadata;

import java.util.Map;
import java.util.Vector;
import org.cmc.music.fs.FSParser;
import org.cmc.music.metadata.IMusicMetadata;
import org.cmc.music.metadata.MusicMetadata;
import org.cmc.music.myid3.ID3Tag;
import org.cmc.music.myid3.TagFormat;

public class MusicMetadataSet {
    public final ID3Tag id3v1Raw;
    public final ID3Tag.V2 id3v2Raw;
    public final MusicMetadata id3v1Clean;
    public final MusicMetadata id3v2Clean;
    public final MusicMetadata filename;
    public final MusicMetadata merged;
    public static final String newline = System.getProperty("line.separator");
    private static final TagFormat utils = new TagFormat();

    private MusicMetadataSet(ID3Tag id3_v1_raw, ID3Tag.V2 id3_v2_raw, MusicMetadata id3_v1_clean, MusicMetadata id3_v2_clean, String file_name, String folder_name) {
        this.id3v1Raw = id3_v1_raw;
        this.id3v2Raw = id3_v2_raw;
        this.id3v1Clean = id3_v1_clean;
        this.id3v2Clean = id3_v2_clean;
        this.filename = FSParser.parseFilename(file_name, folder_name);
        this.merged = new MusicMetadata("merged");
        this.merge();
    }

    public IMusicMetadata getSimplified() {
        return new MusicMetadata(this.merged);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{ID3TagSet. ");
        result.append(newline);
        result.append("v1_raw: " + this.id3v1Raw);
        result.append(newline);
        result.append("v2_raw: " + this.id3v2Raw);
        result.append(newline);
        result.append("v1: " + this.id3v1Clean);
        result.append(newline);
        result.append("v2: " + this.id3v2Clean);
        result.append(newline);
        result.append("filename: " + this.filename);
        result.append(newline);
        result.append("merged: " + this.merged);
        result.append(newline);
        result.append(" }");
        return result.toString();
    }

    private final void merge(Map src) {
        if (src == null) {
            return;
        }
        Vector keys = new Vector(src.keySet());
        int i = 0;
        while (i < keys.size()) {
            Object key = keys.get(i);
            if (this.merged.get(key) == null) {
                Object value = src.get(key);
                this.merged.put(key, value);
            }
            ++i;
        }
    }

    private final void merge() {
        if (this.id3v2Clean != null) {
            this.merged.putAll((Map)this.id3v2Clean);
        }
        this.merge(this.id3v1Clean);
        this.merge(this.filename);
    }

    public static final MusicMetadataSet factoryMethod(ID3Tag id3_v1_raw, ID3Tag.V2 id3_v2_raw, String filename, String folder_name) {
        MusicMetadata id3_v1_clean = id3_v1_raw == null ? null : utils.process(id3_v1_raw.values);
        MusicMetadata id3_v2_clean = id3_v2_raw == null ? null : utils.process(id3_v2_raw.values);
        return new MusicMetadataSet(id3_v1_raw, id3_v2_raw, id3_v1_clean, id3_v2_clean, filename, folder_name);
    }
}

