/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.Vector;
import org.cmc.music.util.BasicConstants;

public class TextUtils
implements BasicConstants {
    public static final String kALPHABET_NUMERALS = "0123456789";
    public static final String kALPHABET_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String kALPHABET_UPPERCASE = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    public static final String kALPHABET = "abcdefghijklmnopqrstuvwxyz" + kALPHABET_UPPERCASE;
    public static final String kFILENAME_SAFE = String.valueOf(kALPHABET) + "0123456789" + " ._-()&,[]";

    public static boolean isNumericDecimal(String s) {
        return TextUtils.isNumeric(s, false);
    }

    public static boolean isNumericInteger(String s) {
        return TextUtils.isNumeric(s, true);
    }

    private static boolean isNumeric(String s, boolean integer) {
        if (s == null) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (chars.length < 1) {
            return false;
        }
        boolean has_period = integer;
        boolean has_digit = false;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (i != 0 || c != '-') {
                if (Character.isDigit(c)) {
                    has_digit = true;
                } else if (c == '.' && !has_period) {
                    has_period = true;
                } else {
                    return false;
                }
            }
            ++i;
        }
        return has_digit;
    }

    public static String pad_left(String s, int length, String padding) {
        int i = 0;
        while (i < 10000 && s.length() < length) {
            s = String.valueOf(padding) + s;
            ++i;
        }
        return s;
    }

    public static String toTitleCase(String s) {
        StringBuffer result = new StringBuffer();
        char prev = '\u0000';
        if (s.startsWith("The Jackson 5 - I'Ll Be There")) {
            System.out.println(s);
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) {
                if (i == 0) {
                    result.append(Character.toUpperCase(c));
                } else if (prev == '\'') {
                    result.append(Character.toLowerCase(c));
                } else if (!Character.isLetter(prev)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(Character.toLowerCase(c));
                }
            } else {
                result.append(c);
            }
            prev = c;
            ++i;
        }
        return result.toString();
    }

    public static String insertSpacesBeforeCaps(String s) {
        StringBuffer result = new StringBuffer();
        char prev = '\u0000';
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isLetter(c) && i > 0 && Character.isLetter(prev) && Character.isLowerCase(prev) && Character.isUpperCase(c)) {
                result.append(' ');
            }
            result.append(c);
            prev = c;
            ++i;
        }
        return result.toString();
    }

    public static Vector tokenizeString(String s, String token) {
        int index;
        Vector<String> result = new Vector<String>();
        while (s.length() > 0 && (index = s.indexOf(token)) >= 0) {
            String left = s.substring(0, index);
            result.add(left);
            s = s.substring(index + token.length());
        }
        if (s.length() > 0) {
            result.add(s);
        }
        return result;
    }

    public static int findFirstWhiteSpace(String s) {
        if (s == null) {
            return -1;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Vector tokenizeByWhiteSpace(String s, boolean trim) {
        int index;
        Vector<String> result = new Vector<String>();
        while (s.length() > 0 && (index = TextUtils.findFirstWhiteSpace(s)) >= 0) {
            String left = s.substring(0, index);
            result.add(left);
            s = s.substring(index + 1);
            if (!trim) continue;
            s = s.trim();
        }
        if (s.length() > 0) {
            result.add(s);
        }
        return result;
    }

    public static String toSafeFilename(String s) {
        StringBuffer result = new StringBuffer();
        s = s.trim();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (kFILENAME_SAFE.indexOf(c) >= 0) {
                result.append(c);
            }
            ++i;
        }
        String filtered = result.toString();
        while (filtered.startsWith(".")) {
            filtered = filtered.substring(1);
        }
        while (filtered.endsWith(".")) {
            filtered = filtered.substring(0, filtered.length() - 1);
        }
        return filtered;
    }

    public static String filter(String s, String filter) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (filter.indexOf(c) >= 0) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public static String head(String s, int count) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String[] lines = TextUtils.split(s, newline);
        if (lines.length < count) {
            count = lines.length;
        }
        String[] lines2 = new String[count];
        System.arraycopy(lines, 0, lines2, 0, count);
        return TextUtils.join(lines2, newline);
    }

    public static String tail(String s, int count) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String[] lines = TextUtils.split(s, newline);
        if (lines.length < count) {
            count = lines.length;
        }
        String[] lines2 = new String[count];
        System.arraycopy(lines, lines.length - count, lines2, 0, count);
        return TextUtils.join(lines2, newline);
    }

    public static int getLineCount(String s) {
        if (s == null || s.length() < 1) {
            return 0;
        }
        String[] lines = TextUtils.split(s, newline);
        return lines.length;
    }

    public String urlEncode(String aURLFragment) {
        String result = null;
        try {
            result = URLEncoder.encode(aURLFragment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public String escapeHTMLSpecialCharacters(String s) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(s);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public String toDisableHTMLTags(String aText) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public String forRegex(String aRegexFragment) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\.");
            } else if (character == '\\') {
                result.append("\\\\");
            } else if (character == '?') {
                result.append("\\?");
            } else if (character == '*') {
                result.append("\\*");
            } else if (character == '+') {
                result.append("\\+");
            } else if (character == '&') {
                result.append("\\&");
            } else if (character == ':') {
                result.append("\\:");
            } else if (character == '{') {
                result.append("\\{");
            } else if (character == '}') {
                result.append("\\}");
            } else if (character == '[') {
                result.append("\\[");
            } else if (character == ']') {
                result.append("\\]");
            } else if (character == '(') {
                result.append("\\(");
            } else if (character == ')') {
                result.append("\\)");
            } else if (character == '^') {
                result.append("\\^");
            } else if (character == '$') {
                result.append("\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static final String[] split(String s, char token) {
        return TextUtils.split(s, "" + token);
    }

    public static final String[] split(String s, String token) {
        int index;
        Vector<String> result = new Vector<String>();
        while ((index = s.indexOf(token)) >= 0) {
            result.add(s.substring(0, index));
            s = s.substring(index + token.length());
        }
        result.add(s);
        String[] splits = new String[result.size()];
        int i = 0;
        while (i < result.size()) {
            splits[i] = (String)result.get(i);
            ++i;
        }
        return splits;
    }

    public static String replace(String s, String find, String replaceto) {
        int index;
        if (s == null) {
            return s;
        }
        StringBuffer result = new StringBuffer();
        while ((index = s.indexOf(find)) >= 0) {
            result.append(s.substring(0, index));
            result.append(replaceto);
            s = s.substring(index + find.length());
        }
        result.append(s);
        return result.toString();
    }

    public static final String join(String[] splits, String token) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < splits.length) {
            if (i > 0) {
                result.append(token);
            }
            result.append(splits[i]);
            ++i;
        }
        return result.toString();
    }
}

