/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.util.Log;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;

class BugProfiler {
    private static BugProfiler instance = null;
    private static final int MAX_LIFETIME = 60;
    private final StringBuilder trackCpu = new StringBuilder();
    private final StringBuilder trackMem = new StringBuilder();
    private static String currentTag = "";
    private static int currentStep = 2;
    private static int runningFor = 0;
    private static boolean running = false;

    BugProfiler() {
    }

    protected static BugProfiler getProfiler() {
        if (instance == null) {
            instance = new BugProfiler();
        }
        return instance;
    }

    protected void startProfiling(String string, int n) {
        if (string.equals(currentTag) && running) {
            Log.w((String)G.TAG, (String)("Profiler with name " + string + " is already running!"));
        } else {
            currentTag = string;
            Log.i((String)G.TAG, (String)("Profiling tag set to " + string));
            if (n <= 0 || n > 60) {
                Log.i((String)G.TAG, (String)"Profiling step must be greater than 0s and lower than 60s. ");
                n = 2;
            }
            currentStep = n;
            Log.i((String)G.TAG, (String)("Profiling step set to " + String.valueOf(currentStep) + " seconds"));
            if (this.trackCpu != null) {
                this.trackCpu.setLength(0);
            }
            if (this.trackMem != null) {
                this.trackMem.setLength(0);
            }
            this.startThread();
        }
    }

    protected void stopProfiling(String string) {
        if (running && string.equals(currentTag)) {
            Log.i((String)G.TAG, (String)("Stopping profiler with tag " + string));
            running = false;
        }
        Log.i((String)"CPU", (String)this.trackCpu.toString());
        Log.i((String)"MEM", (String)this.trackMem.toString());
    }

    private void startThread() {
        running = true;
        runningFor = 0;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (running) {
                    BugProfiler.this.trackCpu.append(Utils.getCPU() + "|");
                    BugProfiler.this.trackMem.append(Utils.getMem() + "|");
                    try {
                        Thread.sleep(currentStep * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    runningFor += currentStep;
                    if (runningFor <= 60) continue;
                    BugProfiler.this.stopProfiling(currentTag);
                    Log.i((String)G.TAG, (String)"Profiling exceeded max profiling time, stopping!");
                }
            }
        }).start();
    }
}

