<?php
// FileSystem CharacterSet Converter(fs_converter.php) for moodle1.8/1.9
// Progammed by T.Shirai (Suzuka National College of Technology, Japan).
// http://www.suzuka-ct.ac.jp/mech/~shirai/index.html
// mailto:shirai@mech.suzuka-ct.ac.jp

require_once($CFG->libdir.'/moodlelib.php');  // check_browser_version()を使うために．

// (Shirai106): 電子メール送信時の自動ワードラップ処理の文字数を指定可能とする改良 (2008/12/15)
// ワードラップする境目の文字数の最小値の制限．基本的には変更の必要なし．日本語ならば１０文字相当．
define('MIN_WORDWRAPWIDTH', 20);

// fs_moodle4から新設（fs_moodle固有の設定を保存する標準のフォルダ）
define('FSCONFIGDIR', $CFG->dataroot.'/config');

// (Shirai183): カレンダーの土日と祝日に文字色を付ける改良 (2010/04/01)
define('FSCALENDARCOLOR_SAT',     '#0000FF');
define('FSCALENDARCOLOR_SUN',     '#FF0000');
define('FSCALENDARCOLOR_HOLIDAY', '#0000FF');

// (Shirai187): 電子メールでブログを投稿する機能 (2010/05/12)
define('M2B_DEFAULT_LOG_FILENAMEFORMAT', 'mail2blog.log');
define('M2B_MINIMUM_USERCODE_LENGTH', 5);
define('M2B_USERFIELDNAME_KEY', 'MAIL2BLOGKEY');

//------------------------------------------------------------------------
global $USER;
global $needtocreatefsconfig;
$needtocreatefsconfig = false;

if (!isset($fsCFG->fsCharset)) {
    unset($fsCFG);
    $fsCFG = new stdClass();

    // fs化に必須の関数群
    require_once($CFG->libdir.'/fs_moodle/fs_lib.php');

    // fs化とは関係なく使える便利な関数群の読み込み
    require_once($CFG->libdir.'/fs_moodle/jp_lib.php');

    // fsconfig_option.phpで設定を追加するのに用いる関数群の読み込み
    require_once($CFG->libdir.'/fs_moodle/fs_config_option_lib.php');

    // Moodleの互換性に関係のある旧式の関数群の読み込み
    require_once($CFG->libdir.'/fs_moodle/fs_deprecatedlib.php');

    // Check fsconfig.php
    require_once($CFG->libdir.'/fs_moodle/fs_lib_first.php');
    if (file_exists(FSCONFIGDIR.'/fsconfig.php')) {
        // 設定ファイルの読み込み（新しい位置）: fs_moodle4からは強制的にこちらを使用する予定
        require_once(FSCONFIGDIR.'/fsconfig.php');
    } else {
        if (file_exists($CFG->dirroot.'/fsconfig.php')) {
            // 設定ファイルの読み込み（従来の位置）
            require_once($CFG->dirroot.'/fsconfig.php');
        } else {
            // $fsCFGを全て初期値に設定することで，一応は動作するようにする．
            require_once($CFG->libdir.'/fs_moodle/fs_status/fs_switch_strings.php');
            require_once($CFG->libdir.'/fs_moodle/fs_status/fs_cfg_strings.php');
            foreach ($fs_cfg_strings as $cfgname => $fs_cfg_string) {
                $fsCFG->$cfgname = get_fs_cfg_default($cfgname);
            }
            $needtocreatefsconfig = true;
        }
    }

    // バージョン情報(fs_moodle）の読み込み
    require_once($CFG->libdir.'/fs_moodle/version.php');

    // 変数の設定忘れをチェックして警告
    // 一時的に初期設定値を利用するが，[fs_moodleの設定表示]でfsconfig.phpを更新することを勧める．
    // 特殊な設定についてのみ特例を記述する．
    require_once($CFG->libdir.'/fs_moodle/fs_status/fs_cfg_strings.php');
//  require_once($CFG->libdir.'/fs_moodle/fs_status/fs_switch_strings.php');
    if (!$needtocreatefsconfig) {
        $fsCFG->novariable = '';
        check_fscfg_set_warning();
    }

    // PHP標準のファイルI/O関数のオーバーライド（fs関数）の読み込み
    if (($fsCFG->fsCharset != false) && ($fsCFG->fsCharset != 'UTF-8')) {
        // 関数をオーバーライドする
        require_once($CFG->libdir.'/fs_moodle/fs_override.php');
    } else {
        // 関数をオーバーライドしないことでオーバーヘッドを極力減らす
        require_once($CFG->libdir.'/fs_moodle/fs_no_override.php');
    }

    // RSSのセキュリティ向上のために利用する関数群
    require_once($CFG->libdir.'/fs_moodle/rsslib.php');

    // チャットでハンドルネームを利用するための関数群
    require_once($CFG->libdir.'/fs_moodle/chat.php');

    // PDF2JPEG機能で使用する関数群
    require_once($CFG->libdir.'/fs_moodle/pdf2jpeg.php');

// (IE_Problem022): サーバにIISを用いた場合に$_SERVER変数の中の日本語文字がシフトJISに強制的に変換されてしまうためにファイルをダウンロードできない問題（"スラッシュを使う"がOffの場合） (2008/04/09) 
// これはIEがOBJECTタグのdata=のURLを勝手にシフトJISに変換してしまう問題(2008/04/21)にも関係している．
// (IE_Problem022): ここから追加
    if (($fsCFG->convUTF8serverVariable) || (fs_check_browser_version('MSIE'))) {
    	if (isset($_SERVER['PATH_TRANSLATED']))
    	    $_SERVER['PATH_TRANSLATED']      = mb_convert_encoding($_SERVER['PATH_TRANSLATED'],      'UTF-8', 'auto');
    	if (isset($_SERVER['REQUEST_URI']))
    	    $_SERVER['REQUEST_URI']          = mb_convert_encoding($_SERVER['REQUEST_URI'],          'UTF-8', 'auto');
    	if (isset($_SERVER['URL']))
    	    $_SERVER['URL']                  = mb_convert_encoding($_SERVER['URL'],                  'UTF-8', 'auto');
    	if (isset($_SERVER['ORIG_PATH_INFO']))
    	    $_SERVER['ORIG_PATH_INFO']       = mb_convert_encoding($_SERVER['ORIG_PATH_INFO'],       'UTF-8', 'auto');
    	if (isset($_SERVER['PATH_INFO']))
    	    $_SERVER['PATH_INFO']            = mb_convert_encoding($_SERVER['PATH_INFO'],            'UTF-8', 'auto');
    	if (isset($_SERVER['ORIG_PATH_TRANSLATED']))
    	    $_SERVER['ORIG_PATH_TRANSLATED'] = mb_convert_encoding($_SERVER['ORIG_PATH_TRANSLATED'], 'UTF-8', 'auto');
// (FS_TEST)
/*
        foreach ($_POST as $KEY => $VAL) $_POST[$KEY] = mb_convert_encoding($VAL, 'UTF-8', 'auto');
        foreach ($_GET  as $KEY => $VAL) $_GET[$KEY]  = mb_convert_encoding($VAL, 'UTF-8', 'auto');
        $_SERVER['SCRIPT_NAME']         = mb_convert_encoding($_SERVER['SCRIPT_NAME'],           'UTF-8', 'auto');
        $_SERVER['SCRIPT_FILENAME']     = mb_convert_encoding($_SERVER['SCRIPT_FILENAME'],       'UTF-8', 'auto');
        $_SERVER['PHP_SELF']            = mb_convert_encoding($_SERVER['PHP_SELF'],              'UTF-8', 'auto');
*/
// (FS_TEST)
    }
// (IE_Problem022): ここまで追加

// (Shirai114): 小型携帯端末での表示を可能な限り改善するための改良 (2009/01/17)
    $fsCFG->noArrowFont = array('Nintendo DS', 'PSP', 'NetFront', 'SHARP/WS', 'IS01', 'Android');

// (Shirai183): カレンダーの土日と祝日に文字色を付ける改良 (2010/04/01)
    fs_add_eventcolor('H:', '#FF0000', '初期設定値', true);
}

?>
