<?php
// fsconfig.phpを出力する (fs_moodle4以降）のライブラリ

class fsconfig_output {
    var $display_cfg;   // 作成したfsconfig.phpの中身を表示するか
    var $fname;         // ファイル出力時のファイル名
    var $fullpath;      // ファイル出力時のフルパス（ファイル名を含まない）
    var $contents;      // 作成されたfsconfig.phpの中身（文字列）
    var $overwrite;     // fsconfig.phpを上書きする（注意！）
    // コンストラクタ
    function fsconfig_output() {
        $this->display_cfg  = false;
        $this->fname = $this->fullpath = '';
        $this->contents = '';
        $this->overwrite = false;
    }
    // [A] 状態変更（処理前に行う）
    // (1) ダウンロード用出力＋表示
    function set_display_on() {
        $this->display_cfg = true;
    }
    // (2) ダウンロード用出力のみ
    function set_download_on() {
        $this->display_cfg = false;
    }
    // (3) 上書き出力
    function set_overwrite() {
        $this->display_cfg = true;
        $this->overwrite   = true;
    }
    // [B] 内部処理用関数 // PHP4に対応するためpublic/privateの指定はしない
    // (1) 改行付きで文字列を出力
    function writeln($str = '')
    {
        if ($this->display_cfg) echo htmlspecialchars($str).'<br />';
        return $str."\n";
    }
    // (2) 改行なしで文字列を出力
    function write($str = '')
    {
        if ($this->display_cfg) echo htmlspecialchars($str);
        return $str;
    }
    // (3) セパレータを出力
    function write_separator($cnt = 80)
    {
        return $this->writeln(str_pad('// ', $cnt, '-'));
    }
    // (4) コメントを出力
    function write_comment($str)
    {
        return $this->writeln('// '.$str);
    }
    // (5) 警告などを出力(print_string() or print_error())
    function message($label, $file = '', $arg = '') {
        if ($this->display_cfg) print_string($label, $file, $arg);
          else                  print_error($label,  $file, $arg);
    }

    // [C] 外部公開用関数
    // (1) fsconfig.phpを生成（$SESSIONと$fsCFGに基づいて）
    function generate_fsconfig_str()
    {
        global $fs_cfg_strings, $fs_switch_strings;
        global $fsCFG, $CFG;
        global $SESSION;

        $this->contents = $this->writeln('<?php');
        $this->contents .= $this->write_separator();
        $this->contents .= $this->write_comment('自動生成されたfsconfig.php');
        $this->contents .= $this->write_comment('Date: '.date('c', time()));
        $this->contents .= $this->write_comment('Release: '.$fsCFG->release);
        $this->contents .= $this->write_comment('Version: '.$fsCFG->version);
        $this->contents .= $this->write_separator();
        // プレビュー表示で画面に表示されるfsconfig.phpでは以下のメッセージを表示したくない
        if (!$this->display_cfg || $this->overwrite) {
            $this->contents .= $this->write_comment('このファイルと同じものがフォルダ'.FSCONFIGDIR.'にコピーしてあります．');
            $this->contents .= $this->write_comment('このファイルは基本的に手作業で編集するものではありません．');
            $this->contents .= $this->write_comment('[fs_moodleの設定表示]：'.$CFG->wwwroot.'/lib/fs_moodle/fs_status/index.php をご利用下さい．');
            $this->contents .= $this->write_separator();
        }
        $this->contents .= $this->writeln();
        $this->contents .= $this->write_separator();
        $this->contents .= $this->write_comment('[A] パラメータ');
        $this->contents .= $this->write_separator();
        $this->contents .= $this->writeln();
        $cnt = 1;
        foreach ($fs_cfg_strings as $cfgname => $fs_cfg_string) {
            $this->contents .= $this->write_comment('('.$cnt.') '.title_fs_cfg($cfgname));
            $this->contents .= $this->write('$fsCFG->'.$cfgname.' = ');
            $cfgtypedata = $fs_cfg_strings[$cfgname];
            if (isset($SESSION->fscfg->$cfgname)) {
                // 変更されたパラメータ
                $value = $SESSION->fscfg->$cfgname;
            } else {
                // 現在のパラメータ
                $value = $fsCFG->$cfgname;
            }
            if (is_string($value)) {
                if (strcasecmp($value, 'false') == 0) $value = false;
                if (strcasecmp($value, 'true' ) == 0) $value = true;
            }
            if (is_string($value))      $this->contents .= $this->write('"'.$value.'";');
              else if (is_bool($value)) $this->contents .= $this->write(($value == true ? 'true;' : 'false;'));
              else                      $this->contents .= $this->write($value.';');
            if (isset($SESSION->fscfg->$cfgname)) $this->writeln(' // Changed');
              else                                $this->writeln();
            $this->contents .= $this->writeln();
            $cnt++;
        }

        $this->contents .= $this->write_separator();
        $this->contents .= $this->write_comment('[B] スイッチ');
        $this->contents .= $this->write_separator();
        $this->contents .= $this->writeln();
        $cnt = 1;
        foreach ($fs_switch_strings as $defname => $fs_switch_string) {
            // $defnameのチェック
            if (substr($defname, 0, 10) == 'FS_ENABLE_') $fs_enable_switch = true;
              else                                       $fs_enable_switch = false;
            $this->contents .= $this->write_comment('('.$cnt.') '.title_fs_switch($defname));
            if (isset($SESSION->fscfg->$defname)) {
                if ($SESSION->fscfg->$defname) {
                    if (!$fs_enable_switch) $this->contents .= $this->write('// ');
                } else {
                    if ($fs_enable_switch)  $this->contents .= $this->write('// ');
                }
                $this->contents .= $this->writeln("define('".$defname."', true); // Changed");
            } else {
                if (defined($defname)) {
                    $this->contents .= $this->writeln("define('".$defname."', ".(constant($defname) == true ? 'true' : 'false').');');
                } else {
                    $this->contents .= $this->writeln("// define('".$defname."', true);");
                }
            }
            $this->contents .= $this->writeln();
            $cnt++;
        }
        $this->contents .= $this->writeln('?>');
        return $this->contents;
    }
    // (2) 生成済みのfsconfig.phpの中身をファイルに保存する
    function copy_fsconfig($fname = '', $fullpath = '')
    {
        // 生成済みか？
        if (empty($this->contents)) {
            $this->message('error_doesnotexistcontents', 'fs_moodle');
            die;
        }
        // フォルダを確認
        fs_check_config_folder($this->display_cfg);
        // ファイルを作成
        // ファイル名の作成
        if (empty($fname)) $this->fname = 'fsconfig_'.date('YmdHis', time()).'.php';
          else             $this->fname = $fname;
        // フルパス（ファイル名を除く）の作成
        if (empty($fullpath)) $this->fullpath = FSCONFIGDIR;
          else                $this->fullpath = $fullpath;
        $filename = $this->fullpath.'/'.$this->fname;
        // 重複確認
        if (fs_file_exists($filename)) {
            if ($this->overwrite) {
                // もし上書き対象ファイルが存在するならば拡張子をbakに変更してバックアップ（既に存在するものは削除）．
                $bakfilename = change_extension($filename, 'bak');
                if (fs_file_exists($bakfilename)) unlink($bakfilename);
                rename($filename, $bakfilename);
            } else {
                $this->message('error_alreadyexists', 'fs_moodle', $this->fname);
                die;
            }
        }
        $status = fs_file_put_contents($filename, $this->contents);
        if (!$status or !fs_file_exists($filename)) {
            $this->message('error_cannotmakefile', 'fs_moodle', $this->fname);
            die;
        }
    }
    // (3) 最後に出力したfsconfig.phpのファイル名を取得
    function get_fname() {
        return $this->fname;
    }
    // (4) 最後に出力したfsconfig.phpのフルパス名を取得（ファイル名を除く）
    function get_fullpath() {
        return $this->fullpath;
    }
    // (5) 作成済みのfsconfig.phpをダウンロード（送信）する
    function send_file($fname = '') {
        // 生成済みか？
        if (empty($this->contents)) {
            $this->message('error_doesnotexistcontents', 'fs_moodle');
            die;
        }
        $filename = $this->fullpath.'/'.$this->fname;
        // 作成済みか？
        if (empty($this->fname) or !fs_file_exists($filename)) {
            $this->message('error_filedoesnotexist', 'fs_moodle', $this->fname);
            die;
        }
        if (empty($fname)) $fname = $this->fname;
        send_file($filename, $fname);
    }
    // (6) モードにしたがって一気に生成，作成，出力を行う：テンポラリ作成およびダウンロードあるいは表示
    function generate2send($downloadfilename = '')
    {
        // 生成
        $this->generate_fsconfig_str();

        if (!$this->display_cfg) {
            // ファイル出力
            $this->copy_fsconfig();
            $this->send_file($downloadfilename);
        }
    }
    function overwrite_fsconfig()
    {
        // 生成
        $this->overwrite = true;
        $this->generate_fsconfig_str();

        // ファイル出力
        $this->copy_fsconfig('fsconfig.php');
    }

}
?>
