###############################################################################
#
# åHTMLѡ
#
###############################################################################
package Wiki::CacheParser;
use Wiki::HTMLParser;
use vars qw(@ISA);
@ISA = qw(Wiki::HTMLParser);
#==============================================================================
# <p>
# 󥹥ȥ饯
# </p>
#==============================================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	my $self  = Wiki::HTMLParser->new($wiki,0);
	return bless $self,$class;
}

#==============================================================================
# <p>
# إåɥ饤
# </p>
#==============================================================================
sub l_headline {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	my $wiki  = $self->{wiki};
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $html  = join("",@$obj);

	$self->{html} .= "<h".($level+1)."><!--p=".$self->{p_cnt}."-->".$html."<!--/p--></h".($level+1).">\n";
	$self->{p_cnt}++;
}

#==============================================================================
# <p>
# ץ饰
# </p>
#==============================================================================
sub plugin {
	my $self   = shift;
	my $plugin = shift;
	
	my $html = "\n<!--inline_plugin=".$plugin->{command}."-->\n";
	foreach my $arg (@{$plugin->{args}}){
		$html .= "  <!--arg=$arg-->\n";
	}
	$html .= "<!--/inline_plugin-->\n";
	
	return ($html);
}

#==============================================================================
# <p>
# ѥ饰եץ饰
# </p>
#==============================================================================
sub l_plugin {
	my $self   = shift;
	my $plugin = shift;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $html = "\n<!--paragraph_plugin=".$plugin->{command}."-->\n";
	foreach my $arg (@{$plugin->{args}}){
		$html .= "  <!--arg=$arg-->\n";
	}
	$html .= "<!--/paragraph_plugin-->\n";

	if(defined($html) && $html ne ""){
		$self->{html} .= $html;
	}
}

#==============================================================================
# <p>
# åưŪʬޤ
# ¾Υ⥸塼뤫Ѥ뤿ᡢ᥽åɤǤϤʤؿȤƼƤޤ
# ʲΤ褦ˤƻѤޤ
# </p>
# <pre>
# my $cache = Wiki::CacheParserǺHTMLåʸ;
# my $main  = ᥤΰξ1ɥСإåեåΰξ0;
# my $html  = &amp;Wiki::CacheParser::process_cache($wiki,$cache,$main);
# </pre>
#==============================================================================
sub process_cache {
	my $wiki = shift;
	my $html = shift;
	my $main = shift;

	my $result = "";
	my $count  = 0;
	my $parser = Wiki::HTMLParser->new($wiki,$main);

	$html =~ s/\r//g;
	my @lines = split(/\n/,$html);

	for($count=0;$count<=$#lines;$count++){
		$parser->{html} = "";
		my $line = $lines[$count];
		# Фν
		if($line =~ /<!--p=([0-9]+?)-->/){
			if($main){
				$line =~ s/<!--p=([0-9]+?)-->/<a name="p$1">/;
				$parser->{p_cnt} = $1 + 1;
				$line =~ s/<!--\/p-->/<\/a>/;
			}
			$result .= $line;
		# 饤ץ饰ν
		} elsif($line =~ /<!--inline_plugin=(.+?)-->/){
			my $plugin = {command=>$1,args=>[]};
			while(!($lines[$count] =~ /<!--\/inline_plugin-->/)){
				if($lines[$count] =~ /<!--arg=(.+?)-->/){
					push(@{$plugin->{args}},$1);
				}
				$count++;
			}
			my @plugin_result = $wiki->process_plugin($plugin,$parser);
			$result .= join("",@plugin_result);
			
		# ѥ饰եץ饰ν
		} elsif($line =~ /<!--paragraph_plugin=(.+?)-->/){
			my $plugin = {command=>$1,args=>[]};
			while(!($lines[$count] =~ /<!--\/paragraph_plugin-->/)){
				if($lines[$count] =~ /<!--arg=(.+?)-->/){
					push(@{$plugin->{args}},$1);
				}
				$count++;
			}
			my $plugin_result = $wiki->process_plugin($plugin,$parser);
			if(defined($plugin_result) && $plugin_result ne ""){
				$result .= $plugin_result;
			} else {
				$result .= $parser->{html};
			}
		} else {
			$result .= $line."\n";
		}
	}
	return $result;
}

1;
