###############################################################################
#
# ɥѡ
#
###############################################################################
package Wiki::Keyword;
use strict;

#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	my $interwiki = shift;
	
	my $self  = {};
	$self->{wiki} = $wiki;
	$self->{keywords} = [];
	$self->{interwiki} = $interwiki;
	
	$self->{eucpre}  = qr{(?<!\x8F)};
	$self->{eucpost} = qr{(?=
		(?:[\xA1-\xFE][\xA1-\xFE])* # JIS X 0208  0ʸʾ³
		(?:[\x00-\x7F\x8E\x8F]|\z)  # ASCII, SS2, SS3 ޤϽü
	)}x;
	
	$self = bless($self,$class);
	$self->parse;
	return $self;
}

#==============================================================================
# ɤޤޤ뤫ɤå
#==============================================================================
sub exists_keyword {
	my $self = shift;
	my $str  = shift;
	
	my $eucpre  = $self->{eucpre};
	my $eucpost = $self->{eucpost};
	
	my @keywords = @{$self->{keywords}};
	
	foreach my $keyword (@keywords){
		my $word = quotemeta($keyword->{word});
		#if($str =~ /$eucpre(?:$word)$eucpost/){
		if($str =~ /$word/){
			$self->{g_pre}   = $`;
			$self->{g_post}  = $';
			$self->{g_label} = $keyword->{word};
			$self->{g_url}   = $keyword->{url};
			$self->{g_page}  = $keyword->{page};
			return 1;
		}
	}
	return 0;
}

#==============================================================================
# ǥХå
#==============================================================================
sub print_string {
	my $self = shift;
	my @keywords = @{$self->{keywords}};
	foreach(@keywords){
		print $_->{word},"-",$_->{url},"-",$_->{page},"\n";
	}
}

#==============================================================================
# ѡʥ󥹥ȥ饯ƤФޤ
#==============================================================================
sub parse {
	my $self = shift;
	my $wiki = $self->{wiki};
	if($wiki->page_exists("Keyword")){
		my $source = $wiki->get_page("Keyword");
		$source =~ s/\r//g;
		my @lines = split(/\n/,$source);
		foreach my $line (@lines){
			if(index($line,"*")==0){
				$self->parse_line($line);
			}
		}
	}
	if($self->{wiki}->config('auto_keyword_page')==1){
		my @pages = $wiki->get_page_list;
		# A,B,A+BȤȤ
		# A+BΥɤA,Bʬ򤵤ʤ褦ʸĹǥ
		@pages = sort {
			my $len_a = length($a);
			my $len_b = length($b);
			return $len_b <=> $len_a;
	    } @pages;
		foreach my $page (@pages){
			$self->parse_line("[[$page|$page]]");
		}
	}
}

sub parse_line {
	my $self   = shift;
	my $source = shift;
	
	# ̾
	if($source =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?&=:;\*#\@']*)\]/
	|| $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/
	|| $source =~ /\[([^\[]+?)\|((\/|\.\/|\.\.\/)+[a-zA-Z0-9\.,%~^_+\-%\/\?&=:;\*#\@']*)\]/){
	
		my $label = $1;
		my $url   = $2;
		$self->url_anchor($url,$label);
	
	# InterWiki
	} elsif($self->{interwiki}->exists_interwiki($source)){
		my $pre   = $self->{interwiki}->{g_pre};
		my $post  = $self->{interwiki}->{g_post};
		my $label = $self->{interwiki}->{g_label};
		my $url   = $self->{interwiki}->{g_url};
		$self->url_anchor($url,$label);
 
	# ڡ̾
	} elsif($source =~ /\[\[([^\[]+?)\|(.+?)\]\]/){
		my $label = $1;
		my $page  = $2;
		$self->wiki_anchor($page,$label);
	}
}

#==============================================================================
# URL
#==============================================================================
sub url_anchor {
	my $self = shift;
	my $url  = shift;
	my $name = shift;
	
	if($name eq ""){
		$name = $url;
	}
	my $keyword = {};
	$keyword->{word} = $name;
	$keyword->{url}  = $url;
	push(@{$self->{keywords}},$keyword);
}

#==============================================================================
# Wiki
#==============================================================================
sub wiki_anchor {
	my $self = shift;
	my $page = shift;
	my $name = shift;
	
	if($name eq ""){
		$name = $page;
	}
	my $keyword = {};
	$keyword->{word} = $name;
	$keyword->{page} = $page;
	push(@{$self->{keywords}},$keyword);
}

1;
